/*******************************************************************************
 * Copyright (c) 2006 - 2008 Ecliptical Software Inc. and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Ecliptical Software Inc. - initial API and implementation
 *******************************************************************************/
package org.eclipse.emf.mint;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.mint.internal.MemberAnnotationManager;
import org.osgi.framework.BundleContext;

/**
 * Mint Core plugin class.
 * 
 * @noinstantiate This class is not intended to be instantiated by clients.
 */
public final class MintCore extends Plugin {

	/**
	 * Mint Core plugin identifier (value {@value} ).
	 */
	public static final String PLUGIN_ID = "org.eclipse.emf.mint"; //$NON-NLS-1$

	private static MintCore instance;

	private MemberAnnotationManager manager;

	/**
	 * Creates the Mint core plugin.
	 * 
	 * @noreference This constructor is not intended to be referenced by
	 *              clients.
	 */
	public MintCore() {
		instance = this;
	}

	/**
	 * Returns the singleton instance of this plugin.
	 * 
	 * @return instance of this plugin
	 */
	public static MintCore getInstance() {
		return instance;
	}

	/**
	 * Stops the plugin instance.
	 * 
	 * @noreference This method is not intended to be referenced by clients.
	 */
	public void stop(BundleContext context) throws Exception {
		if (manager != null) {
			manager.dispose();
			manager = null;
		}

		super.stop(context);
	}

	/**
	 * Creates a {@link IStatus status} object with the given message and
	 * exception and logs it to the platform log.
	 * 
	 * @param message
	 *            optional message (a default message is substituted if {@code
	 *            null})
	 * @param t
	 *            optional exception to log
	 * @return newly created status object
	 * @noreference This method is not intended to be referenced by clients.
	 */
	public IStatus logError(String message, Throwable t) {
		if (message == null)
			message = Messages.MintCore_UnexpectedError;

		IStatus status = new Status(IStatus.ERROR, PLUGIN_ID, 0, message, t);
		getLog().log(status);
		return status;
	}

	/**
	 * Returns the singleton instance of {@link IMemberAnnotationManager}.
	 * 
	 * @return member annotation manager
	 */
	public synchronized IMemberAnnotationManager getMemberAnnotationManager() {
		if (manager == null)
			manager = new MemberAnnotationManager();

		return manager;
	}
}
