/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.properties.internal.metadata;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecoretools.properties.internal.Messages;
import org.eclipse.emf.ecoretools.tabbedproperties.EMFRecordingChangeCommand;
import org.eclipse.emf.ecoretools.tabbedproperties.sections.AbstractTabbedPropertySection;
import org.eclipse.emf.ecoretools.tabbedproperties.utils.TextChangeListener;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class NameSection
extends AbstractTabbedPropertySection {
    private boolean isRefreshing = false;
    private Text nameTxt;
    private CLabel labelTxt;

    protected void createWidgets(Composite composite) {
        this.labelTxt = this.getWidgetFactory().createCLabel(composite, this.getLabelText());
        this.nameTxt = this.getWidgetFactory().createText(composite, "");
    }

    protected void setSectionData(Composite composite) {
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.nameTxt, -5);
        data.top = new FormAttachment(0, 4);
        this.labelTxt.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, this.getStandardLabelWidth(composite, new String[]{this.getLabelText()}));
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.labelTxt, 0, 0x1000000);
        this.nameTxt.setLayoutData((Object)data);
    }

    protected void hookListeners() {
        TextChangeListener listener = new TextChangeListener(){

            public void textChanged(Control control) {
                NameSection.this.handleTextModified();
            }
        };
        listener.startListeningTo((Control)this.nameTxt);
        listener.startListeningForEnter((Control)this.nameTxt);
    }

    protected void handleTextModified() {
        if (!this.isRefreshing) {
            final String newName = this.nameTxt.getText();
            EditingDomain editingDomain = this.getEditingDomain();
            if (this.getEObjectList().size() == 1) {
                String oldName = this.getName(this.getEObject());
                if (oldName != null && !oldName.equals(newName)) {
                    editingDomain.getCommandStack().execute((Command)new EMFRecordingChangeCommand(this.getEObject().eResource()){

                        protected void doExecute() {
                            if (NameSection.this.getEObject() instanceof EStructuralFeature) {
                                ExtendedMetaData.INSTANCE.setName((EStructuralFeature)NameSection.this.getEObject(), newName);
                            }
                            if (NameSection.this.getEObject() instanceof EClassifier) {
                                ExtendedMetaData.INSTANCE.setName((EClassifier)NameSection.this.getEObject(), newName);
                            }
                        }
                    });
                }
            } else {
                CompoundCommand compoundCommand = new CompoundCommand();
                for (final EObject nextObject : this.getEObjectList()) {
                    String oldName = this.getName(nextObject);
                    if (oldName == null || oldName.equals(newName)) continue;
                    editingDomain.getCommandStack().execute((Command)new EMFRecordingChangeCommand(nextObject.eResource()){

                        protected void doExecute() {
                            if (nextObject instanceof EStructuralFeature) {
                                ExtendedMetaData.INSTANCE.setName((EStructuralFeature)nextObject, newName);
                            }
                            if (nextObject instanceof EClassifier) {
                                ExtendedMetaData.INSTANCE.setName((EClassifier)nextObject, newName);
                            }
                        }
                    });
                }
                editingDomain.getCommandStack().execute((Command)compoundCommand);
            }
        }
    }

    private String getName(EObject model) {
        if (model instanceof EStructuralFeature) {
            return ExtendedMetaData.INSTANCE.getName((EStructuralFeature)model);
        }
        if (model instanceof EClassifier) {
            return ExtendedMetaData.INSTANCE.getName((EClassifier)model);
        }
        return "";
    }

    public void refresh() {
        this.isRefreshing = true;
        this.nameTxt.setText(this.getName(this.getEObject()));
        this.isRefreshing = false;
    }

    protected EStructuralFeature getFeature() {
        return null;
    }

    protected String getLabelText() {
        return Messages.NameSection_Name;
    }
}

