/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.emf.compare.EMFCompareMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassUtils {
    private static final Class<?>[] PRIMITIVES = new Class[]{Short.TYPE, Integer.TYPE, Long.TYPE, Byte.TYPE, Character.TYPE, Boolean.TYPE, Float.TYPE, Double.TYPE, Void.TYPE};
    private static final Class<?>[] WRAPPERS = new Class[]{Short.class, Integer.class, Long.class, Byte.class, Character.class, Boolean.class, Float.class, Double.class, Void.class};

    private ClassUtils() {
    }

    public static boolean classEquals(Class<?> class1, Class<?> class2) {
        if (class1 == null || class2 == null) {
            throw new IllegalArgumentException(EMFCompareMessages.getString("ClassUtils.NullArguments"));
        }
        boolean result = false;
        if (class1 != class2 && !class1.equals(class2)) {
            if (class1.isPrimitive()) {
                int i = 0;
                while (i < PRIMITIVES.length) {
                    if (class1.equals(PRIMITIVES[i])) {
                        result = class2.equals(WRAPPERS[i]);
                        break;
                    }
                    ++i;
                }
            } else if (class2.isPrimitive()) {
                int i = 0;
                while (i < PRIMITIVES.length) {
                    if (class2.equals(PRIMITIVES[i])) {
                        result = class1.equals(WRAPPERS[i]);
                        break;
                    }
                    ++i;
                }
            }
        } else {
            result = true;
        }
        return result;
    }

    public static boolean hasMethod(Class<?> clazz, String methodName, Class<?> ... parameters) {
        return ClassUtils.getMethod(clazz, methodName, parameters) != null;
    }

    public static Object invokeMethod(Object object, String methodName, Object ... parameters) {
        Object result;
        block6: {
            result = null;
            Class[] parameterTypes = new Class[parameters.length];
            int i = 0;
            while (i < parameters.length) {
                parameterTypes[i] = parameters[i].getClass();
                ++i;
            }
            try {
                if (ClassUtils.hasMethod(object.getClass(), methodName, parameterTypes)) {
                    Method method = ClassUtils.getMethod(object.getClass(), methodName, parameterTypes);
                    result = method.invoke(object, parameters);
                }
            }
            catch (InvocationTargetException invocationTargetException) {
                assert (false);
            }
            catch (IllegalAccessException illegalAccessException) {
                if ($assertionsDisabled) break block6;
                throw new AssertionError();
            }
        }
        return result;
    }

    private static Method getMethod(Class<?> clazz, String methodName, Class<?> ... parameters) {
        Method[] methods;
        Method soughtMethod = null;
        Method[] methodArray = methods = clazz.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?>[] params;
            Method method = methodArray[n2];
            if (method.getName().equals(methodName) && parameters.length == (params = method.getParameterTypes()).length) {
                soughtMethod = method;
                int i = 0;
                while (i < params.length) {
                    if (!ClassUtils.classEquals(parameters[i], params[i])) {
                        soughtMethod = null;
                        break;
                    }
                    ++i;
                }
                if (soughtMethod != null) break;
            }
            ++n2;
        }
        return soughtMethod;
    }
}

