/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.match.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.compare.match.api.IMatchEngine;
import org.eclipse.emf.compare.match.engine.GenericMatchEngine;
import org.eclipse.emf.compare.match.metamodel.MatchModel;
import org.eclipse.emf.compare.match.service.EngineDescriptor;
import org.eclipse.emf.compare.util.EMFCompareMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MatchService {
    private static final String ALL_EXTENSIONS = "*";
    private static final String DEFAULT_EXTENSION = "ecore";
    private static final String MATCH_ENGINES_EXTENSION_POINT = "org.eclipse.emf.compare.match.engine";
    private static final Map<String, ArrayList<EngineDescriptor>> PARSED_ENGINES = new EMFCompareMap();
    private static final String TAG_ENGINE = "matchengine";

    static {
        MatchService.parseExtensionMetadata();
    }

    private MatchService() {
    }

    public static MatchModel doContentMatch(EObject leftObject, EObject rightObject, EObject ancestor, Map<String, Object> options) throws InterruptedException {
        String extension = MatchService.getBestExtension(leftObject.eResource(), rightObject.eResource(), ancestor.eResource());
        IMatchEngine engine = MatchService.getBestMatchEngine(extension);
        return engine.contentMatch(leftObject, rightObject, ancestor, options);
    }

    public static MatchModel doContentMatch(EObject leftObject, EObject rightObject, Map<String, Object> options) throws InterruptedException {
        String extension = MatchService.getBestExtension(leftObject.eResource(), rightObject.eResource());
        IMatchEngine engine = MatchService.getBestMatchEngine(extension);
        return engine.contentMatch(leftObject, rightObject, options);
    }

    public static MatchModel doMatch(EObject leftRoot, EObject rightRoot, EObject ancestor, Map<String, Object> options) throws InterruptedException {
        String extension = MatchService.getBestExtension(leftRoot.eResource(), rightRoot.eResource(), ancestor.eResource());
        IMatchEngine engine = MatchService.getBestMatchEngine(extension);
        return engine.modelMatch(leftRoot, rightRoot, ancestor, options);
    }

    public static MatchModel doMatch(EObject leftRoot, EObject rightRoot, Map<String, Object> options) throws InterruptedException {
        String extension = MatchService.getBestExtension(leftRoot.eResource(), rightRoot.eResource());
        IMatchEngine engine = MatchService.getBestMatchEngine(extension);
        return engine.modelMatch(leftRoot, rightRoot, options);
    }

    public static MatchModel doResourceMatch(Resource leftResource, Resource rightResource, Map<String, Object> options) throws InterruptedException {
        String extension = MatchService.getBestExtension(leftResource, rightResource);
        IMatchEngine engine = MatchService.getBestMatchEngine(extension);
        return engine.resourceMatch(leftResource, rightResource, options);
    }

    public static MatchModel doResourceMatch(Resource leftResource, Resource rightResource, Resource ancestorResource, Map<String, Object> options) throws InterruptedException {
        String extension = MatchService.getBestExtension(leftResource, rightResource, ancestorResource);
        IMatchEngine engine = MatchService.getBestMatchEngine(extension);
        return engine.resourceMatch(leftResource, rightResource, ancestorResource, options);
    }

    public static IMatchEngine getBestMatchEngine(String extension) {
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            EngineDescriptor desc = MatchService.getBestDescriptor(extension);
            return desc.getEngineInstance();
        }
        return new GenericMatchEngine();
    }

    private static EngineDescriptor getBestDescriptor(String extension) {
        EngineDescriptor descriptor = null;
        if (PARSED_ENGINES.containsKey(extension)) {
            descriptor = MatchService.getHighestDescriptor((List<EngineDescriptor>)PARSED_ENGINES.get(extension));
        } else if (PARSED_ENGINES.containsKey(ALL_EXTENSIONS)) {
            descriptor = MatchService.getHighestDescriptor((List<EngineDescriptor>)PARSED_ENGINES.get(ALL_EXTENSIONS));
        }
        return descriptor;
    }

    private static String getBestExtension(Resource ... resources) {
        String extension = null;
        int i = 0;
        while (i < resources.length) {
            if (resources[i].getURI() != null) {
                if (extension == null) {
                    extension = resources[i].getURI().fileExtension();
                } else if (!extension.equals(resources[i].getURI().fileExtension())) {
                    extension = DEFAULT_EXTENSION;
                    break;
                }
            }
            ++i;
        }
        return extension;
    }

    private static EngineDescriptor getHighestDescriptor(List<EngineDescriptor> set) {
        Collections.sort(set, Collections.reverseOrder());
        if (set.size() > 0) {
            return set.get(0);
        }
        return null;
    }

    private static EngineDescriptor parseEngine(IConfigurationElement configElement) {
        if (!configElement.getName().equals(TAG_ENGINE)) {
            return null;
        }
        EngineDescriptor desc = new EngineDescriptor(configElement);
        return desc;
    }

    private static void parseExtensionMetadata() {
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            IExtension[] extensions = Platform.getExtensionRegistry().getExtensionPoint(MATCH_ENGINES_EXTENSION_POINT).getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    EngineDescriptor desc = MatchService.parseEngine(configElements[j]);
                    MatchService.storeEngineDescriptor(desc);
                    ++j;
                }
                ++i;
            }
        }
    }

    private static void storeEngineDescriptor(EngineDescriptor desc) {
        String[] extensions;
        if (desc.getFileExtension() == null) {
            return;
        }
        String[] stringArray = extensions = desc.getFileExtension().split(",");
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            String engineExtension = stringArray[n2];
            if (!PARSED_ENGINES.containsKey(engineExtension)) {
                PARSED_ENGINES.put(engineExtension, new ArrayList());
            }
            List set = PARSED_ENGINES.get(engineExtension);
            set.add(desc);
            ++n2;
        }
    }
}

