/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.protocol;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.cdo.core.CDOResSignals;
import org.eclipse.emf.cdo.core.protocol.ResourceChangeInfo;
import org.eclipse.emf.cdo.server.Mapper;
import org.eclipse.emf.cdo.server.ServerCDOResProtocol;
import org.eclipse.net4j.core.Channel;
import org.eclipse.net4j.core.impl.AbstractIndicationWithResponse;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteResourcesIndication
extends AbstractIndicationWithResponse
implements CDOResSignals {
    private boolean ok;

    public short getSignalId() {
        return 4;
    }

    public void indicate() {
        int rid;
        HashSet<Integer> rids = new HashSet<Integer>();
        while ((rid = this.receiveInt()) != -1) {
            if (this.isDebugEnabled()) {
                this.debug("Deleting rid " + rid);
            }
            rids.add(rid);
        }
        Set<Long> modifiedOIDs = this.deleteResources(rids);
        if (modifiedOIDs != null) {
            this.ok = true;
            this.transmitInvalidations(modifiedOIDs);
            this.transmitResourceChanges(rids);
            this.transmitRemovals(rids);
        } else {
            this.ok = false;
        }
    }

    public void respond() {
        if (this.isDebugEnabled()) {
            this.debug("Deleted resources: " + this.ok);
        }
        this.transmitBoolean(this.ok);
    }

    private Set<Long> deleteResources(final Set<Integer> rids) {
        try {
            ServerCDOResProtocol protocol = (ServerCDOResProtocol)this.getProtocol();
            final Mapper mapper = protocol.getMapper();
            TransactionTemplate transactionTemplate = protocol.getTransactionTemplate();
            return (Set)transactionTemplate.execute(new TransactionCallback(){

                public Object doInTransaction(TransactionStatus status) {
                    for (Integer rid : rids) {
                        mapper.deleteResource(rid);
                    }
                    return mapper.removeStaleReferences();
                }
            });
        }
        catch (TransactionException ex) {
            this.error("Error while committing transaction to database", ex);
            return null;
        }
    }

    private void transmitInvalidations(Collection<Long> changedObjectIds) {
        if (!changedObjectIds.isEmpty()) {
            Channel me = this.getChannel();
            ServerCDOResProtocol cdores = (ServerCDOResProtocol)me.getProtocol();
            cdores.fireInvalidationNotification(changedObjectIds);
        }
    }

    private void transmitRemovals(Collection<Integer> rids) {
        if (!rids.isEmpty()) {
            Channel me = this.getChannel();
            ServerCDOResProtocol cdores = (ServerCDOResProtocol)me.getProtocol();
            cdores.fireRemovalNotification(rids);
        }
    }

    private void transmitResourceChanges(Collection<Integer> rids) {
        if (!rids.isEmpty()) {
            ArrayList<ResourceChangeInfo> resourceChanges = new ArrayList<ResourceChangeInfo>();
            for (Integer rid : rids) {
                ResourceChangeInfo info = new ResourceChangeInfo(2, rid.intValue(), null);
                resourceChanges.add(info);
            }
            Channel me = this.getChannel();
            ServerCDOResProtocol cdores = (ServerCDOResProtocol)me.getProtocol();
            cdores.fireResourcesChangedNotification(resourceChanges);
        }
    }
}

