/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.sql.DataSource;
import org.eclipse.emf.cdo.core.OIDEncoder;
import org.eclipse.emf.cdo.dbgen.ColumnType;
import org.eclipse.emf.cdo.dbgen.DBGenFactory;
import org.eclipse.emf.cdo.dbgen.Database;
import org.eclipse.emf.cdo.dbgen.IndexType;
import org.eclipse.emf.cdo.dbgen.SQLDialect;
import org.eclipse.emf.cdo.dbgen.Table;
import org.eclipse.emf.cdo.dbgen.internal.DBGenActivator;
import org.eclipse.emf.cdo.server.AttributeInfo;
import org.eclipse.emf.cdo.server.ClassInfo;
import org.eclipse.emf.cdo.server.ColumnConverter;
import org.eclipse.emf.cdo.server.DatabaseInconsistencyException;
import org.eclipse.emf.cdo.server.Mapper;
import org.eclipse.emf.cdo.server.PackageInfo;
import org.eclipse.emf.cdo.server.PackageManager;
import org.eclipse.emf.cdo.server.ResourceInfo;
import org.eclipse.emf.cdo.server.ResourceManager;
import org.eclipse.emf.cdo.server.ResourceNotFoundException;
import org.eclipse.emf.cdo.server.impl.ResourceInfoImpl;
import org.eclipse.emf.cdo.server.impl.SQLConstants;
import org.eclipse.net4j.core.Channel;
import org.eclipse.net4j.spring.ValidationException;
import org.eclipse.net4j.spring.impl.ServiceImpl;
import org.eclipse.net4j.util.ImplementationError;
import org.eclipse.net4j.util.StringHelper;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowCallbackHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapperImpl
extends ServiceImpl
implements Mapper,
SQLConstants {
    protected static final int OBJECT_NOT_FOUND_IN_DB = 0;
    protected static final long OBJECT_NOT_REFERENCED_IN_DB = 0L;
    protected ColumnConverter columnConverter;
    protected PackageManager packageManager;
    protected ResourceManager resourceManager;
    protected DataSource dataSource;
    protected JdbcTemplate jdbcTemplate;
    protected String sqlDialectName;
    protected OIDEncoder oidEncoder;
    private int nextPid;
    private int nextRID;
    private int nextCID;
    private transient SQLDialect cachedSqlDialect;

    @Override
    public PackageManager getPackageManager() {
        return this.packageManager;
    }

    public void setPackageManager(PackageManager packageManager) {
        this.doSet("packageManager", packageManager);
    }

    @Override
    public ColumnConverter getColumnConverter() {
        return this.columnConverter;
    }

    public void setColumnConverter(ColumnConverter columnConverter) {
        this.doSet("columnConverter", columnConverter);
    }

    @Override
    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public void setResourceManager(ResourceManager resourceManager) {
        this.doSet("resourceManager", resourceManager);
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.doSet("dataSource", dataSource);
    }

    public SQLDialect getSqlDialect() {
        if (this.cachedSqlDialect == null) {
            this.cachedSqlDialect = DBGenActivator.INSTANCE.createDialect(this.sqlDialectName);
        }
        return this.cachedSqlDialect;
    }

    public String getSqlDialectName() {
        return this.sqlDialectName;
    }

    public void setSqlDialectName(String sqlDialectName) {
        this.doSet("sqlDialectName", sqlDialectName);
    }

    @Override
    public OIDEncoder getOidEncoder() {
        return this.oidEncoder;
    }

    public void setOidEncoder(OIDEncoder oidEncoder) {
        this.doSet("oidEncoder", oidEncoder);
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.doSet("jdbcTemplate", jdbcTemplate);
    }

    @Override
    public int getNextPid() {
        return this.nextPid++;
    }

    @Override
    public int getNextCID() {
        return this.nextCID++;
    }

    @Override
    public int getNextRID() {
        return this.nextRID++;
    }

    @Override
    public long getNextOID(int rid) {
        ResourceInfo resourceInfo = this.resourceManager.getResourceInfo(rid, (Mapper)this);
        if (resourceInfo == null) {
            throw new ResourceNotFoundException("Unknown RID: " + rid);
        }
        long nextOIDFragment = resourceInfo.getNextOIDFragment();
        return this.oidEncoder.getOID(rid, nextOIDFragment);
    }

    protected void validate() throws ValidationException {
        super.validate();
        this.assertNotNull("columnConverter");
        this.assertNotNull("packageManager");
        this.assertNotNull("resourceManager");
        this.assertNotNull("dataSource");
        this.assertNotNull("oidEncoder");
        this.assertNotNull("jdbcTemplate");
        this.initTables();
        this.initPackages();
        this.nextPid = this.selectMaxPid() + 1;
        this.nextCID = this.selectMaxCID() + 1;
        this.nextRID = this.selectMaxRID() + 1;
    }

    protected void deactivate() throws Exception {
        this.columnConverter = null;
        this.dataSource = null;
        this.jdbcTemplate = null;
        this.oidEncoder = null;
        this.packageManager = null;
        this.resourceManager = null;
        this.sqlDialectName = null;
        this.cachedSqlDialect = null;
        super.deactivate();
    }

    protected void initTables() {
        Database database = DBGenFactory.eINSTANCE.createDatabase();
        Table packageTable = database.addTable("CDO_PACKAGE");
        packageTable.addColumn("PID", ColumnType.INTEGER_LITERAL, "NOT NULL");
        packageTable.addColumn("NAME", ColumnType.VARCHAR_LITERAL, 255, "NOT NULL");
        packageTable.addSimpleIndex("PID", IndexType.PRIMARY_LITERAL);
        packageTable.addSimpleIndex("NAME", IndexType.UNIQUE_LITERAL);
        Table classTable = database.addTable("CDO_CLASS");
        classTable.addColumn("CID", ColumnType.INTEGER_LITERAL, "NOT NULL");
        classTable.addColumn("NAME", ColumnType.VARCHAR_LITERAL, 255, "NOT NULL");
        classTable.addColumn("PARENTNAME", ColumnType.VARCHAR_LITERAL, 255);
        classTable.addColumn("TABLENAME", ColumnType.VARCHAR_LITERAL, 127, "NOT NULL");
        classTable.addColumn("PID", ColumnType.INTEGER_LITERAL, "NOT NULL");
        classTable.addSimpleIndex("CID", IndexType.PRIMARY_LITERAL);
        classTable.addSimpleIndex("NAME", IndexType.UNIQUE_LITERAL);
        classTable.addSimpleIndex("PID", IndexType.NON_UNIQUE_LITERAL);
        Table columnTable = database.addTable("CDO_ATTRIBUTE");
        columnTable.addColumn("NAME", ColumnType.VARCHAR_LITERAL, 127, "NOT NULL");
        columnTable.addColumn("FEATUREID", ColumnType.INTEGER_LITERAL, "NOT NULL");
        columnTable.addColumn("DATATYPE", ColumnType.INTEGER_LITERAL, "NOT NULL");
        columnTable.addColumn("COLUMNNAME", ColumnType.VARCHAR_LITERAL, 127, "NOT NULL");
        columnTable.addColumn("COLUMNTYPE", ColumnType.INTEGER_LITERAL, "NOT NULL");
        columnTable.addColumn("CID", ColumnType.INTEGER_LITERAL, "NOT NULL");
        columnTable.addSimpleIndex("CID", IndexType.NON_UNIQUE_LITERAL);
        Table objectTable = database.addTable("CDO_OBJECT");
        objectTable.addColumn("OID", ColumnType.BIGINT_LITERAL, "NOT NULL");
        objectTable.addColumn("OCA", ColumnType.INTEGER_LITERAL, "NOT NULL");
        objectTable.addColumn("CID", ColumnType.INTEGER_LITERAL, "NOT NULL");
        objectTable.addSimpleIndex("OID", IndexType.PRIMARY_LITERAL);
        objectTable.addSimpleIndex("CID", IndexType.NON_UNIQUE_LITERAL);
        Table resourceTable = database.addTable("CDO_RESOURCE");
        resourceTable.addColumn("RID", ColumnType.INTEGER_LITERAL, "NOT NULL");
        resourceTable.addColumn("PATH", ColumnType.VARCHAR_LITERAL, 255, "NOT NULL");
        resourceTable.addSimpleIndex("RID", IndexType.PRIMARY_LITERAL);
        resourceTable.addSimpleIndex("PATH", IndexType.UNIQUE_LITERAL);
        Table contentTable = database.addTable("CDO_CONTENT");
        contentTable.addColumn("OID", ColumnType.BIGINT_LITERAL, "NOT NULL");
        contentTable.addSimpleIndex("OID", IndexType.PRIMARY_LITERAL);
        Table referenceTable = database.addTable("CDO_REFERENCE");
        referenceTable.addColumn("SOURCEOID", ColumnType.BIGINT_LITERAL);
        referenceTable.addColumn("FEATUREID", ColumnType.INTEGER_LITERAL);
        referenceTable.addColumn("ORDINAL", ColumnType.BIGINT_LITERAL);
        referenceTable.addColumn("TARGETOID", ColumnType.BIGINT_LITERAL, 0, "NOT NULL");
        referenceTable.addColumn("CONTENT", ColumnType.BOOLEAN_LITERAL);
        referenceTable.addSimpleIndex("TARGETOID", IndexType.NON_UNIQUE_LITERAL);
        referenceTable.addCompoundIndex(new String[]{"TARGETOID", "CONTENT"}, IndexType.NON_UNIQUE_LITERAL);
        referenceTable.addCompoundIndex(new String[]{"SOURCEOID", "FEATUREID", "ORDINAL"}, IndexType.NON_UNIQUE_LITERAL);
        this.getSqlDialect().save(this.dataSource, database, false);
    }

    protected void initPackages() {
        if (this.isDebugEnabled()) {
            this.debug("SELECT PID, NAME FROM CDO_PACKAGE");
        }
        this.jdbcTemplate.query("SELECT PID, NAME FROM CDO_PACKAGE", new RowCallbackHandler(){

            public void processRow(ResultSet resultSet) throws SQLException {
                int pid = resultSet.getInt(1);
                String name = resultSet.getString(2);
                if (MapperImpl.this.isDebugEnabled()) {
                    MapperImpl.this.debug("Initializing package: pid=" + pid + ", name=" + name);
                }
                PackageInfo packageInfo = MapperImpl.this.packageManager.addPackage(pid, name);
                MapperImpl.this.initClasses(packageInfo);
            }
        });
    }

    protected void initClasses(final PackageInfo packageInfo) {
        JdbcTemplate nestedTemplate = new JdbcTemplate(this.dataSource);
        Object[] args = new Object[]{new Integer(packageInfo.getPid())};
        if (this.isDebugEnabled()) {
            this.debug(StringHelper.replaceWildcards((String)"SELECT CID, NAME, PARENTNAME, TABLENAME FROM CDO_CLASS WHERE PID=?", (String)"?", (Object[])args));
        }
        nestedTemplate.query("SELECT CID, NAME, PARENTNAME, TABLENAME FROM CDO_CLASS WHERE PID=?", args, new RowCallbackHandler(){

            public void processRow(ResultSet resultSet) throws SQLException {
                int cid = resultSet.getInt(1);
                String name = resultSet.getString(2);
                String parentName = resultSet.getString(3);
                String tableName = resultSet.getString(4);
                if (parentName != null && parentName.length() == 0) {
                    parentName = null;
                }
                if (MapperImpl.this.isDebugEnabled()) {
                    MapperImpl.this.debug("Initializing class: cid=" + cid + ", name=" + name + ", parentName=" + parentName + ", tableName=" + tableName);
                }
                ClassInfo classInfo = packageInfo.addClass(cid, name, parentName, tableName);
                MapperImpl.this.initAttributes(classInfo);
                if (cid > MapperImpl.this.nextCID) {
                    MapperImpl.this.nextCID = cid;
                }
            }
        });
        ++this.nextCID;
    }

    protected void initAttributes(final ClassInfo classInfo) {
        JdbcTemplate nestedTemplate = new JdbcTemplate(this.dataSource);
        Object[] args = new Object[]{new Integer(classInfo.getCID())};
        if (this.isDebugEnabled()) {
            this.debug(StringHelper.replaceWildcards((String)"SELECT NAME, FEATUREID, DATATYPE, COLUMNNAME, COLUMNTYPE FROM CDO_ATTRIBUTE WHERE CID=?", (String)"?", (Object[])args));
        }
        nestedTemplate.query("SELECT NAME, FEATUREID, DATATYPE, COLUMNNAME, COLUMNTYPE FROM CDO_ATTRIBUTE WHERE CID=?", args, new RowCallbackHandler(){

            public void processRow(ResultSet resultSet) throws SQLException {
                String name = resultSet.getString(1);
                int featureId = resultSet.getInt(2);
                int dataType = resultSet.getInt(3);
                String columnName = resultSet.getString(4);
                int columnType = resultSet.getInt(5);
                if (MapperImpl.this.isDebugEnabled()) {
                    MapperImpl.this.debug("Initializing attribute: name=" + name + ", featureId=" + featureId + ", dataType=" + dataType + ", columnName=" + columnName + ", columnType=" + columnType);
                }
                classInfo.addAttribute(name, featureId, dataType, columnName, columnType);
            }
        });
    }

    @Override
    public void insertPackage(PackageInfo packageInfo) {
        this.sql("INSERT INTO CDO_PACKAGE VALUES (?, ?)", new Object[]{packageInfo.getPid(), packageInfo.getName()});
    }

    @Override
    public void insertClass(ClassInfo classInfo) {
        String parentName = classInfo.getParentName() == null ? "" : classInfo.getParentName();
        this.sql("INSERT INTO CDO_CLASS VALUES (?, ?, ?, ?, ?)", new Object[]{classInfo.getCID(), classInfo.getName(), parentName, classInfo.getTableName(), classInfo.getPackageInfo().getPid()});
    }

    @Override
    public void insertAttribute(AttributeInfo attributeInfo, int cid) {
        this.sql("INSERT INTO CDO_ATTRIBUTE VALUES (?, ?, ?, ?, ?, ?)", new Object[]{attributeInfo.getName(), attributeInfo.getFeatureID(), attributeInfo.getDataType(), attributeInfo.getColumnName(), attributeInfo.getColumnType(), cid});
    }

    @Override
    public ResourceInfo selectResourceInfo(String path) {
        Object[] args = new Object[]{path};
        if (this.isDebugEnabled()) {
            this.debug(StringHelper.replaceWildcards((String)"SELECT RID FROM CDO_RESOURCE WHERE PATH=?", (String)"?", (Object[])args));
        }
        final int[] rows = new int[1];
        final ResourceInfoImpl result = new ResourceInfoImpl();
        result.setPath(path);
        this.jdbcTemplate.query("SELECT RID FROM CDO_RESOURCE WHERE PATH=?", args, new RowCallbackHandler(){

            public void processRow(ResultSet resultSet) throws SQLException {
                result.setRID(resultSet.getInt(1));
                rows[0] = rows[0] + 1;
            }
        });
        if (rows[0] != 1) {
            return null;
        }
        long nextOIDFragment = this.selectMaxOIDFragment(result.getRID()) + 1L;
        result.setNextOIDFragment(nextOIDFragment);
        if (this.isDebugEnabled()) {
            this.debug("Selected " + result);
        }
        return result;
    }

    @Override
    public ResourceInfo selectResourceInfo(int rid) {
        Object[] args = new Object[]{new Integer(rid)};
        if (this.isDebugEnabled()) {
            this.debug(StringHelper.replaceWildcards((String)"SELECT PATH FROM CDO_RESOURCE WHERE RID=?", (String)"?", (Object[])args));
        }
        final int[] rows = new int[1];
        final ResourceInfoImpl result = new ResourceInfoImpl();
        result.setRID(rid);
        this.jdbcTemplate.query("SELECT PATH FROM CDO_RESOURCE WHERE RID=?", args, new RowCallbackHandler(){

            public void processRow(ResultSet resultSet) throws SQLException {
                result.setPath(resultSet.getString(1));
                rows[0] = rows[0] + 1;
            }
        });
        if (rows[0] != 1) {
            return null;
        }
        long nextOIDFragment = this.selectMaxOIDFragment(result.getRID()) + 1L;
        result.setNextOIDFragment(nextOIDFragment);
        if (this.isDebugEnabled()) {
            this.debug("Selected " + result);
        }
        return result;
    }

    protected long selectMaxOIDFragment(int rid) {
        Object[] args = this.ridBounds(rid);
        if (this.isDebugEnabled()) {
            this.debug(StringHelper.replaceWildcards((String)"SELECT MAX(OID) FROM CDO_OBJECT WHERE OID BETWEEN ? AND ?", (String)"?", (Object[])args));
        }
        long oid = this.jdbcTemplate.queryForLong("SELECT MAX(OID) FROM CDO_OBJECT WHERE OID BETWEEN ? AND ?", args);
        return this.oidEncoder.getOIDFragment(oid);
    }

    private Object[] ridBounds(int rid) {
        long lowerBound = this.oidEncoder.getOID(rid, 1L);
        long upperBound = this.oidEncoder.getOID(rid + 1, 1L) - 1L;
        return new Object[]{new Long(lowerBound), new Long(upperBound)};
    }

    private int selectMaxPid() {
        if (this.isDebugEnabled()) {
            this.debug("SELECT MAX(PID) FROM CDO_PACKAGE");
        }
        return this.jdbcTemplate.queryForInt("SELECT MAX(PID) FROM CDO_PACKAGE");
    }

    private int selectMaxCID() {
        if (this.isDebugEnabled()) {
            this.debug("SELECT MAX(CID) FROM CDO_CLASS");
        }
        return this.jdbcTemplate.queryForInt("SELECT MAX(CID) FROM CDO_CLASS");
    }

    private int selectMaxRID() {
        if (this.isDebugEnabled()) {
            this.debug("SELECT MAX(RID) FROM CDO_RESOURCE");
        }
        return this.jdbcTemplate.queryForInt("SELECT MAX(RID) FROM CDO_RESOURCE");
    }

    @Override
    public ResourceInfo createResource(String resourcePath) {
        int rid = this.getNextRID();
        this.sql("INSERT INTO CDO_RESOURCE VALUES (?, ?)", new Object[]{rid, resourcePath});
        return this.resourceManager.registerResourceInfo(resourcePath, rid, 1L);
    }

    @Override
    public int getCollectionCount(long oid, int feature) {
        Object[] args = new Object[]{new Long(oid), new Integer(feature)};
        if (this.isDebugEnabled()) {
            this.debug(StringHelper.replaceWildcards((String)"SELECT COUNT(SOURCEOID) FROM CDO_REFERENCE WHERE SOURCEOID=? AND FEATUREID=?", (String)"?", (Object[])args));
        }
        return this.jdbcTemplate.queryForInt("SELECT COUNT(SOURCEOID) FROM CDO_REFERENCE WHERE SOURCEOID=? AND FEATUREID=?", args);
    }

    @Override
    public boolean lock(long oid, int oca) {
        int changed;
        Object[] args = new Object[]{new Long(oid), new Integer(oca)};
        if (this.isDebugEnabled()) {
            this.debug(StringHelper.replaceWildcards((String)"UPDATE CDO_OBJECT SET OCA=OCA+1 WHERE OID=? AND OCA=?", (String)"?", (Object[])args));
        }
        return (changed = this.jdbcTemplate.update("UPDATE CDO_OBJECT SET OCA=OCA+1 WHERE OID=? AND OCA=?", args)) == 1;
    }

    @Override
    public void insertResource(int rid, String path) {
        this.sql("INSERT INTO CDO_RESOURCE VALUES (?, ?)", new Object[]{rid, path});
    }

    @Override
    public void insertReference(long oid, int feature, int ordinal, long target, boolean containment) {
        this.sql("INSERT INTO CDO_REFERENCE VALUES (?, ?, ?, ?, ?)", new Object[]{oid, feature, ordinal, target, containment});
    }

    @Override
    public void removeReference(long oid, int feature, int ordinal) {
        this.sql("DELETE FROM CDO_REFERENCE WHERE SOURCEOID=? AND FEATUREID=? AND ORDINAL=?", new Object[]{oid, feature, ordinal});
    }

    @Override
    public void moveReferenceAbsolute(long oid, int feature, int toIndex, int fromIndex) {
        this.sql("UPDATE CDO_REFERENCE SET ORDINAL=? WHERE SOURCEOID=? AND FEATUREID=? AND ORDINAL=?", new Object[]{toIndex, oid, feature, fromIndex});
    }

    @Override
    public void moveReferencesRelative(long oid, int feature, int startIndex, int endIndex, int offset) {
        Object[] args = new Object[]{new Integer(offset), new Long(oid), new Integer(feature), new Integer(startIndex), new Integer(endIndex)};
        if (this.isDebugEnabled()) {
            this.debug(StringHelper.replaceWildcards((String)"UPDATE CDO_REFERENCE SET ORDINAL=ORDINAL+? WHERE SOURCEOID=? AND FEATUREID=? AND ORDINAL BETWEEN ? AND ?", (String)"?", (Object[])args));
        }
        this.jdbcTemplate.update("UPDATE CDO_REFERENCE SET ORDINAL=ORDINAL+? WHERE SOURCEOID=? AND FEATUREID=? AND ORDINAL BETWEEN ? AND ?", args);
    }

    @Override
    public void insertObject(long oid, int cid) {
        this.sql("INSERT INTO CDO_OBJECT VALUES (?, 1, ?)", new Object[]{new Long(oid), new Integer(cid)});
    }

    protected void removeReferences(long oid) {
        Object[] args = new Object[]{oid};
        if (this.isDebugEnabled()) {
            this.debug(StringHelper.replaceWildcards((String)"DELETE FROM CDO_REFERENCE WHERE SOURCEOID=?", (String)"?", (Object[])args));
        }
        this.jdbcTemplate.update("DELETE FROM CDO_REFERENCE WHERE SOURCEOID=?", args);
    }

    public void removeObject(long oid, int cid) {
        ClassInfo classInfo = this.packageManager.getClassInfo(cid);
        while (classInfo != null) {
            this.removeUserSegment(oid, classInfo.getTableName());
            classInfo = classInfo.getParent();
        }
        this.removeSegment(oid);
        this.removeReferences(oid);
    }

    @Override
    public void removeObject(long oid) {
        int cid = this.selectCIDOfObject(oid);
        this.removeObject(oid, cid);
    }

    protected int selectCIDOfObject(long oid) {
        Object[] args = new Object[]{new Long(oid)};
        if (this.isDebugEnabled()) {
            this.debug(StringHelper.replaceWildcards((String)"SELECT CID FROM CDO_OBJECT WHERE OID=?", (String)"?", (Object[])args));
        }
        try {
            return this.jdbcTemplate.queryForInt("SELECT CID FROM CDO_OBJECT WHERE OID=?", args);
        }
        catch (IncorrectResultSizeDataAccessException incorrectResultSizeDataAccessException) {
            return 0;
        }
    }

    protected void removeSegment(long oid) {
        StringBuffer query = new StringBuffer("DELETE FROM ");
        query.append("CDO_OBJECT");
        query.append(" WHERE ");
        query.append("OID");
        query.append("=");
        query.append(oid);
        this.sql(query.toString());
    }

    protected void removeUserSegment(long oid, String tableName) {
        StringBuffer query = new StringBuffer("DELETE FROM ");
        query.append(tableName);
        query.append(" WHERE ");
        query.append("CDO_OID");
        query.append("=");
        query.append(oid);
        this.sql(query.toString());
    }

    @Override
    public void insertContent(long oid) {
        this.sql("INSERT INTO CDO_CONTENT VALUES (?)", new Object[]{oid});
    }

    @Override
    public void removeContent(long oid) {
        this.sql("DELETE FROM CDO_CONTENT WHERE OID=?", new Object[]{oid});
    }

    @Override
    public void sql(String sql) {
        int rows;
        if (this.isDebugEnabled()) {
            this.debug(sql);
        }
        if ((rows = this.jdbcTemplate.update(sql)) != 1) {
            throw new DatabaseInconsistencyException(sql);
        }
    }

    @Override
    public void sql(String sql, Object[] args) {
        int rows;
        if (this.isDebugEnabled()) {
            this.debug(StringHelper.replaceWildcards((String)sql, (String)"?", (Object[])args));
        }
        if ((rows = this.jdbcTemplate.update(sql, args)) != 1) {
            throw new DatabaseInconsistencyException(sql);
        }
    }

    @Override
    public void sql(String sql, Object[] args, int[] types) {
        int rows;
        if (this.isDebugEnabled()) {
            this.debug(StringHelper.replaceWildcards((String)sql, (String)"?", (Object[])args));
        }
        if ((rows = this.jdbcTemplate.update(sql, args, types)) != 1) {
            throw new DatabaseInconsistencyException(sql);
        }
    }

    @Override
    public void transmitContent(final Channel channel, ResourceInfo resourceInfo) {
        if (resourceInfo != null) {
            Object[] args = this.ridBounds(resourceInfo.getRID());
            if (this.isDebugEnabled()) {
                this.debug(StringHelper.replaceWildcards((String)"SELECT CDO_OBJECT.OID, CDO_OBJECT.OCA, CDO_OBJECT.CID FROM CDO_CONTENT, CDO_OBJECT WHERE CDO_OBJECT.OID=CDO_CONTENT.OID AND CDO_OBJECT.OID BETWEEN ? AND ?", (String)"?", (Object[])args));
            }
            this.jdbcTemplate.query("SELECT CDO_OBJECT.OID, CDO_OBJECT.OCA, CDO_OBJECT.CID FROM CDO_CONTENT, CDO_OBJECT WHERE CDO_OBJECT.OID=CDO_CONTENT.OID AND CDO_OBJECT.OID BETWEEN ? AND ?", args, new RowCallbackHandler(){

                public void processRow(ResultSet resultSet) throws SQLException {
                    long oid = resultSet.getLong(1);
                    int oca = resultSet.getInt(2);
                    int cid = resultSet.getInt(3);
                    if (MapperImpl.this.isDebugEnabled()) {
                        MapperImpl.this.debug("Object: oid=" + MapperImpl.this.oidEncoder.toString(oid) + ", oca=" + oca + ", cid=" + cid);
                    }
                    channel.transmitLong(oid);
                    channel.transmitInt(oca);
                    channel.transmitInt(cid);
                    ClassInfo classInfo = MapperImpl.this.packageManager.getClassInfo(cid);
                    if (classInfo == null) {
                        throw new ImplementationError("Unknown cid " + cid);
                    }
                    MapperImpl.this.transmitAttributes(channel, oid, classInfo);
                    MapperImpl.this.transmitReferences(channel, oid);
                }
            });
        }
        channel.transmitLong(0L);
    }

    @Override
    public void transmitObject(final Channel channel, final long oid) {
        Object[] args = new Object[]{new Long(oid)};
        if (this.isDebugEnabled()) {
            this.debug(StringHelper.replaceWildcards((String)"SELECT OCA, CID FROM CDO_OBJECT WHERE OID=?", (String)"?", (Object[])args));
        }
        this.jdbcTemplate.query("SELECT OCA, CID FROM CDO_OBJECT WHERE OID=?", args, new RowCallbackHandler(){

            public void processRow(ResultSet resultSet) throws SQLException {
                int oca = resultSet.getInt(1);
                int cid = resultSet.getInt(2);
                if (MapperImpl.this.isDebugEnabled()) {
                    MapperImpl.this.debug("Object: oid=" + MapperImpl.this.oidEncoder.toString(oid) + ", oca=" + oca + ", cid=" + cid);
                }
                channel.transmitLong(oid);
                channel.transmitInt(oca);
                channel.transmitInt(cid);
                ClassInfo classInfo = MapperImpl.this.packageManager.getClassInfo(cid);
                if (classInfo == null) {
                    throw new ImplementationError("Unknown cid " + cid);
                }
                MapperImpl.this.transmitContainers(channel, oid);
                MapperImpl.this.transmitAttributes(channel, oid, classInfo);
                MapperImpl.this.transmitReferences(channel, oid);
            }
        });
        channel.transmitLong(0L);
    }

    public void transmitContainers(Channel channel, long oid) {
        final LinkedList containers = new LinkedList();
        final long[] child = new long[]{oid};
        while (child[0] != 0L) {
            Object[] args = new Object[]{new Long(child[0]), Boolean.TRUE};
            if (this.isDebugEnabled()) {
                this.debug(StringHelper.replaceWildcards((String)"SELECT CDO_REFERENCE.SOURCEOID, CDO_OBJECT.CID FROM CDO_REFERENCE, CDO_OBJECT WHERE CDO_REFERENCE.TARGETOID=? AND CDO_REFERENCE.CONTENT=? AND CDO_REFERENCE.SOURCEOID=CDO_OBJECT.OID", (String)"?", (Object[])args));
            }
            child[0] = 0L;
            this.jdbcTemplate.query("SELECT CDO_REFERENCE.SOURCEOID, CDO_OBJECT.CID FROM CDO_REFERENCE, CDO_OBJECT WHERE CDO_REFERENCE.TARGETOID=? AND CDO_REFERENCE.CONTENT=? AND CDO_REFERENCE.SOURCEOID=CDO_OBJECT.OID", args, new RowCallbackHandler(){

                public void processRow(ResultSet resultSet) throws SQLException {
                    long oid = resultSet.getLong(1);
                    int cid = resultSet.getInt(2);
                    private class Container {
                        public long oid;
                        public int cid;

                        public Container(long oid, int cid) {
                            this.oid = oid;
                            this.cid = cid;
                        }
                    }
                    containers.add(0, new Container(oid, cid));
                    child[0] = oid;
                }
            });
        }
        channel.transmitInt(containers.size());
        for (Container container : containers) {
            if (this.isDebugEnabled()) {
                this.debug("Container: oid=" + this.oidEncoder.toString(container.oid) + ", cid=" + container.cid);
            }
            channel.transmitLong(container.oid);
            channel.transmitInt(container.cid);
        }
    }

    @Override
    public void transmitReferences(final Channel channel, long oid) {
        Object[] args = new Object[]{new Long(oid)};
        if (this.isDebugEnabled()) {
            this.debug(StringHelper.replaceWildcards((String)"SELECT CDO_REFERENCE.FEATUREID, CDO_REFERENCE.TARGETOID, CDO_OBJECT.CID FROM CDO_REFERENCE, CDO_OBJECT WHERE CDO_REFERENCE.SOURCEOID=? AND CDO_REFERENCE.TARGETOID=CDO_OBJECT.OID ORDER BY CDO_REFERENCE.FEATUREID, CDO_REFERENCE.ORDINAL", (String)"?", (Object[])args));
        }
        this.jdbcTemplate.query("SELECT CDO_REFERENCE.FEATUREID, CDO_REFERENCE.TARGETOID, CDO_OBJECT.CID FROM CDO_REFERENCE, CDO_OBJECT WHERE CDO_REFERENCE.SOURCEOID=? AND CDO_REFERENCE.TARGETOID=CDO_OBJECT.OID ORDER BY CDO_REFERENCE.FEATUREID, CDO_REFERENCE.ORDINAL", args, new RowCallbackHandler(){

            public void processRow(ResultSet resultSet) throws SQLException {
                int feature = resultSet.getInt(1);
                long target = resultSet.getLong(2);
                int cid = resultSet.getInt(3);
                if (MapperImpl.this.isDebugEnabled()) {
                    MapperImpl.this.debug("Reference: feature=" + feature + ", target=" + MapperImpl.this.oidEncoder.toString(target) + ", cid=" + cid);
                }
                channel.transmitInt(feature);
                channel.transmitLong(target);
                channel.transmitInt(cid);
            }
        });
        channel.transmitInt(-1);
    }

    @Override
    public void transmitAttributes(final Channel channel, long oid, ClassInfo classInfo) {
        while (classInfo != null) {
            String columnNames = classInfo.getColumnNames();
            if (columnNames != null && columnNames.length() > 0) {
                final ClassInfo finalClassInfo = classInfo;
                String sql = "SELECT " + columnNames + " FROM " + classInfo.getTableName() + " WHERE " + "CDO_OID" + "=?";
                Object[] args = new Object[]{new Long(oid)};
                if (this.isDebugEnabled()) {
                    this.debug(StringHelper.replaceWildcards((String)sql, (String)"?", (Object[])args));
                }
                this.jdbcTemplate.query(sql, args, new RowCallbackHandler(){

                    public void processRow(ResultSet resultSet) throws SQLException {
                        AttributeInfo[] attributeInfos = finalClassInfo.getAttributeInfos();
                        int i = 0;
                        while (i < attributeInfos.length) {
                            AttributeInfo attributeInfo = attributeInfos[i];
                            Object value = resultSet.getObject(i + 1);
                            MapperImpl.this.columnConverter.toChannel(channel, attributeInfo.getDataType(), value);
                            ++i;
                        }
                    }
                });
            }
            classInfo = classInfo.getParent();
        }
    }

    @Override
    public void transmitAllResources(final Channel channel) {
        if (this.isDebugEnabled()) {
            this.debug("Querying all resources");
            this.debug("SELECT RID, PATH FROM CDO_RESOURCE");
        }
        this.jdbcTemplate.query("SELECT RID, PATH FROM CDO_RESOURCE", new RowCallbackHandler(){

            public void processRow(ResultSet resultSet) throws SQLException {
                int rid = resultSet.getInt(1);
                String path = resultSet.getString(2);
                channel.transmitInt(rid);
                channel.transmitString(path);
            }
        });
        channel.transmitInt(-1);
    }

    @Override
    public void deleteResource(int rid) {
        if (this.isDebugEnabled()) {
            this.debug("Deleting resource: rid=" + rid);
        }
        this.sql("DELETE FROM CDO_RESOURCE WHERE RID=?", new Object[]{rid});
        Object[] args = this.ridBounds(rid);
        if (this.isDebugEnabled()) {
            this.debug(StringHelper.replaceWildcards((String)"SELECT OID, CID FROM CDO_OBJECT WHERE OID BETWEEN ? AND ?", (String)"?", (Object[])args));
        }
        this.jdbcTemplate.query("SELECT OID, CID FROM CDO_OBJECT WHERE OID BETWEEN ? AND ?", args, new RowCallbackHandler(){

            public void processRow(ResultSet resultSet) throws SQLException {
                long oid = resultSet.getLong(1);
                int cid = resultSet.getInt(2);
                if (MapperImpl.this.isDebugEnabled()) {
                    MapperImpl.this.debug("Deleting object: oid=" + MapperImpl.this.oidEncoder.toString(oid) + ", cid=" + cid);
                }
                MapperImpl.this.removeObject(oid, cid);
            }
        });
    }

    @Override
    public Set<Long> removeStaleReferences() {
        if (this.isDebugEnabled()) {
            this.debug("Removing stale references");
        }
        final HashSet<Long> modifiedOIDs = new HashSet<Long>();
        this.jdbcTemplate.query("SELECT CDO_REFERENCE.SOURCEOID, CDO_REFERENCE.FEATUREID, CDO_REFERENCE.ORDINAL FROM CDO_REFERENCE LEFT JOIN CDO_OBJECT ON CDO_REFERENCE.TARGETOID=CDO_OBJECT.OID WHERE CDO_OBJECT.OID IS NULL", new RowCallbackHandler(){

            public void processRow(ResultSet resultSet) throws SQLException {
                long oid = resultSet.getLong(1);
                int feature = resultSet.getInt(2);
                int ordinal = resultSet.getInt(3);
                if (MapperImpl.this.isDebugEnabled()) {
                    MapperImpl.this.debug("Reference: oid=" + MapperImpl.this.oidEncoder.toString(oid) + ", feature=" + feature + ", ordinal=" + ordinal);
                }
                MapperImpl.this.removeReference(oid, feature, ordinal);
                modifiedOIDs.add(oid);
            }
        });
        return modifiedOIDs;
    }

    @Override
    public void transmitExtent(final Channel channel, final int context, final boolean exactMatch, int rid) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT ");
        buffer.append("OID");
        buffer.append(exactMatch ? "" : ", CID");
        buffer.append(" FROM ");
        buffer.append("CDO_OBJECT");
        buffer.append(" WHERE ");
        buffer.append("CID");
        buffer.append(" IN (");
        buffer.append(context);
        if (!exactMatch) {
            ClassInfo classInfo = this.packageManager.getClassInfo(context);
            List<ClassInfo> subClasses = classInfo.getSubClasses();
            for (ClassInfo info : subClasses) {
                buffer.append(", ");
                buffer.append(info.getCID());
            }
        }
        buffer.append(")");
        if (rid != 0) {
            Object[] bounds = this.ridBounds(rid);
            buffer.append(" AND ");
            buffer.append("OID");
            buffer.append(" BETWEEN ");
            buffer.append(bounds[0]);
            buffer.append(" AND ");
            buffer.append(bounds[1]);
        }
        buffer.append(" ORDER BY ");
        buffer.append("OID");
        String sql = buffer.toString();
        if (this.isDebugEnabled()) {
            this.debug(sql);
        }
        this.jdbcTemplate.query(sql, new RowCallbackHandler(){

            public void processRow(ResultSet resultSet) throws SQLException {
                int cid;
                long oid = resultSet.getLong(1);
                int n = cid = exactMatch ? context : resultSet.getInt(2);
                if (MapperImpl.this.isDebugEnabled()) {
                    MapperImpl.this.debug("Extent: oid=" + MapperImpl.this.oidEncoder.toString(oid) + (exactMatch ? "" : ", cid=" + cid));
                }
                channel.transmitLong(oid);
                if (!exactMatch) {
                    channel.transmitInt(cid);
                }
            }
        });
        channel.transmitLong(0L);
    }

    @Override
    public void transmitXRefs(final Channel channel, long oid, int rid) {
        Object[] args = new Object[]{new Long(oid)};
        if (this.isDebugEnabled()) {
            this.debug(StringHelper.replaceWildcards((String)"SELECT CDO_REFERENCE.SOURCEOID, CDO_REFERENCE.FEATUREID, CDO_OBJECT.CID FROM CDO_REFERENCE, CDO_OBJECT WHERE CDO_REFERENCE.TARGETOID=? AND CDO_REFERENCE.CONTENT=FALSE AND CDO_REFERENCE.SOURCEOID=CDO_OBJECT.OID", (String)"?", (Object[])args));
        }
        this.jdbcTemplate.query("SELECT CDO_REFERENCE.SOURCEOID, CDO_REFERENCE.FEATUREID, CDO_OBJECT.CID FROM CDO_REFERENCE, CDO_OBJECT WHERE CDO_REFERENCE.TARGETOID=? AND CDO_REFERENCE.CONTENT=FALSE AND CDO_REFERENCE.SOURCEOID=CDO_OBJECT.OID", args, new RowCallbackHandler(){

            public void processRow(ResultSet resultSet) throws SQLException {
                long referer = resultSet.getLong(1);
                int feature = resultSet.getInt(2);
                int cid = resultSet.getInt(3);
                if (MapperImpl.this.isDebugEnabled()) {
                    MapperImpl.this.debug("XRef: referer=" + MapperImpl.this.oidEncoder.toString(referer) + ", feature=" + feature + ", cid=" + cid);
                }
                channel.transmitLong(referer);
                channel.transmitInt(feature);
                channel.transmitInt(cid);
            }
        });
        channel.transmitLong(0L);
    }

    @Override
    public void createAttributeTables(PackageInfo packageInfo) {
        if (this.isDebugEnabled()) {
            this.debug("Creating attribute tables");
        }
        Database database = DBGenFactory.eINSTANCE.createDatabase();
        ClassInfo[] classes = packageInfo.getClasses();
        int i = 0;
        while (i < classes.length) {
            ClassInfo classInfo = classes[i];
            this.createAttributeTable(classInfo, database);
            ++i;
        }
        this.getSqlDialect().save(this.dataSource, database, false);
    }

    private void createAttributeTable(ClassInfo classInfo, Database database) {
        Table segmentTable = database.addTable(classInfo.getTableName());
        segmentTable.addColumn("CDO_OID", ColumnType.BIGINT_LITERAL, "NOT NULL");
        AttributeInfo[] attributeInfos = classInfo.getAttributeInfos();
        int i = 0;
        while (i < attributeInfos.length) {
            AttributeInfo attributeInfo = attributeInfos[i];
            String columnName = attributeInfo.getColumnName();
            ColumnType columnType = ColumnType.get((int)attributeInfo.getColumnType());
            segmentTable.addColumn(columnName, columnType);
            ++i;
        }
        segmentTable.addSimpleIndex("CDO_OID", IndexType.PRIMARY_LITERAL);
    }
}

