/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.examples.ui.internal.editors;

import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.cdo.client.ResourceInfo;
import org.eclipse.emf.cdo.examples.ui.internal.ExampleUIActivator;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;

public final class CDOEditorInput
implements IEditorInput {
    private ResourceInfo resourceInfo;

    public CDOEditorInput(ResourceInfo resourceInfo) {
        this.resourceInfo = resourceInfo;
    }

    public ResourceInfo getResourceInfo() {
        return this.resourceInfo;
    }

    public boolean exists() {
        return this.resourceInfo.isExisting();
    }

    public String getResourceURI() {
        return "cdo://" + this.resourceInfo.getPath();
    }

    public ImageDescriptor getImageDescriptor() {
        return CDOEditorInput.getImageDescriptor("full/obj16/CDOResource");
    }

    public String getName() {
        String path = this.getResourceURI();
        if (path != null) {
            return path;
        }
        int rid = this.resourceInfo.getRID();
        return Integer.toString(rid);
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return "CDO Resource " + this.getName();
    }

    public Object getAdapter(Class adapterType) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapterType);
    }

    private static ImageDescriptor getImageDescriptor(String key) {
        Object image = ExampleUIActivator.getPlugin().getImage(key);
        return ExtendedImageRegistry.getInstance().getImageDescriptor(image);
    }
}

