/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.match.statistic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.compare.EMFComparePlugin;
import org.eclipse.emf.compare.FactoryException;
import org.eclipse.emf.compare.match.statistic.FeatureInformation;
import org.eclipse.emf.compare.util.EFactory;
import org.eclipse.emf.compare.util.EMFCompareMap;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetamodelFilter {
    protected final Map<String, FeatureInformation> featuresToInformation = new EMFCompareMap();
    protected List<EStructuralFeature> unusedFeatures;
    private final Map<EClass, List<EStructuralFeature>> eClassToFeaturesList = new EMFCompareMap();

    public void analyseModel(EObject root) {
        this.processEObject(root);
        TreeIterator it = root.eAllContents();
        while (it.hasNext()) {
            EObject eObj = (EObject)it.next();
            this.processEObject(eObj);
        }
        this.unusedFeatures = null;
        this.eClassToFeaturesList.clear();
    }

    public void clear() {
        this.featuresToInformation.clear();
        this.unusedFeatures = null;
        this.eClassToFeaturesList.clear();
    }

    public List<EStructuralFeature> getFilteredFeatures(EObject eObj) {
        if (this.eClassToFeaturesList.containsKey(eObj.eClass())) {
            return this.eClassToFeaturesList.get(eObj.eClass());
        }
        ArrayList<EStructuralFeature> result = new ArrayList<EStructuralFeature>();
        Collection<EStructuralFeature> unused = this.getUnusedFeatures();
        for (EStructuralFeature feat : eObj.eClass().getEAllStructuralFeatures()) {
            if (unused.contains(feat)) continue;
            result.add(feat);
        }
        this.eClassToFeaturesList.put(eObj.eClass(), result);
        return result;
    }

    private void buildUnusedFeatures() {
        this.unusedFeatures = new ArrayList<EStructuralFeature>();
        for (String feat : this.featuresToInformation.keySet()) {
            if (!this.featuresToInformation.get(feat).hasUniqueValue()) continue;
            this.unusedFeatures.add(this.featuresToInformation.get(feat).getFeature());
        }
    }

    private Collection<EStructuralFeature> getUnusedFeatures() {
        if (this.unusedFeatures == null) {
            this.buildUnusedFeatures();
        }
        return this.unusedFeatures;
    }

    private void processEObject(EObject eObj) {
        for (EStructuralFeature feat : eObj.eClass().getEAllStructuralFeatures()) {
            StringBuilder key = new StringBuilder();
            key.append(feat.hashCode());
            key.append(eObj.eClass().getName());
            if (!this.featuresToInformation.containsKey(key.toString())) {
                this.featuresToInformation.put(key.toString(), new FeatureInformation(feat));
            }
            try {
                if (EFactory.eGet((EObject)eObj, (String)feat.getName()) != null) {
                    this.featuresToInformation.get(key.toString()).processValue(eObj.eGet(feat).toString());
                    continue;
                }
                this.featuresToInformation.get(key.toString()).processValue("null");
            }
            catch (FactoryException e) {
                EMFComparePlugin.log((String)e.getMessage(), (boolean)false);
            }
        }
    }
}

