/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.lifecycle;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.eclipse.net4j.util.lifecycle.Worker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class QueueWorker<E>
extends Worker {
    private BlockingQueue<E> queue;
    private long pollMillis;

    public QueueWorker() {
        this.setPollMillis(100L);
    }

    public long getPollMillis() {
        return this.pollMillis;
    }

    public void setPollMillis(long pollMillis) {
        this.pollMillis = pollMillis;
    }

    public boolean addWork(E element) {
        if (this.queue != null) {
            return this.queue.offer(element);
        }
        return false;
    }

    @Override
    protected final void work(Worker.WorkContext context) throws Exception {
        E element = this.queue.poll(this.pollMillis, TimeUnit.MILLISECONDS);
        if (element != null) {
            this.work(context, element);
        }
    }

    protected abstract void work(Worker.WorkContext var1, E var2);

    protected BlockingQueue<E> createQueue() {
        return new LinkedBlockingQueue();
    }

    @Override
    protected void doActivate() throws Exception {
        this.queue = this.createQueue();
        super.doActivate();
    }

    @Override
    protected void doDeactivate() throws Exception {
        super.doDeactivate();
        if (this.queue != null) {
            this.queue.clear();
            this.queue = null;
        }
    }
}

