/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.jms.server.internal.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.eclipse.net4j.db.IDBAdapter;
import org.eclipse.net4j.jms.internal.server.store.AbstractStore;
import org.eclipse.net4j.jms.internal.server.store.StoreException;
import org.eclipse.net4j.jms.server.IStoreTransaction;
import org.eclipse.net4j.jms.server.internal.jdbc.JDBCTransaction;
import org.eclipse.net4j.jms.server.internal.jdbc.JMSSchema;

public class JDBCStore
extends AbstractStore {
    private static final String STORE_TYPE = "JDBC";
    private IDBAdapter dbAdapter;
    private DataSource dataSource;

    public JDBCStore(IDBAdapter dbAdapter, DataSource dataSource) {
        super(STORE_TYPE);
        if (dbAdapter == null) {
            throw new IllegalArgumentException("dbAdapter == null");
        }
        if (dataSource == null) {
            throw new IllegalArgumentException("dataSource == null");
        }
        this.dbAdapter = dbAdapter;
        this.dataSource = dataSource;
    }

    public IDBAdapter getDBAdapter() {
        return this.dbAdapter;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public Connection getConnection() {
        try {
            return this.dataSource.getConnection();
        }
        catch (SQLException ex) {
            throw new StoreException((Throwable)ex);
        }
    }

    public void initDatabase(String instanceID) {
        JMSSchema.INSTANCE.create(this.dbAdapter, this.dataSource);
    }

    public IStoreTransaction startTransaction() {
        try {
            Connection connection = this.getConnection();
            connection.setAutoCommit(false);
            return new JDBCTransaction(this, connection);
        }
        catch (SQLException ex) {
            throw new StoreException((Throwable)ex);
        }
    }

    public void commitTransaction(IStoreTransaction transaction) {
        JDBCTransaction jdbcTransaction = (JDBCTransaction)transaction;
        try {
            try {
                Connection connection = jdbcTransaction.getConnection();
                connection.commit();
            }
            catch (SQLException ex) {
                throw new StoreException((Throwable)ex);
            }
        }
        finally {
            jdbcTransaction.dispose();
        }
    }

    public void rollbackTransaction(IStoreTransaction transaction) {
        JDBCTransaction jdbcTransaction = (JDBCTransaction)transaction;
        try {
            try {
                Connection connection = jdbcTransaction.getConnection();
                connection.rollback();
            }
            catch (SQLException ex) {
                throw new StoreException((Throwable)ex);
            }
        }
        finally {
            jdbcTransaction.dispose();
        }
    }
}

