/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.net4j.protocol;

import java.io.IOException;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.io.CDODataInput;
import org.eclipse.emf.cdo.common.io.CDODataOutput;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.model.CDOType;
import org.eclipse.emf.cdo.common.revision.CDOList;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.emf.internal.cdo.net4j.protocol.CDOClientProtocol;
import org.eclipse.emf.internal.cdo.net4j.protocol.CDOClientRequest;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadChunkRequest
extends CDOClientRequest<Object> {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_PROTOCOL, LoadChunkRequest.class);
    private InternalCDORevision revision;
    private EStructuralFeature feature;
    private int accessIndex;
    private int fromIndex;
    private int toIndex;
    private int fetchIndex;

    public LoadChunkRequest(CDOClientProtocol protocol, InternalCDORevision revision, EStructuralFeature feature, int accessIndex, int fetchIndex, int fromIndex, int toIndex) {
        super(protocol, (short)10);
        this.revision = revision;
        this.feature = feature;
        this.accessIndex = accessIndex;
        this.fetchIndex = fetchIndex;
        this.fromIndex = fromIndex;
        this.toIndex = toIndex;
    }

    @Override
    protected void requesting(CDODataOutput out) throws IOException {
        CDOID id = this.revision.getID();
        if (TRACER.isEnabled()) {
            TRACER.format("Writing revision ID: {0}", new Object[]{id});
        }
        out.writeCDOID(id);
        int version = this.revision.getVersion();
        if (this.revision.isTransactional()) {
            --version;
        }
        if (TRACER.isEnabled()) {
            TRACER.format("Writing revision version: {0}", new Object[]{version});
        }
        out.writeInt(version);
        if (TRACER.isEnabled()) {
            TRACER.format("Writing feature: {0}", new Object[]{this.feature});
        }
        out.writeCDOClassifierRef((EClassifier)this.feature.getEContainingClass());
        out.writeInt(this.feature.getFeatureID());
        if (TRACER.isEnabled()) {
            TRACER.format("Writing fromIndex: {0}", new Object[]{this.fromIndex});
        }
        int diffIndex = this.accessIndex - this.fetchIndex;
        out.writeInt(this.fromIndex - diffIndex);
        if (TRACER.isEnabled()) {
            TRACER.format("Writing toIndex: {0}", new Object[]{this.toIndex});
        }
        out.writeInt(this.toIndex - diffIndex);
    }

    @Override
    protected Object confirming(CDODataInput in) throws IOException {
        CDOType type = CDOModelUtil.getType((EStructuralFeature)this.feature);
        Object accessID = null;
        CDOList list = this.revision.getList(this.feature);
        int i = this.fromIndex;
        while (i <= this.toIndex) {
            Object value = type.readValue(in);
            list.set(i, value);
            if (i == this.accessIndex) {
                accessID = value;
            }
            ++i;
        }
        return accessID;
    }
}

