/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.transaction;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.CDOState;
import org.eclipse.emf.cdo.common.CDOCommonView;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDAndVersion;
import org.eclipse.emf.cdo.common.id.CDOIDTemp;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.model.CDOPackageRegistry;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.common.model.EMFUtil;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDeltaUtil;
import org.eclipse.emf.cdo.common.util.CDOException;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.CDOResourceFolder;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.eresource.EresourceFactory;
import org.eclipse.emf.cdo.eresource.impl.CDOResourceImpl;
import org.eclipse.emf.cdo.eresource.impl.CDOResourceNodeImpl;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionDelta;
import org.eclipse.emf.cdo.transaction.CDOConflictResolver;
import org.eclipse.emf.cdo.transaction.CDOSavepoint;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.transaction.CDOTransactionConflictEvent;
import org.eclipse.emf.cdo.transaction.CDOTransactionFinishedEvent;
import org.eclipse.emf.cdo.transaction.CDOTransactionHandler;
import org.eclipse.emf.cdo.transaction.CDOTransactionStartedEvent;
import org.eclipse.emf.cdo.util.CDOURIUtil;
import org.eclipse.emf.cdo.view.CDOViewResourcesEvent;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.internal.cdo.CDOObjectMerger;
import org.eclipse.emf.internal.cdo.CDOStateMachine;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.emf.internal.cdo.messages.Messages;
import org.eclipse.emf.internal.cdo.transaction.CDOSavepointImpl;
import org.eclipse.emf.internal.cdo.util.CompletePackageClosure;
import org.eclipse.emf.internal.cdo.util.FSMUtil;
import org.eclipse.emf.internal.cdo.view.CDOViewImpl;
import org.eclipse.emf.spi.cdo.CDOSessionProtocol;
import org.eclipse.emf.spi.cdo.CDOTransactionStrategy;
import org.eclipse.emf.spi.cdo.InternalCDOObject;
import org.eclipse.emf.spi.cdo.InternalCDOSession;
import org.eclipse.emf.spi.cdo.InternalCDOTransaction;
import org.eclipse.net4j.util.ImplementationError;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.eclipse.net4j.util.options.IOptions;
import org.eclipse.net4j.util.options.OptionsEvent;
import org.eclipse.net4j.util.transaction.TransactionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOTransactionImpl
extends CDOViewImpl
implements InternalCDOTransaction {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_TRANSCTION, CDOTransactionImpl.class);
    private List<CDOTransactionHandler> handlers = new ArrayList<CDOTransactionHandler>(0);
    private CDOSavepointImpl lastSavepoint;
    private CDOSavepointImpl firstSavepoint = this.lastSavepoint = new CDOSavepointImpl(this, null);
    private boolean dirty;
    private int conflict;
    private long lastCommitTime = 0L;
    private int lastTemporaryID;
    private CDOTransactionStrategy transactionStrategy;

    @Override
    public OptionsImpl options() {
        return (OptionsImpl)super.options();
    }

    @Override
    protected OptionsImpl createOptions() {
        return new OptionsImpl();
    }

    @Override
    public CDOCommonView.Type getViewType() {
        return CDOCommonView.Type.TRANSACTION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addHandler(CDOTransactionHandler handler) {
        List<CDOTransactionHandler> list = this.handlers;
        synchronized (list) {
            if (!this.handlers.contains(handler)) {
                this.handlers.add(handler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeHandler(CDOTransactionHandler handler) {
        List<CDOTransactionHandler> list = this.handlers;
        synchronized (list) {
            this.handlers.remove(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CDOTransactionHandler[] getHandlers() {
        List<CDOTransactionHandler> list = this.handlers;
        synchronized (list) {
            return this.handlers.toArray(new CDOTransactionHandler[this.handlers.size()]);
        }
    }

    @Override
    public boolean isDirty() {
        if (this.isClosed()) {
            return false;
        }
        return this.dirty;
    }

    @Override
    public boolean hasConflict() {
        this.checkActive();
        return this.conflict != 0;
    }

    @Override
    public void setConflict(InternalCDOObject object) {
        ConflictEvent event = new ConflictEvent(object, this.conflict == 0);
        ++this.conflict;
        this.fireEvent(event);
    }

    @Override
    public Set<CDOObject> getConflicts() {
        HashSet<CDOObject> conflicts = new HashSet<CDOObject>();
        for (CDOObject object : this.getDirtyObjects().values()) {
            if (!object.cdoConflict()) continue;
            conflicts.add(object);
        }
        for (CDOObject object : this.getDetachedObjects().values()) {
            if (!object.cdoConflict()) continue;
            conflicts.add(object);
        }
        return conflicts;
    }

    @Override
    public void resolveConflicts(CDOConflictResolver ... resolvers) {
        Set<CDOObject> conflicts = this.getConflicts();
        this.handleConflicts(conflicts, resolvers);
    }

    @Override
    public void handleConflicts(Set<CDOObject> conflicts) {
        this.handleConflicts(conflicts, this.options().getConflictResolvers());
    }

    /*
     * Unable to fully structure code
     */
    private void handleConflicts(Set<CDOObject> conflicts, CDOConflictResolver[] resolvers) {
        block7: {
            if (resolvers.length == 0) {
                return;
            }
            states = new ArrayList<CDOState>(conflicts.size());
            revisions = new ArrayList<CDORevision>(conflicts.size());
            for (CDOObject conflict : conflicts) {
                states.add(conflict.cdoState());
                revisions.add(conflict.cdoRevision());
            }
            resolved = 0;
            try {
                remaining = new HashSet<CDOObject>(conflicts);
                var10_9 = resolvers;
                var9_11 = resolvers.length;
                var8_13 = 0;
                while (var8_13 < var9_11) {
                    resolver = var10_9[var8_13];
                    resolver.resolveConflicts(Collections.unmodifiableSet(remaining));
                    it = remaining.iterator();
                    while (it.hasNext()) {
                        object = (CDOObject)it.next();
                        if (object.cdoConflict()) continue;
                        ++resolved;
                        it.remove();
                    }
                    ++var8_13;
                }
                break block7;
            }
            catch (Exception ex) {
                state = states.iterator();
                revision = revisions.iterator();
                ** for (object : conflicts)
            }
lbl-1000:
            // 1 sources

            {
                ((InternalCDOObject)object).cdoInternalSetState((CDOState)state.next());
                ((InternalCDOObject)object).cdoInternalSetRevision((CDORevision)revision.next());
                continue;
            }
lbl38:
            // 1 sources

            throw WrappedException.wrap((Exception)ex);
        }
        this.conflict -= resolved;
    }

    @Override
    public void getCDOIDAndVersion(Map<CDOID, CDOIDAndVersion> uniqueObjects, Collection<? extends CDOObject> cdoObjects) {
        Map<CDOID, CDORevisionDelta> deltaMap = this.getRevisionDeltas();
        for (CDOObject cDOObject : cdoObjects) {
            CDORevisionDelta delta;
            InternalCDORevision cdoRevision = CDOStateMachine.INSTANCE.readNoLoad((InternalCDOObject)cDOObject);
            CDOID cdoId = cDOObject.cdoID();
            if (cdoRevision == null || cdoId.isTemporary() || uniqueObjects.containsKey(cdoId)) continue;
            int version = cdoRevision.getVersion();
            if (deltaMap != null && (delta = deltaMap.get(cdoId)) != null) {
                version = delta.getOriginVersion();
            }
            uniqueObjects.put(cdoId, CDOIDUtil.createIDAndVersion((CDOID)cdoId, (int)version));
        }
    }

    @Override
    public long getLastCommitTime() {
        return this.lastCommitTime;
    }

    @Override
    public CDOIDTemp getNextTemporaryID() {
        return CDOIDUtil.createTempObject((int)(++this.lastTemporaryID));
    }

    @Override
    protected CDOResourceImpl createRootResource() {
        return (CDOResourceImpl)this.getOrCreateResource("/");
    }

    @Override
    public CDOResource createResource(String path) {
        this.checkActive();
        URI uri = CDOURIUtil.createResourceURI(this, path);
        return (CDOResource)this.getResourceSet().createResource(uri);
    }

    @Override
    public CDOResource getOrCreateResource(String path) {
        this.checkActive();
        try {
            CDOID id = this.getResourceNodeID(path);
            if (!CDOIDUtil.isNull((CDOID)id)) {
                return (CDOResource)((Object)this.getObject(id));
            }
        }
        catch (Exception exception) {}
        return this.createResource(path);
    }

    @Override
    public void attachResource(CDOResourceImpl resource) {
        if (resource.isExisting()) {
            super.attachResource(resource);
        } else {
            this.attachNewResource(resource);
        }
    }

    private void attachNewResource(CDOResourceImpl resource) {
        URI uri = resource.getURI();
        List<String> names = CDOURIUtil.analyzePath(uri);
        String resourceName = names.isEmpty() ? null : names.remove(names.size() - 1);
        CDOResourceFolder folder = this.getOrCreateResourceFolder(names);
        this.attachNewResourceNode(folder, resourceName, resource);
    }

    @Override
    public CDOResourceFolder getOrCreateResourceFolder(List<String> names) {
        CDOObject folder = null;
        for (String name : names) {
            CDOResourceNode node;
            try {
                CDOID folderID = folder == null ? null : folder.cdoID();
                node = this.getResourceNode(folderID, name);
            }
            catch (CDOException cDOException) {
                node = EresourceFactory.eINSTANCE.createCDOResourceFolder();
                this.attachNewResourceNode((CDOResourceFolder)folder, name, node);
            }
            if (node instanceof CDOResourceFolder) {
                folder = node;
                continue;
            }
            throw new CDOException(MessageFormat.format(Messages.getString("CDOTransactionImpl.0"), node));
        }
        return folder;
    }

    private void attachNewResourceNode(CDOResourceFolder folder, String name, CDOResourceNode newNode) {
        CDOResourceNodeImpl node = (CDOResourceNodeImpl)newNode;
        node.basicSetName(name, false);
        if (folder == null) {
            if (node.isRoot()) {
                CDOStateMachine.INSTANCE.attach(node, this);
            } else {
                this.getRootResource().getContents().add((Object)node);
            }
        } else {
            node.basicSetFolder(folder, false);
        }
    }

    public void detach(CDOResourceImpl cdoResource) {
        CDOStateMachine.INSTANCE.detach(cdoResource);
        this.fireEvent(new ResourcesEvent(cdoResource.getPath(), CDOViewResourcesEvent.Kind.REMOVED));
    }

    @Override
    public CDOSavepointImpl getLastSavepoint() {
        this.checkActive();
        return this.lastSavepoint;
    }

    @Override
    public CDOTransactionStrategy getTransactionStrategy() {
        if (this.transactionStrategy == null) {
            this.transactionStrategy = CDOTransactionStrategy.DEFAULT;
            this.transactionStrategy.setTarget(this);
        }
        return this.transactionStrategy;
    }

    @Override
    public void setTransactionStrategy(CDOTransactionStrategy transactionStrategy) {
        if (this.transactionStrategy != null) {
            this.transactionStrategy.unsetTarget(this);
        }
        this.transactionStrategy = transactionStrategy;
        if (this.transactionStrategy != null) {
            this.transactionStrategy.setTarget(this);
        }
    }

    @Override
    protected CDOID getRootOrTopLevelResourceNodeID(String name) {
        if (this.dirty) {
            CDOResourceNode node = this.getRootResourceNode(name, this.getDirtyObjects().values());
            if (node != null) {
                return node.cdoID();
            }
            node = this.getRootResourceNode(name, this.getNewObjects().values());
            if (node != null) {
                return node.cdoID();
            }
            node = this.getRootResourceNode(name, this.getNewResources().values());
            if (node != null) {
                return node.cdoID();
            }
        }
        CDOID id = super.getRootOrTopLevelResourceNodeID(name);
        if (this.getLastSavepoint().getAllDetachedObjects().containsKey(id) || this.getDirtyObjects().containsKey(id)) {
            throw new CDOException(MessageFormat.format(Messages.getString("CDOTransactionImpl.1"), name));
        }
        return id;
    }

    private CDOResourceNode getRootResourceNode(String name, Collection<? extends CDOObject> objects) {
        for (CDOObject cDOObject : objects) {
            CDOResourceNode node;
            if (!(cDOObject instanceof CDOResourceNode) || (node = (CDOResourceNode)cDOObject).getFolder() != null || !ObjectUtil.equals((Object)name, (Object)node.getName())) continue;
            return node;
        }
        return null;
    }

    @Override
    public InternalCDOObject getObject(CDOID id, boolean loadOnDemand) {
        this.checkActive();
        if (CDOIDUtil.isNull((CDOID)id)) {
            return null;
        }
        if (id.isTemporary() && this.isDetached(id)) {
            FSMUtil.validate(id, null);
        }
        return super.getObject(id, loadOnDemand);
    }

    private boolean isDetached(CDOID id) {
        return this.lastSavepoint.getSharedDetachedObjects().contains(id);
    }

    @Override
    public InternalCDOTransaction.InternalCDOCommitContext createCommitContext() {
        return new CDOCommitContextImpl();
    }

    @Override
    public void commit(IProgressMonitor progressMonitor) throws TransactionException {
        this.checkActive();
        if (this.hasConflict()) {
            throw new TransactionException(Messages.getString("CDOTransactionImpl.2"));
        }
        if (progressMonitor == null) {
            progressMonitor = new NullProgressMonitor();
        }
        try {
            this.getTransactionStrategy().commit(this, progressMonitor);
        }
        catch (TransactionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new TransactionException((Throwable)ex);
        }
    }

    @Override
    public void commit() throws TransactionException {
        this.commit(null);
    }

    @Override
    public void rollback() {
        this.checkActive();
        this.rollback(this.firstSavepoint);
        this.cleanUp();
    }

    private void removeObjects(Collection<? extends CDOObject> objects) {
        if (!objects.isEmpty()) {
            for (CDOObject cDOObject : objects) {
                ((InternalCDOObject)cDOObject).cdoInternalSetState(CDOState.TRANSIENT);
                this.removeObject(cDOObject.cdoID());
                if (cDOObject instanceof CDOResource) {
                    this.getResourceSet().getResources().remove((Object)cDOObject);
                }
                ((InternalCDOObject)cDOObject).cdoInternalSetID(null);
                ((InternalCDOObject)cDOObject).cdoInternalSetRevision(null);
                ((InternalCDOObject)cDOObject).cdoInternalSetView(null);
            }
        }
    }

    private Set<CDOID> rollbackCompletely(CDOSavepoint savepoint) {
        HashSet<CDOID> idsOfNewObjectWithDeltas = new HashSet<CDOID>();
        CDOSavepointImpl itrSavepoint = this.lastSavepoint;
        while (itrSavepoint != null) {
            InternalCDOObject internalDirtyObject;
            Map<CDOID, CDOObject> detachedObjects;
            this.removeObjects(itrSavepoint.getNewResources().values());
            this.removeObjects(itrSavepoint.getNewObjects().values());
            ConcurrentMap<CDOID, CDORevisionDelta> revisionDeltas = itrSavepoint.getRevisionDeltas();
            if (!revisionDeltas.isEmpty()) {
                for (CDORevisionDelta dirtyObject : revisionDeltas.values()) {
                    if (!dirtyObject.getID().isTemporary()) continue;
                    idsOfNewObjectWithDeltas.add(dirtyObject.getID());
                }
            }
            if (!(detachedObjects = itrSavepoint.getDetachedObjects()).isEmpty()) {
                for (Map.Entry<CDOID, CDOObject> entryDirty : detachedObjects.entrySet()) {
                    if (entryDirty.getKey().isTemporary()) {
                        idsOfNewObjectWithDeltas.add(entryDirty.getKey());
                        continue;
                    }
                    internalDirtyObject = (InternalCDOObject)entryDirty.getValue();
                    this.cleanObject(internalDirtyObject, this.getRevision(entryDirty.getKey(), true));
                }
            }
            for (Map.Entry<CDOID, CDOObject> entryDirtyObject : itrSavepoint.getDirtyObjects().entrySet()) {
                if (entryDirtyObject.getKey().isTemporary()) continue;
                internalDirtyObject = (InternalCDOObject)entryDirtyObject.getValue();
                CDOStateMachine.INSTANCE.rollback(internalDirtyObject);
            }
            if (savepoint == itrSavepoint) break;
            itrSavepoint = itrSavepoint.getPreviousSavepoint();
        }
        return idsOfNewObjectWithDeltas;
    }

    /*
     * WARNING - void declaration
     */
    private void loadSavepoint(CDOSavepoint savepoint, Set<CDOID> idsOfNewObjectWithDeltas) {
        void var8_15;
        InternalCDOObject object;
        this.lastSavepoint.recalculateSharedDetachedObjects();
        Map<CDOID, CDOObject> dirtyObjects = this.getDirtyObjects();
        Map<CDOID, CDOObject> newObjMaps = this.getNewObjects();
        Map<CDOID, CDOResource> newResources = this.getNewResources();
        Map<CDOID, CDORevision> newBaseRevision = this.getBaseNewObjects();
        Map<CDOID, CDOObject> detachedObjects = this.getDetachedObjects();
        for (CDOID cDOID : idsOfNewObjectWithDeltas) {
            CDORevision revision;
            if (detachedObjects.containsKey(cDOID)) continue;
            object = (InternalCDOObject)newObjMaps.get(cDOID);
            if (object == null) {
                object = (InternalCDOObject)((Object)newResources.get(cDOID));
            }
            if ((revision = newBaseRevision.get(cDOID)) == null) continue;
            object.cdoInternalSetRevision(revision.copy());
            object.cdoInternalSetView(this);
            object.cdoInternalSetID(revision.getID());
            object.cdoInternalSetState(CDOState.NEW);
            object.cdoInternalPostLoad();
        }
        for (Map.Entry entry : newObjMaps.entrySet()) {
            object = (InternalCDOObject)entry.getValue();
            this.cleanObject(object, object.cdoRevision());
            object.cdoInternalSetState(CDOState.NEW);
        }
        for (Map.Entry entry : dirtyObjects.entrySet()) {
            if (detachedObjects.containsKey(entry.getKey())) continue;
            InternalCDOObject internalDirtyObject = (InternalCDOObject)entry.getValue();
            this.cleanObject(internalDirtyObject, this.getRevision((CDOID)entry.getKey(), true));
        }
        CDOSavepointImpl cDOSavepointImpl = this.firstSavepoint;
        while (var8_15 != savepoint) {
            CDOObjectMerger merger = new CDOObjectMerger();
            for (CDORevisionDelta delta : var8_15.getRevisionDeltas().values()) {
                if (delta.getID().isTemporary() && !idsOfNewObjectWithDeltas.contains(delta.getID()) || detachedObjects.containsKey(delta.getID())) continue;
                Map<CDOID, CDOObject> map = delta.getID().isTemporary() ? newObjMaps : dirtyObjects;
                InternalCDOObject object2 = (InternalCDOObject)map.get(delta.getID());
                if (object2 == null) {
                    object2 = (InternalCDOObject)((Object)newResources.get(delta.getID()));
                }
                merger.merge(object2, delta);
                object2.cdoInternalPostLoad();
            }
            CDOSavepointImpl cDOSavepointImpl2 = var8_15.getNextSavepoint();
        }
        this.dirty = ((CDOSavepointImpl)savepoint).isDirty();
    }

    @Override
    public void detachObject(InternalCDOObject object) {
        CDOTransactionHandler[] cDOTransactionHandlerArray = this.getHandlers();
        int n = cDOTransactionHandlerArray.length;
        int n2 = 0;
        while (n2 < n) {
            CDOTransactionHandler handler = cDOTransactionHandlerArray[n2];
            handler.detachingObject(this, object);
            ++n2;
        }
        if (object.cdoState() == CDOState.NEW) {
            Map<CDOID, CDOObject> map;
            Map<CDOID, CDOObject> map2 = map = object instanceof CDOResource ? this.getLastSavepoint().getNewResources() : this.getLastSavepoint().getNewObjects();
            if (map.containsKey(object.cdoID())) {
                this.deregisterObject(object);
                map.remove(object.cdoID());
            } else {
                this.getLastSavepoint().getDetachedObjects().put(object.cdoID(), object);
            }
        } else {
            this.getLastSavepoint().getDetachedObjects().put(object.cdoID(), object);
        }
        if (!this.dirty) {
            this.dirty = true;
            this.fireEvent(new StartedEvent());
        }
    }

    @Override
    public void rollback(CDOSavepoint savepoint) {
        this.checkActive();
        this.getTransactionStrategy().rollback(this, savepoint);
    }

    @Override
    public void handleRollback(CDOSavepoint savepoint) {
        if (savepoint == null) {
            throw new IllegalArgumentException(Messages.getString("CDOTransactionImpl.3"));
        }
        if (savepoint.getUserTransaction() != this) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.getString("CDOTransactionImpl.4"), savepoint));
        }
        if (TRACER.isEnabled()) {
            TRACER.trace("handleRollback()");
        }
        try {
            if (!savepoint.isValid()) {
                throw new IllegalArgumentException(MessageFormat.format(Messages.getString("CDOTransactionImpl.6"), savepoint));
            }
            ReentrantLock viewLock = this.getStateLock();
            viewLock.lock();
            try {
                Set<CDOID> idsOfNewObjectWithDeltas = this.rollbackCompletely(savepoint);
                this.lastSavepoint = (CDOSavepointImpl)savepoint;
                this.lastSavepoint.setNextSavepoint(null);
                this.lastSavepoint.clear();
                this.loadSavepoint(this.lastSavepoint, idsOfNewObjectWithDeltas);
                if (this.lastSavepoint == this.firstSavepoint && this.options().isAutoReleaseLocksEnabled()) {
                    this.unlockObjects(null, null);
                }
            }
            finally {
                viewLock.unlock();
            }
            Map idMappings = Collections.emptyMap();
            this.fireEvent(new FinishedEvent(CDOTransactionFinishedEvent.Type.ROLLED_BACK, idMappings));
            CDOTransactionHandler[] cDOTransactionHandlerArray = this.getHandlers();
            int n = cDOTransactionHandlerArray.length;
            int n2 = 0;
            while (n2 < n) {
                CDOTransactionHandler handler = cDOTransactionHandlerArray[n2];
                try {
                    handler.rolledBackTransaction(this);
                }
                catch (RuntimeException ex) {
                    OM.LOG.error((Throwable)ex);
                }
                ++n2;
            }
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new TransactionException((Throwable)ex);
        }
    }

    @Override
    public CDOSavepoint handleSetSavepoint() {
        this.addToBase(this.lastSavepoint.getNewObjects());
        this.addToBase(this.lastSavepoint.getNewResources());
        this.lastSavepoint = new CDOSavepointImpl(this, this.lastSavepoint);
        return this.lastSavepoint;
    }

    @Override
    public CDOSavepoint setSavepoint() {
        this.checkActive();
        return this.getTransactionStrategy().setSavepoint(this);
    }

    private void addToBase(Map<CDOID, ? extends CDOObject> objects) {
        for (CDOObject cDOObject : objects.values()) {
            ((InternalCDOObject)cDOObject).cdoInternalPreCommit();
            this.lastSavepoint.getBaseNewObjects().put(cDOObject.cdoID(), cDOObject.cdoRevision().copy());
        }
    }

    @Override
    public String toString() {
        return MessageFormat.format("CDOTransaction({0})", this.getViewID());
    }

    @Override
    public void registerNew(InternalCDOObject object) {
        if (TRACER.isEnabled()) {
            TRACER.format("Registering new object {0}", new Object[]{object});
        }
        this.registerNewPackage(object.eClass().getEPackage());
        CDOTransactionHandler[] cDOTransactionHandlerArray = this.getHandlers();
        int n = cDOTransactionHandlerArray.length;
        int n2 = 0;
        while (n2 < n) {
            CDOTransactionHandler handler = cDOTransactionHandlerArray[n2];
            handler.attachingObject(this, object);
            ++n2;
        }
        if (object instanceof CDOResourceImpl) {
            this.registerNew(this.lastSavepoint.getNewResources(), object);
        } else {
            this.registerNew(this.lastSavepoint.getNewObjects(), object);
        }
    }

    private void registerNewPackage(EPackage ePackage) {
        InternalCDOPackageRegistry packageRegistry = this.getSession().getPackageRegistry();
        if (!packageRegistry.containsKey((Object)ePackage.getNsURI())) {
            packageRegistry.putEPackage(ePackage);
        }
    }

    @Override
    public void registerFeatureDelta(InternalCDOObject object, CDOFeatureDelta featureDelta) {
        boolean needToSaveFeatureDelta = true;
        if (object.cdoState() == CDOState.NEW) {
            if (this.getLastSavepoint().getPreviousSavepoint() == null || featureDelta == null) {
                needToSaveFeatureDelta = false;
            } else {
                Map<CDOID, CDOObject> map = object instanceof CDOResource ? this.getLastSavepoint().getNewResources() : this.getLastSavepoint().getNewObjects();
                boolean bl = needToSaveFeatureDelta = !map.containsKey(object.cdoID());
            }
        }
        if (needToSaveFeatureDelta) {
            CDORevisionDelta revisionDelta = (CDORevisionDelta)this.lastSavepoint.getRevisionDeltas().get(object.cdoID());
            if (revisionDelta == null) {
                revisionDelta = CDORevisionDeltaUtil.create((CDORevision)object.cdoRevision());
                this.lastSavepoint.getRevisionDeltas().put(object.cdoID(), revisionDelta);
            }
            ((InternalCDORevisionDelta)revisionDelta).addFeatureDelta(featureDelta);
        }
        CDOTransactionHandler[] cDOTransactionHandlerArray = this.getHandlers();
        int n = cDOTransactionHandlerArray.length;
        int n2 = 0;
        while (n2 < n) {
            CDOTransactionHandler handler = cDOTransactionHandlerArray[n2];
            handler.modifyingObject(this, object, featureDelta);
            ++n2;
        }
    }

    @Override
    public void registerRevisionDelta(CDORevisionDelta revisionDelta) {
        this.lastSavepoint.getRevisionDeltas().putIfAbsent(revisionDelta.getID(), revisionDelta);
    }

    @Override
    public void registerDirty(InternalCDOObject object, CDOFeatureDelta featureDelta) {
        if (TRACER.isEnabled()) {
            TRACER.format("Registering dirty object {0}", new Object[]{object});
        }
        if (featureDelta != null) {
            this.registerFeatureDelta(object, featureDelta);
        }
        this.registerNew(this.lastSavepoint.getDirtyObjects(), object);
    }

    private void registerNew(Map map, InternalCDOObject object) {
        InternalCDOObject old = map.put(object.cdoID(), object);
        if (old != null) {
            throw new ImplementationError(MessageFormat.format(Messages.getString("CDOTransactionImpl.10"), object));
        }
        if (!this.dirty) {
            this.dirty = true;
            this.fireEvent(new StartedEvent());
        }
    }

    private List<CDOPackageUnit> analyzeNewPackages() {
        InternalCDOPackageRegistry packageRegistry = this.getSession().getPackageRegistry();
        HashSet<EPackage> usedPackages = new HashSet<EPackage>();
        HashSet<EPackage> usedNewPackages = new HashSet<EPackage>();
        for (CDOObject object : this.getNewObjects().values()) {
            CDOPackageUnit packageUnit;
            EPackage topLevelPackage;
            EPackage ePackage = object.eClass().getEPackage();
            if (!usedPackages.add(ePackage) || ePackage != (topLevelPackage = EMFUtil.getTopLevelPackage((EPackage)ePackage)) && !usedPackages.add(topLevelPackage) || CDOModelUtil.isSystemPackage((EPackage)topLevelPackage) || (packageUnit = packageRegistry.getPackageUnit(topLevelPackage)).getState() != CDOPackageUnit.State.NEW) continue;
            usedNewPackages.add(topLevelPackage);
        }
        if (usedNewPackages.size() > 0) {
            HashSet<CDOPackageUnit> result = new HashSet<CDOPackageUnit>();
            for (EPackage usedNewPackage : CDOTransactionImpl.analyzeNewPackages(usedNewPackages, (CDOPackageRegistry)packageRegistry)) {
                CDOPackageUnit packageUnit = packageRegistry.getPackageUnit(usedNewPackage);
                result.add(packageUnit);
            }
            return new ArrayList<CDOPackageUnit>(result);
        }
        return Collections.emptyList();
    }

    private static List<EPackage> analyzeNewPackages(Collection<EPackage> usedTopLevelPackages, CDOPackageRegistry packageRegistry) {
        ArrayList<EPackage> newPackages = new ArrayList<EPackage>();
        CompletePackageClosure closure = new CompletePackageClosure();
        usedTopLevelPackages = closure.calculate(usedTopLevelPackages);
        for (EPackage usedPackage : usedTopLevelPackages) {
            if (CDOModelUtil.isSystemPackage((EPackage)usedPackage)) continue;
            CDOPackageUnit packageUnit = packageRegistry.getPackageUnit(usedPackage);
            if (packageUnit == null) {
                throw new CDOException(MessageFormat.format(Messages.getString("CDOTransactionImpl.11"), usedPackage));
            }
            if (packageUnit.getState() != CDOPackageUnit.State.NEW) continue;
            newPackages.add(usedPackage);
        }
        return newPackages;
    }

    private void cleanUp() {
        this.lastSavepoint = this.firstSavepoint;
        this.firstSavepoint.clear();
        this.firstSavepoint.setNextSavepoint(null);
        this.firstSavepoint.getSharedDetachedObjects().clear();
        this.dirty = false;
        this.conflict = 0;
        this.lastTemporaryID = 0;
    }

    @Override
    public Map<CDOID, CDOObject> getDirtyObjects() {
        this.checkActive();
        return this.lastSavepoint.getAllDirtyObjects();
    }

    @Override
    public Map<CDOID, CDOObject> getNewObjects() {
        this.checkActive();
        return this.lastSavepoint.getAllNewObjects();
    }

    @Override
    public Map<CDOID, CDOResource> getNewResources() {
        this.checkActive();
        return this.lastSavepoint.getAllNewResources();
    }

    public Map<CDOID, CDORevision> getBaseNewObjects() {
        this.checkActive();
        return this.lastSavepoint.getAllBaseNewObjects();
    }

    @Override
    public Map<CDOID, CDORevisionDelta> getRevisionDeltas() {
        this.checkActive();
        return this.lastSavepoint.getAllRevisionDeltas();
    }

    @Override
    public Map<CDOID, CDOObject> getDetachedObjects() {
        this.checkActive();
        return this.lastSavepoint.getAllDetachedObjects();
    }

    @Override
    protected void doDeactivate() throws Exception {
        this.options().disposeConflictResolvers();
        this.lastSavepoint = null;
        this.firstSavepoint = null;
        this.transactionStrategy = null;
        super.doDeactivate();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CDOCommitContextImpl
    implements InternalCDOTransaction.InternalCDOCommitContext {
        private Map<CDOID, CDOResource> newResources;
        private Map<CDOID, CDOObject> newObjects;
        private Map<CDOID, CDOObject> dirtyObjects;
        private Map<CDOID, CDORevisionDelta> revisionDeltas;
        private Map<CDOID, CDOObject> detachedObjects;
        private List<CDOPackageUnit> newPackageUnits;

        public CDOCommitContextImpl() {
            CDOTransactionImpl transaction = this.getTransaction();
            this.newResources = transaction.getNewResources();
            this.newObjects = transaction.getNewObjects();
            this.dirtyObjects = transaction.getDirtyObjects();
            this.detachedObjects = transaction.getDetachedObjects();
            this.revisionDeltas = transaction.getRevisionDeltas();
            this.newPackageUnits = transaction.analyzeNewPackages();
        }

        @Override
        public CDOTransactionImpl getTransaction() {
            return CDOTransactionImpl.this;
        }

        @Override
        public Map<CDOID, CDOObject> getDirtyObjects() {
            return this.dirtyObjects;
        }

        @Override
        public Map<CDOID, CDOObject> getNewObjects() {
            return this.newObjects;
        }

        @Override
        public List<CDOPackageUnit> getNewPackageUnits() {
            return this.newPackageUnits;
        }

        @Override
        public Map<CDOID, CDOResource> getNewResources() {
            return this.newResources;
        }

        @Override
        public Map<CDOID, CDOObject> getDetachedObjects() {
            return this.detachedObjects;
        }

        @Override
        public Map<CDOID, CDORevisionDelta> getRevisionDeltas() {
            return this.revisionDeltas;
        }

        @Override
        public void preCommit() {
            if (CDOTransactionImpl.this.isDirty()) {
                if (TRACER.isEnabled()) {
                    TRACER.trace("commit()");
                }
                CDOTransactionHandler[] cDOTransactionHandlerArray = CDOTransactionImpl.this.getHandlers();
                int n = cDOTransactionHandlerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    CDOTransactionHandler handler = cDOTransactionHandlerArray[n2];
                    handler.committingTransaction(this.getTransaction(), this);
                    ++n2;
                }
                try {
                    this.preCommit(this.getNewResources());
                    this.preCommit(this.getNewObjects());
                    this.preCommit(this.getDirtyObjects());
                }
                catch (RuntimeException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw new TransactionException((Throwable)ex);
                }
            }
        }

        @Override
        public void postCommit(CDOSessionProtocol.CommitTransactionResult result) {
            if (CDOTransactionImpl.this.isDirty()) {
                try {
                    Collection<CDORevisionDelta> deltas = this.getRevisionDeltas().values();
                    this.postCommit(this.getNewResources(), result);
                    this.postCommit(this.getNewObjects(), result);
                    this.postCommit(this.getDirtyObjects(), result);
                    for (Map.Entry<CDOID, CDOObject> entry : this.getDetachedObjects().entrySet()) {
                        CDOTransactionImpl.this.removeObject(entry.getKey());
                    }
                    InternalCDOSession session = CDOTransactionImpl.this.getSession();
                    for (CDOPackageUnit newPackageUnit : this.newPackageUnits) {
                        ((InternalCDOPackageUnit)newPackageUnit).setState(CDOPackageUnit.State.LOADED);
                    }
                    long timeStamp = result.getTimeStamp();
                    Map<CDOID, CDOObject> dirtyObjects = this.getDirtyObjects();
                    HashSet<CDOIDAndVersion> dirtyIDs = new HashSet<CDOIDAndVersion>();
                    for (CDOObject dirtyObject : dirtyObjects.values()) {
                        CDORevision revision = dirtyObject.cdoRevision();
                        CDOIDAndVersion dirtyID = CDOIDUtil.createIDAndVersion((CDOID)revision.getID(), (int)(revision.getVersion() - 1));
                        dirtyIDs.add(dirtyID);
                    }
                    if (!dirtyIDs.isEmpty() || !this.getDetachedObjects().isEmpty()) {
                        HashSet<CDOID> detachedIDs = new HashSet<CDOID>(this.getDetachedObjects().keySet());
                        ArrayList<CDORevisionDelta> deltasCopy = new ArrayList<CDORevisionDelta>(deltas);
                        for (CDORevisionDelta dirtyObjectDelta : deltasCopy) {
                            ((InternalCDORevisionDelta)dirtyObjectDelta).adjustReferences(result.getReferenceAdjuster());
                        }
                        session.handleCommitNotification(timeStamp, this.newPackageUnits, dirtyIDs, detachedIDs, deltasCopy, this.getTransaction());
                    }
                    CDOTransactionImpl.this.lastCommitTime = timeStamp;
                    CDOTransactionHandler[] cDOTransactionHandlerArray = CDOTransactionImpl.this.getHandlers();
                    int n = cDOTransactionHandlerArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object handler = cDOTransactionHandlerArray[n2];
                        handler.committedTransaction(this.getTransaction(), this);
                        ++n2;
                    }
                    CDOTransactionImpl.this.getChangeSubscriptionManager().committedTransaction(this.getTransaction(), this);
                    CDOTransactionImpl.this.getAdapterManager().committedTransaction(this.getTransaction(), this);
                    CDOTransactionImpl.this.cleanUp();
                    Map<CDOIDTemp, CDOID> idMappings = result.getIDMappings();
                    CDOTransactionImpl.this.fireEvent(new FinishedEvent(CDOTransactionFinishedEvent.Type.COMMITTED, idMappings));
                }
                catch (RuntimeException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw new TransactionException((Throwable)ex);
                }
            } else if (CDOTransactionImpl.this.options().isAutoReleaseLocksEnabled()) {
                CDOTransactionImpl.this.unlockObjects(null, null);
            }
        }

        private void preCommit(Map objects) {
            if (!objects.isEmpty()) {
                for (Object object : objects.values()) {
                    ((InternalCDOObject)object).cdoInternalPreCommit();
                }
            }
        }

        private void postCommit(Map objects, CDOSessionProtocol.CommitTransactionResult result) {
            if (!objects.isEmpty()) {
                for (Object object : objects.values()) {
                    CDOStateMachine.INSTANCE.commit((InternalCDOObject)object, result);
                }
            }
        }
    }

    private final class ConflictEvent
    extends CDOViewImpl.Event
    implements CDOTransactionConflictEvent {
        private static final long serialVersionUID = 1L;
        private InternalCDOObject conflictingObject;
        private boolean firstConflict;

        public ConflictEvent(InternalCDOObject conflictingObject, boolean firstConflict) {
            super(CDOTransactionImpl.this);
            this.conflictingObject = conflictingObject;
            this.firstConflict = firstConflict;
        }

        public InternalCDOObject getConflictingObject() {
            return this.conflictingObject;
        }

        public boolean isFirstConflict() {
            return this.firstConflict;
        }

        public String toString() {
            return MessageFormat.format("CDOTransactionConflictEvent[source={0}, conflictingObject={1}, firstConflict={2}]", this.getSource(), this.getConflictingObject(), this.isFirstConflict());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class FinishedEvent
    extends CDOViewImpl.Event
    implements CDOTransactionFinishedEvent {
        private static final long serialVersionUID = 1L;
        private CDOTransactionFinishedEvent.Type type;
        private Map<CDOIDTemp, CDOID> idMappings;

        private FinishedEvent(CDOTransactionFinishedEvent.Type type, Map<CDOIDTemp, CDOID> idMappings) {
            super(CDOTransactionImpl.this);
            this.type = type;
            this.idMappings = idMappings;
        }

        @Override
        public CDOTransactionFinishedEvent.Type getType() {
            return this.type;
        }

        @Override
        public Map<CDOIDTemp, CDOID> getIDMappings() {
            return this.idMappings;
        }

        public String toString() {
            return MessageFormat.format("CDOTransactionFinishedEvent[source={0}, type={1}, idMappings={2}]", new Object[]{this.getSource(), this.getType(), this.idMappings == null ? 0 : this.idMappings.size()});
        }
    }

    protected final class OptionsImpl
    extends CDOViewImpl.OptionsImpl
    implements CDOTransaction.Options {
        private List<CDOConflictResolver> conflictResolvers;
        private boolean autoReleaseLocksEnabled;

        public OptionsImpl() {
            super(CDOTransactionImpl.this);
            this.conflictResolvers = new ArrayList<CDOConflictResolver>();
            this.autoReleaseLocksEnabled = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CDOConflictResolver[] getConflictResolvers() {
            List<CDOConflictResolver> list = this.conflictResolvers;
            synchronized (list) {
                return this.conflictResolvers.toArray(new CDOConflictResolver[this.conflictResolvers.size()]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setConflictResolvers(CDOConflictResolver[] resolvers) {
            List<CDOConflictResolver> list = this.conflictResolvers;
            synchronized (list) {
                for (CDOConflictResolver resolver : this.conflictResolvers) {
                    resolver.setTransaction(null);
                }
                this.conflictResolvers.clear();
                CDOConflictResolver[] cDOConflictResolverArray = resolvers;
                int n = resolvers.length;
                int n2 = 0;
                while (n2 < n) {
                    CDOConflictResolver resolver;
                    resolver = cDOConflictResolverArray[n2];
                    this.validateResolver(resolver);
                    this.conflictResolvers.add(resolver);
                    ++n2;
                }
            }
            this.fireEvent(new ConflictResolversEventImpl());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addConflictResolver(CDOConflictResolver resolver) {
            boolean changed = false;
            List<CDOConflictResolver> list = this.conflictResolvers;
            synchronized (list) {
                if (!this.conflictResolvers.contains(resolver)) {
                    this.validateResolver(resolver);
                    this.conflictResolvers.add(resolver);
                    changed = true;
                }
            }
            if (changed) {
                this.fireEvent(new ConflictResolversEventImpl());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeConflictResolver(CDOConflictResolver resolver) {
            boolean changed = false;
            List<CDOConflictResolver> list = this.conflictResolvers;
            synchronized (list) {
                changed = this.conflictResolvers.remove(resolver);
            }
            if (changed) {
                resolver.setTransaction(null);
                this.fireEvent(new ConflictResolversEventImpl());
            }
        }

        public void disposeConflictResolvers() {
            try {
                CDOConflictResolver[] cDOConflictResolverArray = CDOTransactionImpl.this.options().getConflictResolvers();
                int n = cDOConflictResolverArray.length;
                int n2 = 0;
                while (n2 < n) {
                    CDOConflictResolver resolver = cDOConflictResolverArray[n2];
                    try {
                        resolver.setTransaction(null);
                    }
                    catch (Exception exception) {}
                    ++n2;
                }
            }
            catch (Exception exception) {}
        }

        private void validateResolver(CDOConflictResolver resolver) {
            if (resolver.getTransaction() != null) {
                throw new IllegalArgumentException(Messages.getString("CDOTransactionImpl.17"));
            }
            resolver.setTransaction(CDOTransactionImpl.this);
        }

        public boolean isAutoReleaseLocksEnabled() {
            return this.autoReleaseLocksEnabled;
        }

        public void setAutoReleaseLocksEnabled(boolean on) {
            if (this.autoReleaseLocksEnabled != on) {
                this.autoReleaseLocksEnabled = on;
                this.fireEvent(new AutoReleaseLockEventImpl());
            }
        }

        private final class AutoReleaseLockEventImpl
        extends OptionsEvent
        implements CDOTransaction.Options.AutoReleaseLockEvent {
            private static final long serialVersionUID = 1L;

            public AutoReleaseLockEventImpl() {
                super((IOptions)OptionsImpl.this);
            }
        }

        private final class ConflictResolversEventImpl
        extends OptionsEvent
        implements CDOTransaction.Options.ConflictResolversEvent {
            private static final long serialVersionUID = 1L;

            public ConflictResolversEventImpl() {
                super((IOptions)OptionsImpl.this);
            }
        }
    }

    private final class ResourcesEvent
    extends CDOViewImpl.Event
    implements CDOViewResourcesEvent {
        private static final long serialVersionUID = 1L;
        private String resourcePath;
        private CDOViewResourcesEvent.Kind kind;

        public ResourcesEvent(String resourcePath, CDOViewResourcesEvent.Kind kind) {
            super(CDOTransactionImpl.this);
            this.resourcePath = resourcePath;
            this.kind = kind;
        }

        public String getResourcePath() {
            return this.resourcePath;
        }

        public CDOViewResourcesEvent.Kind getKind() {
            return this.kind;
        }

        public String toString() {
            return MessageFormat.format("CDOViewResourcesEvent[source={0}, {1}={2}]", new Object[]{this.getSource(), this.resourcePath, this.kind});
        }
    }

    private final class StartedEvent
    extends CDOViewImpl.Event
    implements CDOTransactionStartedEvent {
        private static final long serialVersionUID = 1L;

        private StartedEvent() {
            super(CDOTransactionImpl.this);
        }

        public String toString() {
            return MessageFormat.format("CDOTransactionStartedEvent[source={0}]", this.getSource());
        }
    }
}

