/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server.protocol;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDMetaRange;
import org.eclipse.emf.cdo.common.id.CDOIDObjectFactory;
import org.eclipse.emf.cdo.common.id.CDOIDProvider;
import org.eclipse.emf.cdo.common.id.CDOIDTemp;
import org.eclipse.emf.cdo.common.io.CDODataInput;
import org.eclipse.emf.cdo.common.io.CDODataOutput;
import org.eclipse.emf.cdo.common.model.CDOPackageRegistry;
import org.eclipse.emf.cdo.common.revision.CDOListFactory;
import org.eclipse.emf.cdo.common.revision.CDORevisionResolver;
import org.eclipse.emf.cdo.internal.common.io.CDODataInputImpl;
import org.eclipse.emf.cdo.internal.common.io.CDODataOutputImpl;
import org.eclipse.emf.cdo.internal.common.revision.CDOListImpl;
import org.eclipse.emf.cdo.internal.server.Repository;
import org.eclipse.emf.cdo.internal.server.Session;
import org.eclipse.emf.cdo.internal.server.Transaction;
import org.eclipse.emf.cdo.internal.server.bundle.OM;
import org.eclipse.emf.cdo.internal.server.protocol.CDOServerProtocol;
import org.eclipse.emf.cdo.server.IStore;
import org.eclipse.emf.cdo.server.IView;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionDelta;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.net4j.signal.IndicationWithMonitoring;
import org.eclipse.net4j.signal.SignalProtocol;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.ExtendedDataOutput;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;
import org.eclipse.net4j.util.io.StringIO;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.om.monitor.ProgressDistributable;
import org.eclipse.net4j.util.om.monitor.ProgressDistributor;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class CommitTransactionIndication
extends IndicationWithMonitoring {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_PROTOCOL, CommitTransactionIndication.class);
    private static final ProgressDistributable<Transaction.InternalCommitContext>[] ops = ProgressDistributor.array((ProgressDistributable[])new ProgressDistributable[]{new ProgressDistributable.Default<Transaction.InternalCommitContext>(){

        public void runLoop(int index, Transaction.InternalCommitContext commitContext, OMMonitor monitor) throws Exception {
            commitContext.write(monitor.fork());
        }
    }, new ProgressDistributable.Default<Transaction.InternalCommitContext>(){

        public void runLoop(int index, Transaction.InternalCommitContext commitContext, OMMonitor monitor) throws Exception {
            if (commitContext.getRollbackMessage() == null) {
                commitContext.commit(monitor.fork());
            } else {
                monitor.worked();
            }
        }
    }});
    protected Transaction.InternalCommitContext commitContext;

    public CommitTransactionIndication(CDOServerProtocol protocol) {
        super((SignalProtocol)protocol, (short)12);
    }

    protected CommitTransactionIndication(CDOServerProtocol protocol, short signalID) {
        super((SignalProtocol)protocol, signalID);
    }

    public CDOServerProtocol getProtocol() {
        return (CDOServerProtocol)super.getProtocol();
    }

    protected Session getSession() {
        return (Session)this.getProtocol().getSession();
    }

    protected Repository getRepository() {
        Repository repository = (Repository)this.getSession().getSessionManager().getRepository();
        if (!LifecycleUtil.isActive((Object)repository)) {
            throw new IllegalStateException("Repository has been deactivated");
        }
        return repository;
    }

    protected IStore getStore() {
        IStore store = this.getRepository().getStore();
        if (!LifecycleUtil.isActive((Object)store)) {
            throw new IllegalStateException("Store has been deactivated");
        }
        return store;
    }

    protected final void indicating(ExtendedDataInputStream in, OMMonitor monitor) throws Exception {
        this.indicating((CDODataInput)new CDODataInputImpl((ExtendedDataInput)in){

            protected CDORevisionResolver getRevisionResolver() {
                return CommitTransactionIndication.this.getRepository().getRevisionManager();
            }

            protected CDOPackageRegistry getPackageRegistry() {
                return CommitTransactionIndication.this.commitContext.getPackageRegistry();
            }

            protected StringIO getPackageURICompressor() {
                return CommitTransactionIndication.this.getProtocol().getPackageURICompressor();
            }

            protected CDOIDObjectFactory getIDFactory() {
                return CommitTransactionIndication.this.getStore().getCDOIDObjectFactory();
            }

            protected CDOListFactory getListFactory() {
                return CDOListImpl.FACTORY;
            }
        }, monitor);
    }

    protected final void responding(ExtendedDataOutputStream out, OMMonitor monitor) throws Exception {
        this.responding((CDODataOutput)new CDODataOutputImpl((ExtendedDataOutput)out){

            protected StringIO getPackageURICompressor() {
                return CommitTransactionIndication.this.getProtocol().getPackageURICompressor();
            }

            public CDOIDProvider getIDProvider() {
                return CommitTransactionIndication.this.getSession();
            }
        }, monitor);
    }

    protected void indicating(CDODataInput in, OMMonitor monitor) throws Exception {
        try {
            try {
                monitor.begin(10.0);
                this.indicatingCommit(in, monitor.fork(1.0));
                this.indicatingCommit(monitor.fork(9.0));
            }
            catch (IOException ex) {
                throw ex;
            }
            catch (Exception ex) {
                OM.LOG.error((Throwable)ex);
                throw WrappedException.wrap((Exception)ex);
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void responding(CDODataOutput out, OMMonitor monitor) throws Exception {
        boolean success = false;
        try {
            success = this.respondingException(out, this.commitContext.getRollbackMessage());
            if (success) {
                this.respondingTimestamp(out);
                this.respondingMappingNewPackages(out);
                this.respondingMappingNewObjects(out);
            }
        }
        finally {
            this.commitContext.postCommit(success);
        }
    }

    protected void indicatingTransaction(CDODataInput in) throws Exception {
        int viewID = in.readInt();
        this.commitContext = this.getTransaction(viewID).createCommitContext();
    }

    protected void indicatingCommit(CDODataInput in, OMMonitor monitor) throws Exception {
        this.indicatingTransaction(in);
        this.commitContext.preCommit();
        boolean autoReleaseLocksEnabled = in.readBoolean();
        this.commitContext.setAutoReleaseLocksEnabled(autoReleaseLocksEnabled);
        InternalCDOPackageUnit[] newPackageUnits = new InternalCDOPackageUnit[in.readInt()];
        InternalCDORevision[] newObjects = new InternalCDORevision[in.readInt()];
        InternalCDORevisionDelta[] dirtyObjectDeltas = new InternalCDORevisionDelta[in.readInt()];
        CDOID[] detachedObjects = new CDOID[in.readInt()];
        monitor.begin((double)(newPackageUnits.length + newObjects.length + dirtyObjectDeltas.length + detachedObjects.length));
        try {
            if (TRACER.isEnabled()) {
                TRACER.format("Reading {0} new package units", new Object[]{newPackageUnits.length});
            }
            InternalCDOPackageRegistry packageRegistry = this.commitContext.getPackageRegistry();
            int i = 0;
            while (i < newPackageUnits.length) {
                newPackageUnits[i] = (InternalCDOPackageUnit)in.readCDOPackageUnit((CDOPackageRegistry)packageRegistry);
                packageRegistry.putPackageUnit(newPackageUnits[i]);
                monitor.worked();
                ++i;
            }
            InternalCDOPackageUnit[] internalCDOPackageUnitArray = newPackageUnits;
            int n = newPackageUnits.length;
            int n2 = 0;
            while (n2 < n) {
                InternalCDOPackageUnit packageUnit = internalCDOPackageUnitArray[n2];
                EPackage[] ePackageArray = packageUnit.getEPackages(true);
                int n3 = ePackageArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    EPackage ePackage = ePackageArray[n4];
                    EcoreUtil.resolveAll((EObject)ePackage);
                    ++n4;
                }
                ++n2;
            }
            if (TRACER.isEnabled()) {
                TRACER.format("Reading {0} new objects", new Object[]{newObjects.length});
            }
            i = 0;
            while (i < newObjects.length) {
                newObjects[i] = (InternalCDORevision)in.readCDORevision();
                monitor.worked();
                ++i;
            }
            if (TRACER.isEnabled()) {
                TRACER.format("Reading {0} dirty object deltas", new Object[]{dirtyObjectDeltas.length});
            }
            i = 0;
            while (i < dirtyObjectDeltas.length) {
                dirtyObjectDeltas[i] = (InternalCDORevisionDelta)in.readCDORevisionDelta();
                monitor.worked();
                ++i;
            }
            i = 0;
            while (i < detachedObjects.length) {
                detachedObjects[i] = in.readCDOID();
                monitor.worked();
                ++i;
            }
            this.commitContext.setNewPackageUnits(newPackageUnits);
            this.commitContext.setNewObjects(newObjects);
            this.commitContext.setDirtyObjectDeltas(dirtyObjectDeltas);
            this.commitContext.setDetachedObjects(detachedObjects);
        }
        finally {
            monitor.done();
        }
    }

    protected void indicatingCommit(OMMonitor monitor) {
        ProgressDistributor distributor = this.getStore().getIndicatingCommitDistributor();
        distributor.run(ops, (Object)this.commitContext, monitor);
    }

    protected boolean respondingException(CDODataOutput out, String rollbackMessage) throws Exception {
        boolean success = rollbackMessage == null;
        out.writeBoolean(success);
        if (!success) {
            out.writeString(rollbackMessage);
        }
        return success;
    }

    protected void respondingTimestamp(CDODataOutput out) throws Exception {
        out.writeLong(this.commitContext.getTimeStamp());
    }

    protected void respondingMappingNewPackages(CDODataOutput out) throws Exception {
        List<CDOIDMetaRange> metaRanges = this.commitContext.getMetaIDRanges();
        for (CDOIDMetaRange metaRange : metaRanges) {
            out.writeCDOIDMetaRange(metaRange);
        }
    }

    protected void respondingMappingNewObjects(CDODataOutput out) throws Exception {
        Map<CDOIDTemp, CDOID> idMappings = this.commitContext.getIDMappings();
        for (Map.Entry<CDOIDTemp, CDOID> entry : idMappings.entrySet()) {
            CDOIDTemp oldID = entry.getKey();
            if (oldID.isMeta()) continue;
            CDOID newID = entry.getValue();
            out.writeCDOID((CDOID)oldID);
            out.writeCDOID(newID);
        }
        out.writeCDOID(CDOID.NULL);
    }

    protected Transaction getTransaction(int viewID) {
        IView view = this.getSession().getView(viewID);
        if (view instanceof Transaction) {
            return (Transaction)view;
        }
        throw new IllegalStateException("Illegal transaction: " + view);
    }
}

