/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.hibernate;

import java.util.HashMap;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.server.IStoreWriter;

public class HibernateCommitContext {
    private IStoreWriter.CommitContext commitContext;
    private HashMap<CDOID, CDORevision> dirtyObjects = null;
    private HashMap<CDOID, CDORevision> newObjects = null;

    public IStoreWriter.CommitContext getCommitContext() {
        return this.commitContext;
    }

    public void setCommitContext(IStoreWriter.CommitContext commitContext) {
        this.commitContext = commitContext;
    }

    protected void initialize() {
        CDORevision cdoRevision;
        if (this.dirtyObjects != null) {
            return;
        }
        this.dirtyObjects = new HashMap();
        CDORevision[] cDORevisionArray = this.commitContext.getDirtyObjects();
        int n = cDORevisionArray.length;
        int n2 = 0;
        while (n2 < n) {
            cdoRevision = cDORevisionArray[n2];
            this.dirtyObjects.put(cdoRevision.getID(), cdoRevision);
            ++n2;
        }
        this.newObjects = new HashMap();
        cDORevisionArray = this.commitContext.getNewObjects();
        n = cDORevisionArray.length;
        n2 = 0;
        while (n2 < n) {
            cdoRevision = cDORevisionArray[n2];
            this.newObjects.put(cdoRevision.getID(), cdoRevision);
            ++n2;
        }
    }

    public CDORevision getDirtyObject(CDOID id) {
        this.initialize();
        return this.dirtyObjects.get(id);
    }

    public CDORevision getNewObject(CDOID id) {
        this.initialize();
        return this.newObjects.get(id);
    }

    public void setNewID(CDOID oldId, CDOID newId) {
        this.initialize();
        CDORevision cdoRevision = this.dirtyObjects.get(oldId);
        if (cdoRevision != null) {
            this.dirtyObjects.remove(oldId);
            this.dirtyObjects.put(newId, cdoRevision);
            return;
        }
        cdoRevision = this.newObjects.get(oldId);
        if (cdoRevision != null) {
            this.newObjects.remove(oldId);
            this.newObjects.put(newId, cdoRevision);
            return;
        }
    }
}

