/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db.mapping.horizontal;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.revision.delta.CDOAddFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOClearFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOContainerFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDeltaVisitor;
import org.eclipse.emf.cdo.common.revision.delta.CDOListFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOMoveFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDORemoveFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOSetFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOUnsetFeatureDelta;
import org.eclipse.emf.cdo.eresource.EresourcePackage;
import org.eclipse.emf.cdo.server.db.CDODBUtil;
import org.eclipse.emf.cdo.server.db.IDBStoreAccessor;
import org.eclipse.emf.cdo.server.db.IPreparedStatementCache;
import org.eclipse.emf.cdo.server.db.mapping.IClassMapping;
import org.eclipse.emf.cdo.server.db.mapping.IClassMappingDeltaSupport;
import org.eclipse.emf.cdo.server.db.mapping.IListMappingDeltaSupport;
import org.eclipse.emf.cdo.server.db.mapping.ITypeMapping;
import org.eclipse.emf.cdo.server.internal.db.bundle.OM;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.AbstractHorizontalClassMapping;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.AbstractHorizontalMappingStrategy;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionDelta;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.util.ImplementationError;
import org.eclipse.net4j.util.collection.Pair;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HorizontalNonAuditClassMapping
extends AbstractHorizontalClassMapping
implements IClassMapping,
IClassMappingDeltaSupport {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, HorizontalNonAuditClassMapping.class);
    private String sqlSelectAllObjectIds;
    private String sqlSelectCurrentAttributes;
    private String sqlInsertAttributes;
    private String sqlDelete;
    private String sqlUpdateAffix;
    private String sqlUpdatePrexix;
    private String sqlUpdateContainerPart;
    private ThreadLocal<FeatureDeltaWriter> deltaWriter = new ThreadLocal<FeatureDeltaWriter>(){

        @Override
        protected FeatureDeltaWriter initialValue() {
            return new FeatureDeltaWriter();
        }
    };

    public HorizontalNonAuditClassMapping(AbstractHorizontalMappingStrategy mappingStrategy, EClass eClass) {
        super(mappingStrategy, eClass);
        this.initSqlStrings();
    }

    private void initSqlStrings() {
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT ");
        builder.append("cdo_version");
        builder.append(", ");
        builder.append("cdo_created");
        builder.append(", ");
        builder.append("cdo_revised");
        builder.append(", ");
        builder.append("cdo_resource");
        builder.append(", ");
        builder.append("cdo_container");
        builder.append(", ");
        builder.append("cdo_feature");
        for (ITypeMapping singleMapping : this.getValueMappings()) {
            builder.append(", ");
            builder.append(singleMapping.getField().getName());
        }
        builder.append(" FROM ");
        builder.append(this.getTable().getName());
        builder.append(" WHERE ");
        builder.append("cdo_id");
        builder.append("= ?");
        this.sqlSelectCurrentAttributes = builder.toString();
        builder = new StringBuilder();
        builder.append("INSERT INTO ");
        builder.append(this.getTable().getName());
        builder.append(" VALUES (?, ?, ");
        builder.append("?, ?, ?, ?, ?, ?");
        int i = 0;
        while (i < this.getValueMappings().size()) {
            builder.append(", ?");
            ++i;
        }
        builder.append(")");
        this.sqlInsertAttributes = builder.toString();
        builder = new StringBuilder("DELETE FROM ");
        builder.append(this.getTable().getName());
        builder.append(" WHERE ");
        builder.append("cdo_id");
        builder.append(" = ? ");
        this.sqlDelete = builder.toString();
        builder = new StringBuilder("SELECT ");
        builder.append("cdo_id");
        builder.append(" FROM ");
        builder.append(this.getTable().getName());
        this.sqlSelectAllObjectIds = builder.toString();
        builder = new StringBuilder("UPDATE ");
        builder.append(this.getTable().getName());
        builder.append(" SET ");
        builder.append("cdo_version");
        builder.append(" =? ,");
        builder.append("cdo_created");
        builder.append(" =? ");
        this.sqlUpdatePrexix = builder.toString();
        builder = new StringBuilder(", ");
        builder.append("cdo_resource");
        builder.append(" =? ,");
        builder.append("cdo_container");
        builder.append(" =? ,");
        builder.append("cdo_feature");
        builder.append(" =? ");
        this.sqlUpdateContainerPart = builder.toString();
        builder = new StringBuilder(" WHERE ");
        builder.append("cdo_id");
        builder.append(" = ? ");
        this.sqlUpdateAffix = builder.toString();
    }

    @Override
    protected void writeValues(IDBStoreAccessor accessor, InternalCDORevision revision) {
        PreparedStatement stmt = null;
        try {
            try {
                stmt = accessor.getStatementCache().getPreparedStatement(this.sqlInsertAttributes, IPreparedStatementCache.ReuseProbability.HIGH);
                int col = 1;
                stmt.setLong(col++, CDOIDUtil.getLong((CDOID)revision.getID()));
                stmt.setInt(col++, revision.getVersion());
                stmt.setLong(col++, accessor.getStore().getMetaDataManager().getMetaID((EModelElement)revision.getEClass()));
                stmt.setLong(col++, revision.getCreated());
                stmt.setLong(col++, revision.getRevised());
                stmt.setLong(col++, CDOIDUtil.getLong((CDOID)revision.getResourceID()));
                stmt.setLong(col++, CDODBUtil.getLong((CDOID)revision.getContainerID()));
                stmt.setInt(col++, revision.getContainingFeatureID());
                for (ITypeMapping mapping : this.getValueMappings()) {
                    mapping.setValueFromRevision(stmt, col++, revision);
                }
                CDODBUtil.sqlUpdate(stmt, true);
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            accessor.getStatementCache().releasePreparedStatement(stmt);
            throw throwable;
        }
        accessor.getStatementCache().releasePreparedStatement(stmt);
    }

    @Override
    public PreparedStatement createObjectIdStatement(IDBStoreAccessor accessor) {
        if (TRACER.isEnabled()) {
            TRACER.format("Created ObjectID Statement : {0}", new Object[]{this.sqlSelectAllObjectIds});
        }
        return accessor.getStatementCache().getPreparedStatement(this.sqlSelectAllObjectIds, IPreparedStatementCache.ReuseProbability.HIGH);
    }

    @Override
    public PreparedStatement createResourceQueryStatement(IDBStoreAccessor accessor, CDOID folderId, String name, boolean exactMatch, long timeStamp) {
        if (timeStamp != 0L) {
            throw new IllegalArgumentException("Non-audit store does not support explicit timeStamp in resource query");
        }
        EAttribute nameFeature = EresourcePackage.eINSTANCE.getCDOResourceNode_Name();
        ITypeMapping nameValueMapping = this.getValueMapping((EStructuralFeature)nameFeature);
        if (nameValueMapping == null) {
            throw new ImplementationError(nameFeature + " not found in ClassMapping " + this);
        }
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT ");
        builder.append("cdo_id");
        builder.append(" FROM ");
        builder.append(this.getTable().getName());
        builder.append(" WHERE ");
        builder.append("cdo_container");
        builder.append("= ? AND ");
        builder.append(nameValueMapping.getField().getName());
        if (name == null) {
            builder.append(" IS NULL");
        } else {
            builder.append(exactMatch ? " = ? " : " LIKE ? ");
        }
        PreparedStatement pstmt = null;
        try {
            int idx = 1;
            pstmt = accessor.getStatementCache().getPreparedStatement(builder.toString(), IPreparedStatementCache.ReuseProbability.MEDIUM);
            pstmt.setLong(idx++, CDOIDUtil.getLong((CDOID)folderId));
            if (name != null) {
                String queryName = exactMatch ? name : String.valueOf(name) + "%";
                nameValueMapping.setValue(pstmt, idx++, queryName);
            }
            if (TRACER.isEnabled()) {
                TRACER.format("Created Resource Query: {0}", new Object[]{pstmt.toString()});
            }
            return pstmt;
        }
        catch (SQLException ex) {
            accessor.getStatementCache().releasePreparedStatement(pstmt);
            throw new DBException((Throwable)ex);
        }
    }

    @Override
    public boolean readRevision(IDBStoreAccessor accessor, InternalCDORevision revision, int listChunk) {
        PreparedStatement pstmt = null;
        try {
            pstmt = accessor.getStatementCache().getPreparedStatement(this.sqlSelectCurrentAttributes, IPreparedStatementCache.ReuseProbability.HIGH);
            pstmt.setLong(1, CDOIDUtil.getLong((CDOID)revision.getID()));
            boolean success = this.readValuesFromStatement(pstmt, revision);
            if (success) {
                this.readLists(accessor, revision, listChunk);
            }
            boolean bl = success;
            accessor.getStatementCache().releasePreparedStatement(pstmt);
            return bl;
        }
        catch (SQLException ex) {
            try {
                throw new DBException((Throwable)ex);
            }
            catch (Throwable throwable) {
                accessor.getStatementCache().releasePreparedStatement(pstmt);
                throw throwable;
            }
        }
    }

    @Override
    protected void reviseObject(IDBStoreAccessor accessor, CDOID id, long revised) {
        PreparedStatement stmt = null;
        try {
            try {
                stmt = accessor.getStatementCache().getPreparedStatement(this.sqlDelete, IPreparedStatementCache.ReuseProbability.HIGH);
                stmt.setLong(1, CDOIDUtil.getLong((CDOID)id));
                CDODBUtil.sqlUpdate(stmt, true);
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            accessor.getStatementCache().releasePreparedStatement(stmt);
            throw throwable;
        }
        accessor.getStatementCache().releasePreparedStatement(stmt);
    }

    @Override
    public void writeRevisionDelta(IDBStoreAccessor accessor, InternalCDORevisionDelta delta, long created, OMMonitor monitor) {
        monitor.begin();
        OMMonitor.Async async = monitor.forkAsync();
        try {
            FeatureDeltaWriter writer = this.deltaWriter.get();
            writer.process(accessor, (CDORevisionDelta)delta, created);
        }
        finally {
            async.stop();
            monitor.done();
        }
    }

    public void updateAttributes(IDBStoreAccessor accessor, CDOID id, int newVersion, long created, CDOID newContainerId, int newContainingFeatureId, CDOID newResourceId, List<Pair<ITypeMapping, Object>> attributeChanges) {
        PreparedStatement stmt = null;
        try {
            try {
                stmt = accessor.getStatementCache().getPreparedStatement(this.buildUpdateStatement(attributeChanges, true), IPreparedStatementCache.ReuseProbability.MEDIUM);
                int col = 1;
                stmt.setInt(col++, newVersion);
                stmt.setLong(col++, created);
                stmt.setLong(col++, CDODBUtil.getLong(newResourceId));
                stmt.setLong(col++, CDODBUtil.getLong(newContainerId));
                stmt.setInt(col++, newContainingFeatureId);
                for (Pair<ITypeMapping, Object> change : attributeChanges) {
                    ((ITypeMapping)change.getElement1()).setValue(stmt, col++, change.getElement2());
                }
                stmt.setLong(col++, CDOIDUtil.getLong((CDOID)id));
                CDODBUtil.sqlUpdate(stmt, true);
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            accessor.getStatementCache().releasePreparedStatement(stmt);
            throw throwable;
        }
        accessor.getStatementCache().releasePreparedStatement(stmt);
    }

    public void updateAttributes(IDBStoreAccessor accessor, CDOID id, int newVersion, long created, List<Pair<ITypeMapping, Object>> attributeChanges) {
        PreparedStatement stmt = null;
        try {
            try {
                stmt = accessor.getStatementCache().getPreparedStatement(this.buildUpdateStatement(attributeChanges, false), IPreparedStatementCache.ReuseProbability.MEDIUM);
                int col = 1;
                stmt.setInt(col++, newVersion);
                stmt.setLong(col++, created);
                for (Pair<ITypeMapping, Object> change : attributeChanges) {
                    ((ITypeMapping)change.getElement1()).setValue(stmt, col++, change.getElement2());
                }
                stmt.setLong(col++, CDOIDUtil.getLong((CDOID)id));
                CDODBUtil.sqlUpdate(stmt, true);
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            accessor.getStatementCache().releasePreparedStatement(stmt);
            throw throwable;
        }
        accessor.getStatementCache().releasePreparedStatement(stmt);
    }

    private String buildUpdateStatement(List<Pair<ITypeMapping, Object>> attributeChanges, boolean withContainment) {
        StringBuilder builder = new StringBuilder(this.sqlUpdatePrexix);
        if (withContainment) {
            builder.append(this.sqlUpdateContainerPart);
        }
        for (Pair<ITypeMapping, Object> change : attributeChanges) {
            builder.append(", ");
            builder.append(((ITypeMapping)change.getElement1()).getField().getName());
            builder.append(" =? ");
        }
        builder.append(this.sqlUpdateAffix);
        return builder.toString();
    }

    private class FeatureDeltaWriter
    implements CDOFeatureDeltaVisitor {
        private CDOID id;
        private int oldVersion;
        private int newVersion;
        private long created;
        private IDBStoreAccessor accessor;
        private boolean updateContainer = false;
        private List<Pair<ITypeMapping, Object>> attributeChanges = new ArrayList<Pair<ITypeMapping, Object>>();
        private int newContainingFeatureID;
        private CDOID newContainerID;
        private CDOID newResourceID;

        protected void reset() {
            this.attributeChanges.clear();
            this.updateContainer = false;
        }

        public void process(IDBStoreAccessor a, CDORevisionDelta d, long c) {
            this.reset();
            this.id = d.getID();
            this.oldVersion = d.getOriginVersion();
            this.newVersion = d.getDirtyVersion();
            this.created = c;
            this.accessor = a;
            d.accept((CDOFeatureDeltaVisitor)this);
            if (this.updateContainer) {
                HorizontalNonAuditClassMapping.this.updateAttributes(this.accessor, this.id, this.newVersion, this.created, this.newContainerID, this.newContainingFeatureID, this.newResourceID, this.attributeChanges);
            } else {
                HorizontalNonAuditClassMapping.this.updateAttributes(this.accessor, this.id, this.newVersion, this.created, this.attributeChanges);
            }
        }

        public void visit(CDOMoveFeatureDelta delta) {
            throw new ImplementationError("Should not be called");
        }

        public void visit(CDOSetFeatureDelta delta) {
            if (delta.getFeature().isMany()) {
                throw new ImplementationError("Should not be called");
            }
            ITypeMapping am = HorizontalNonAuditClassMapping.this.getValueMapping(delta.getFeature());
            if (am == null) {
                throw new IllegalArgumentException("AttributeMapping for " + delta.getFeature() + " is null!");
            }
            this.attributeChanges.add((Pair<ITypeMapping, Object>)new Pair((Object)am, delta.getValue()));
        }

        public void visit(CDOUnsetFeatureDelta delta) {
            ITypeMapping tm = HorizontalNonAuditClassMapping.this.getValueMapping(delta.getFeature());
            this.attributeChanges.add((Pair<ITypeMapping, Object>)new Pair((Object)tm, null));
        }

        public void visit(CDOListFeatureDelta delta) {
            IListMappingDeltaSupport listMapping = (IListMappingDeltaSupport)((Object)HorizontalNonAuditClassMapping.this.getListMapping(delta.getFeature()));
            listMapping.processDelta(this.accessor, this.id, this.oldVersion, this.newVersion, this.created, delta);
        }

        public void visit(CDOClearFeatureDelta delta) {
            throw new ImplementationError("Should not be called");
        }

        public void visit(CDOAddFeatureDelta delta) {
            throw new ImplementationError("Should not be called");
        }

        public void visit(CDORemoveFeatureDelta delta) {
            throw new ImplementationError("Should not be called");
        }

        public void visit(CDOContainerFeatureDelta delta) {
            this.newContainingFeatureID = delta.getContainerFeatureID();
            this.newContainerID = (CDOID)delta.getContainerID();
            this.newResourceID = delta.getResourceID();
            this.updateContainer = true;
        }
    }
}

