/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db.mapping;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.model.CDOClassifierRef;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.model.CDOType;
import org.eclipse.emf.cdo.common.model.EMFUtil;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.db.IDBStore;
import org.eclipse.emf.cdo.server.db.IDBStoreAccessor;
import org.eclipse.emf.cdo.server.db.IMetaDataManager;
import org.eclipse.emf.cdo.server.db.mapping.IClassMapping;
import org.eclipse.emf.cdo.server.db.mapping.IListMapping;
import org.eclipse.emf.cdo.server.db.mapping.IMappingStrategy;
import org.eclipse.emf.cdo.server.db.mapping.ITypeMapping;
import org.eclipse.emf.cdo.server.internal.db.ObjectIDIterator;
import org.eclipse.emf.cdo.server.internal.db.mapping.TypeMapping;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageInfo;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBAdapter;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.util.ImplementationError;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.collection.CloseableIterator;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.om.monitor.OMMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMappingStrategy
extends Lifecycle
implements IMappingStrategy {
    protected static final String NAME_SEPARATOR = "_";
    protected static final String TYPE_PREFIX_FEATURE = "F";
    protected static final String TYPE_PREFIX_CLASS = "C";
    protected static final String TYPE_PREFIX_PACKAGE = "P";
    protected static final String FEATEURE_TABLE_SUFFIX = "_list";
    private IDBStore store;
    private Map<String, String> properties;
    private Map<EClass, IClassMapping> classMappings = new HashMap<EClass, IClassMapping>();

    public synchronized Map<String, String> getProperties() {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        return this.properties;
    }

    @Override
    public synchronized void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    private int getMaxTableNameLength() {
        String value = this.getProperties().get("maxTableNameLength");
        return value == null ? this.store.getDBAdapter().getMaxTableNameLength() : Integer.valueOf(value).intValue();
    }

    private int getMaxFieldNameLength() {
        String value = this.getProperties().get("maxFieldNameLength");
        return value == null ? this.store.getDBAdapter().getMaxFieldNameLength() : Integer.valueOf(value).intValue();
    }

    private boolean isQualifiedNames() {
        String value = this.getProperties().get("qualifiedNames");
        return value == null ? false : Boolean.valueOf(value);
    }

    private boolean isForceNamesWithID() {
        String value = this.getProperties().get("forceNamesWithID");
        return value == null ? false : Boolean.valueOf(value);
    }

    private String getTableNamePrefix() {
        String value = this.getProperties().get("tableNamePrefix");
        return StringUtil.safe((String)value);
    }

    @Override
    public final IDBStore getStore() {
        return this.store;
    }

    @Override
    public final void setStore(IDBStore dbStore) {
        this.checkInactive();
        this.store = dbStore;
    }

    protected final IMetaDataManager getMetaDataManager() {
        return this.getStore().getMetaDataManager();
    }

    @Override
    public abstract boolean hasAuditSupport();

    @Override
    public abstract boolean hasDeltaSupport();

    @Override
    public CloseableIterator<CDOID> readObjectIDs(IDBStoreAccessor dbStoreAccessor) {
        Collection<EClass> classes = this.getClassesWithObjectInfo();
        final Iterator<EClass> classIt = classes.iterator();
        return new ObjectIDIterator(this, dbStoreAccessor){
            private PreparedStatement currentStatement;
            {
                super($anonymous0, $anonymous1);
                this.currentStatement = null;
            }

            protected ResultSet getNextResultSet() {
                if (classIt.hasNext()) {
                    EClass eClass = (EClass)classIt.next();
                    IClassMapping mapping = AbstractMappingStrategy.this.getClassMapping(eClass);
                    this.currentStatement = mapping.createObjectIdStatement(this.getAccessor());
                    ResultSet rset = null;
                    try {
                        rset = this.currentStatement.executeQuery();
                        return rset;
                    }
                    catch (SQLException ex) {
                        DBUtil.close((ResultSet)rset);
                        this.getAccessor().getStatementCache().releasePreparedStatement(this.currentStatement);
                        throw new DBException((Throwable)ex);
                    }
                }
                return null;
            }

            protected void closeCurrentResultSet() {
                super.closeCurrentResultSet();
                this.getAccessor().getStatementCache().releasePreparedStatement(this.currentStatement);
                this.currentStatement = null;
            }
        };
    }

    @Override
    public abstract CDOClassifierRef readObjectType(IDBStoreAccessor var1, CDOID var2);

    @Override
    public abstract long repairAfterCrash(IDBAdapter var1, Connection var2);

    protected abstract Collection<EClass> getClassesWithObjectInfo();

    @Override
    public abstract void queryResources(IDBStoreAccessor var1, IStoreAccessor.QueryResourcesContext var2);

    @Override
    public String getTableName(ENamedElement element) {
        String name = null;
        String typePrefix = null;
        if (element instanceof EClass) {
            name = this.isQualifiedNames() ? EMFUtil.getQualifiedName((EClassifier)((EClass)element), (String)NAME_SEPARATOR) : element.getName();
            typePrefix = TYPE_PREFIX_CLASS;
        } else if (element instanceof EPackage) {
            name = this.isQualifiedNames() ? EMFUtil.getQualifiedName((EPackage)((EPackage)element), (String)NAME_SEPARATOR) : element.getName();
            typePrefix = TYPE_PREFIX_PACKAGE;
        } else {
            throw new ImplementationError("Unknown element: " + element);
        }
        String prefix = this.getTableNamePrefix();
        if (prefix.length() != 0 && !prefix.endsWith(NAME_SEPARATOR)) {
            prefix = String.valueOf(prefix) + NAME_SEPARATOR;
        }
        return this.getName(String.valueOf(prefix) + name, String.valueOf(typePrefix) + this.getMetaDataManager().getMetaID((EModelElement)element), this.getMaxTableNameLength());
    }

    @Override
    public String getTableName(EClass eClass, EStructuralFeature feature) {
        String name = this.isQualifiedNames() ? EMFUtil.getQualifiedName((EClassifier)eClass, (String)NAME_SEPARATOR) : eClass.getName();
        name = String.valueOf(name) + NAME_SEPARATOR;
        name = String.valueOf(name) + feature.getName();
        name = String.valueOf(name) + FEATEURE_TABLE_SUFFIX;
        String prefix = this.getTableNamePrefix();
        if (prefix.length() != 0 && !prefix.endsWith(NAME_SEPARATOR)) {
            prefix = String.valueOf(prefix) + NAME_SEPARATOR;
        }
        return this.getName(String.valueOf(prefix) + name, TYPE_PREFIX_FEATURE + this.getMetaDataManager().getMetaID((EModelElement)feature), this.getMaxTableNameLength());
    }

    @Override
    public String getFieldName(EStructuralFeature feature) {
        return this.getName(feature.getName(), TYPE_PREFIX_FEATURE + this.getMetaDataManager().getMetaID((EModelElement)feature), this.getMaxFieldNameLength());
    }

    private String getName(String name, String suffix, int maxLength) {
        boolean forceNamesWithID = this.isForceNamesWithID();
        if (this.store.getDBAdapter().isReservedWord(name)) {
            forceNamesWithID = true;
        }
        if (name.length() > maxLength || forceNamesWithID) {
            suffix = NAME_SEPARATOR + suffix.replace('-', 'S');
            int length = Math.min(name.length(), maxLength - suffix.length());
            name = String.valueOf(name.substring(0, length)) + suffix;
        }
        return name;
    }

    @Override
    public void createMapping(Connection connection, InternalCDOPackageUnit[] packageUnits, OMMonitor monitor) {
        monitor.begin();
        OMMonitor.Async async = monitor.forkAsync();
        try {
            this.mapPackageUnits(packageUnits);
            this.getStore().getDBAdapter().createTables(this.getModelTables(), connection);
        }
        finally {
            async.stop();
            monitor.done();
        }
    }

    private void mapPackageInfos(InternalCDOPackageInfo[] packageInfos) {
        InternalCDOPackageInfo[] internalCDOPackageInfoArray = packageInfos;
        int n = packageInfos.length;
        int n2 = 0;
        while (n2 < n) {
            InternalCDOPackageInfo packageInfo = internalCDOPackageInfoArray[n2];
            EPackage ePackage = packageInfo.getEPackage();
            if (!CDOModelUtil.isCorePackage((EPackage)ePackage)) {
                this.mapClasses(EMFUtil.getPersistentClasses((EPackage)ePackage));
            }
            ++n2;
        }
    }

    private void mapClasses(EClass ... eClasses) {
        EClass[] eClassArray = eClasses;
        int n = eClasses.length;
        int n2 = 0;
        while (n2 < n) {
            EClass eClass = eClassArray[n2];
            if (!eClass.isInterface() && !eClass.isAbstract()) {
                this.createClassMapping(eClass);
            }
            ++n2;
        }
    }

    private void mapPackageUnits(InternalCDOPackageUnit[] packageUnits) {
        if (packageUnits != null && packageUnits.length != 0) {
            InternalCDOPackageUnit[] internalCDOPackageUnitArray = packageUnits;
            int n = packageUnits.length;
            int n2 = 0;
            while (n2 < n) {
                InternalCDOPackageUnit packageUnit = internalCDOPackageUnitArray[n2];
                this.mapPackageInfos(packageUnit.getPackageInfos());
                ++n2;
            }
        }
    }

    private Set<IDBTable> getModelTables() {
        HashSet<IDBTable> tables = new HashSet<IDBTable>();
        for (IClassMapping mapping : this.classMappings.values()) {
            tables.addAll(mapping.getDBTables());
        }
        return tables;
    }

    private IClassMapping createClassMapping(EClass eClass) {
        IClassMapping mapping = this.doCreateClassMapping(eClass);
        if (mapping != null) {
            this.classMappings.put(eClass, mapping);
        }
        return mapping;
    }

    protected abstract IClassMapping doCreateClassMapping(EClass var1);

    public final Map<EClass, IClassMapping> getClassMappings() {
        return this.classMappings;
    }

    @Override
    public final IClassMapping getClassMapping(EClass eClass) {
        IClassMapping result = this.classMappings.get(eClass);
        if (result != null) {
            return result;
        }
        return this.createClassMapping(eClass);
    }

    @Override
    public ITypeMapping createValueMapping(EStructuralFeature feature) {
        CDOType type = CDOModelUtil.getType((EStructuralFeature)feature);
        if (type == CDOType.BOOLEAN || type == CDOType.BOOLEAN_OBJECT) {
            return new TypeMapping.TMBoolean(this, feature);
        }
        if (type == CDOType.BYTE || type == CDOType.BYTE_OBJECT) {
            return new TypeMapping.TMByte(this, feature);
        }
        if (type == CDOType.CHAR || type == CDOType.CHARACTER_OBJECT) {
            return new TypeMapping.TMCharacter(this, feature);
        }
        if (type == CDOType.DATE) {
            return new TypeMapping.TMDate(this, feature);
        }
        if (type == CDOType.DOUBLE || type == CDOType.DOUBLE_OBJECT) {
            return new TypeMapping.TMDouble(this, feature);
        }
        if (type == CDOType.FLOAT || type == CDOType.FLOAT_OBJECT) {
            return new TypeMapping.TMFloat(this, feature);
        }
        if (type == CDOType.INT || type == CDOType.INTEGER_OBJECT) {
            return new TypeMapping.TMInteger(this, feature);
        }
        if (type == CDOType.LONG || type == CDOType.LONG_OBJECT) {
            return new TypeMapping.TMLong(this, feature);
        }
        if (type == CDOType.OBJECT) {
            return new TypeMapping.TMObject(this, feature);
        }
        if (type == CDOType.SHORT || type == CDOType.SHORT_OBJECT) {
            return new TypeMapping.TMShort(this, feature);
        }
        if (type == CDOType.ENUM) {
            return new TypeMapping.TMEnum(this, feature);
        }
        if (type == CDOType.STRING || type == CDOType.CUSTOM) {
            return new TypeMapping.TMString(this, feature);
        }
        if (type == CDOType.BIG_INTEGER) {
            return new TypeMapping.TMBigInteger(this, feature);
        }
        if (type == CDOType.BIG_DECIMAL) {
            return new TypeMapping.TMBigDecimal(this, feature);
        }
        if (type == CDOType.BYTE_ARRAY) {
            return new TypeMapping.TMBytes(this, feature);
        }
        throw new ImplementationError("Unrecognized CDOType: " + type);
    }

    @Override
    public final IListMapping createListMapping(EClass containingClass, EStructuralFeature feature) {
        this.checkArg(feature.isMany(), "Only many-valued features allowed.");
        IListMapping mapping = this.doCreateListMapping(containingClass, feature);
        return mapping;
    }

    public abstract IListMapping doCreateListMapping(EClass var1, EStructuralFeature var2);
}

