/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.revision;

import java.text.MessageFormat;
import org.eclipse.emf.cdo.internal.common.revision.DLRevisionHolder;
import org.eclipse.emf.cdo.internal.common.revision.DLRevisionList;
import org.eclipse.emf.cdo.internal.common.revision.LRURevisionHolder;

public class LRURevisionList
extends DLRevisionList {
    private int capacity;

    public LRURevisionList(int capacity) {
        this.capacity = capacity;
    }

    public int capacity() {
        return this.capacity;
    }

    public synchronized void capacity(int capacity) {
        this.capacity = capacity;
        this.eviction();
    }

    public synchronized void add(DLRevisionHolder holder) {
        this.addHead(holder);
        this.eviction();
    }

    public String toString() {
        return MessageFormat.format("LRURevisionList[size={0}, capacity={1}]", this.size(), this.capacity);
    }

    protected void eviction() {
        if (this.capacity != 0) {
            while (this.size() > this.capacity) {
                this.evict((LRURevisionHolder)this.getDLTail());
            }
        }
    }

    protected void evict(LRURevisionHolder holder) {
        this.remove(holder);
    }
}

