/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.util.om.pref;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.net4j.internal.util.bundle.AbstractBundle;
import org.eclipse.net4j.internal.util.om.pref.ArrayPreference;
import org.eclipse.net4j.internal.util.om.pref.BooleanPreference;
import org.eclipse.net4j.internal.util.om.pref.BytesPreference;
import org.eclipse.net4j.internal.util.om.pref.DoublePreference;
import org.eclipse.net4j.internal.util.om.pref.FloatPreference;
import org.eclipse.net4j.internal.util.om.pref.IntegerPreference;
import org.eclipse.net4j.internal.util.om.pref.LongPreference;
import org.eclipse.net4j.internal.util.om.pref.Preference;
import org.eclipse.net4j.internal.util.om.pref.PreferencesChangeEvent;
import org.eclipse.net4j.internal.util.om.pref.StringPreference;
import org.eclipse.net4j.util.event.Notifier;
import org.eclipse.net4j.util.io.IORunnable;
import org.eclipse.net4j.util.io.IORuntimeException;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.om.pref.OMPreference;
import org.eclipse.net4j.util.om.pref.OMPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Preferences
extends Notifier
implements OMPreferences {
    private AbstractBundle bundle;
    private Map<String, Preference<?>> prefs = new HashMap();
    private boolean loaded;
    private boolean dirty;

    public Preferences(AbstractBundle bundle) {
        this.bundle = bundle;
    }

    @Override
    public AbstractBundle getBundle() {
        return this.bundle;
    }

    public synchronized void load() {
        if (!this.loaded) {
            this.loaded = true;
            final Properties properties = new Properties();
            File file = this.getFile();
            if (file.exists()) {
                IOUtil.safeInput(file, new IORunnable<FileInputStream>(){

                    @Override
                    public void run(FileInputStream io) throws IOException {
                        properties.load(io);
                    }
                });
            }
            for (Preference<?> preference : this.prefs.values()) {
                String name = preference.getName();
                String value = properties.getProperty(name);
                preference.init(value);
            }
        }
    }

    @Override
    public synchronized void save() {
        if (this.dirty) {
            final Properties properties = new Properties();
            for (Preference<?> preference : this.prefs.values()) {
                if (!preference.isSet()) continue;
                String name = preference.getName();
                String value = preference.getString();
                if (value == null) continue;
                properties.put(name, value);
            }
            File file = this.getFile();
            if (properties.isEmpty()) {
                if (file.exists()) {
                    file.delete();
                }
            } else {
                IOUtil.safeOutput(file, new IORunnable<FileOutputStream>(){

                    @Override
                    public void run(FileOutputStream io) throws IOException {
                        properties.store(io, "Preferences of " + Preferences.this.bundle.getBundleID());
                    }
                });
            }
            this.dirty = false;
        }
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public OMPreference<Boolean> init(String name, boolean defaultValue) {
        return this.init(new BooleanPreference(this, name, defaultValue));
    }

    @Override
    public OMPreference<Integer> init(String name, int defaultValue) {
        return this.init(new IntegerPreference(this, name, defaultValue));
    }

    @Override
    public OMPreference<Long> init(String name, long defaultValue) {
        return this.init(new LongPreference(this, name, defaultValue));
    }

    @Override
    public OMPreference<Float> init(String name, float defaultValue) {
        return this.init(new FloatPreference(this, name, Float.valueOf(defaultValue)));
    }

    @Override
    public OMPreference<Double> init(String name, double defaultValue) {
        return this.init(new DoublePreference(this, name, defaultValue));
    }

    @Override
    public OMPreference<String> init(String name, String defaultValue) {
        return this.init(new StringPreference(this, name, defaultValue));
    }

    @Override
    public OMPreference<String[]> init(String name, String[] defaultValue) {
        return this.init(new ArrayPreference(this, name, defaultValue));
    }

    @Override
    public OMPreference<byte[]> init(String name, byte[] defaultValue) {
        return this.init(new BytesPreference(this, name, defaultValue));
    }

    @Override
    public OMPreference<Boolean> initBoolean(String name) {
        return this.init(name, false);
    }

    @Override
    public OMPreference<Integer> initInteger(String name) {
        return this.init(name, 0);
    }

    @Override
    public OMPreference<Long> initLong(String name) {
        return this.init(name, 0L);
    }

    @Override
    public OMPreference<Float> initFloat(String name) {
        return this.init(name, 0.0f);
    }

    @Override
    public OMPreference<Double> initDouble(String name) {
        return this.init(name, 0.0);
    }

    @Override
    public OMPreference<String> initString(String name) {
        return this.init(name, "");
    }

    @Override
    public OMPreference<String[]> initArray(String name) {
        return this.init(name, DEFAULT_ARRAY);
    }

    @Override
    public OMPreference<byte[]> initBytes(String name) {
        return this.init(name, DEFAULT_BYTES);
    }

    @Override
    public boolean contains(String name) {
        return this.prefs.containsKey(name);
    }

    @Override
    public OMPreference<?> get(String name) {
        return this.prefs.get(name);
    }

    @Override
    public OMPreference<Boolean> getBoolean(String name) {
        return this.get(name);
    }

    @Override
    public OMPreference<Integer> getInteger(String name) {
        return this.get(name);
    }

    @Override
    public OMPreference<Long> getLong(String name) {
        return this.get(name);
    }

    @Override
    public OMPreference<Float> getFloat(String name) {
        return this.get(name);
    }

    @Override
    public OMPreference<Double> getDouble(String name) {
        return this.get(name);
    }

    @Override
    public OMPreference<String> getString(String name) {
        return this.get(name);
    }

    @Override
    public OMPreference<String[]> getArray(String name) {
        return this.get(name);
    }

    @Override
    public OMPreference<byte[]> getBytes(String name) {
        return this.get(name);
    }

    public <T> void fireChangeEvent(Preference<T> preference, T oldValue, T newValue) {
        this.dirty = true;
        this.fireEvent(new PreferencesChangeEvent<T>(preference, oldValue, newValue));
    }

    private <T> OMPreference<T> init(Preference<T> preference) {
        String name = preference.getName();
        if (this.prefs.containsKey(name)) {
            throw new IllegalArgumentException("Duplicate name: " + name);
        }
        this.prefs.put(name, preference);
        return preference;
    }

    private File getFile() {
        File file = new File(this.bundle.getStateLocation(), ".prefs");
        if (file.exists() && !file.isFile()) {
            throw new IORuntimeException("Not a file: " + file.getAbsolutePath());
        }
        return file;
    }
}

