/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.container;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.net4j.internal.util.bundle.OM;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.container.ContainerEvent;
import org.eclipse.net4j.util.container.FactoryNotFoundException;
import org.eclipse.net4j.util.container.IContainerDelta;
import org.eclipse.net4j.util.container.IContainerEvent;
import org.eclipse.net4j.util.container.IElementProcessor;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.SingleDeltaContainerEvent;
import org.eclipse.net4j.util.event.EventUtil;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.factory.FactoryKey;
import org.eclipse.net4j.util.factory.IFactory;
import org.eclipse.net4j.util.factory.IFactoryKey;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleEventAdapter;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.registry.HashMapRegistry;
import org.eclipse.net4j.util.registry.IRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedContainer
extends Lifecycle
implements IManagedContainer {
    private IRegistry<IFactoryKey, IFactory> factoryRegistry;
    private List<IElementProcessor> postProcessors;
    private IRegistry<ElementKey, Object> elementRegistry = new HashMapRegistry<ElementKey, Object>();
    private long maxElementID;
    private IListener elementListener = new LifecycleEventAdapter(){

        protected void onDeactivated(ILifecycle lifecycle) {
            for (Map.Entry entry : ManagedContainer.this.elementRegistry.entrySet()) {
                if (lifecycle != entry.getValue()) continue;
                ManagedContainer.this.removeElement((ElementKey)entry.getKey());
                return;
            }
        }
    };

    @Override
    public synchronized IRegistry<IFactoryKey, IFactory> getFactoryRegistry() {
        if (this.factoryRegistry == null) {
            this.factoryRegistry = this.createFactoryRegistry();
        }
        return this.factoryRegistry;
    }

    @Override
    public ManagedContainer registerFactory(IFactory factory) {
        this.getFactoryRegistry().put(factory.getKey(), factory);
        return this;
    }

    @Override
    public synchronized List<IElementProcessor> getPostProcessors() {
        if (this.postProcessors == null) {
            this.postProcessors = this.createPostProcessors();
        }
        return this.postProcessors;
    }

    @Override
    public synchronized void addPostProcessor(IElementProcessor postProcessor, boolean processExistingElements) {
        if (processExistingElements) {
            ContainerEvent<Object> event = new ContainerEvent<Object>(this);
            for (Map.Entry entry : this.elementRegistry.entrySet()) {
                String description;
                String factoryType;
                ElementKey key = (ElementKey)entry.getKey();
                Object element = entry.getValue();
                String productGroup = key.getProductGroup();
                Object newElement = postProcessor.process(this, productGroup, factoryType = key.getFactoryType(), description = key.getDescription(), element);
                if (newElement == element) continue;
                this.elementRegistry.put(key, newElement);
                event.addDelta(element, IContainerDelta.Kind.REMOVED);
                event.addDelta(newElement, IContainerDelta.Kind.ADDED);
            }
            this.fireEvent(event);
        }
        this.getPostProcessors().add(postProcessor);
    }

    @Override
    public void addPostProcessor(IElementProcessor postProcessor) {
        this.getPostProcessors().add(postProcessor);
    }

    @Override
    public void removePostProcessor(IElementProcessor postProcessor) {
        this.getPostProcessors().remove(postProcessor);
    }

    @Override
    public Set<String> getProductGroups() {
        HashSet<String> result = new HashSet<String>();
        for (Object key : this.factoryRegistry.keySet()) {
            result.add(key.getProductGroup());
        }
        for (Object key : this.elementRegistry.keySet()) {
            result.add(((ElementKey)key).getProductGroup());
        }
        return result;
    }

    @Override
    public Set<String> getFactoryTypes(String productGroup) {
        HashSet<String> result = new HashSet<String>();
        for (Object key : this.factoryRegistry.keySet()) {
            if (!ObjectUtil.equals(key.getProductGroup(), productGroup)) continue;
            result.add(key.getType());
        }
        for (Object key : this.elementRegistry.keySet()) {
            if (!ObjectUtil.equals(((ElementKey)key).getProductGroup(), productGroup)) continue;
            result.add(((ElementKey)key).getFactoryType());
        }
        return result;
    }

    @Override
    public IFactory getFactory(String productGroup, String factoryType) {
        FactoryKey key = new FactoryKey(productGroup, factoryType);
        IFactory factory = (IFactory)this.getFactoryRegistry().get(key);
        if (factory == null) {
            throw new FactoryNotFoundException("Factory not found: " + key);
        }
        return factory;
    }

    @Override
    public boolean isEmpty() {
        return this.elementRegistry.isEmpty();
    }

    @Override
    public String[] getElementKey(Object element) {
        for (Map.Entry entry : this.elementRegistry.entrySet()) {
            if (entry.getValue() != element) continue;
            ElementKey key = (ElementKey)entry.getKey();
            String[] result = new String[]{key.getProductGroup(), key.getFactoryType(), key.getDescription()};
            return result;
        }
        return null;
    }

    @Override
    public Object[] getElements() {
        return this.elementRegistry.values().toArray();
    }

    @Override
    public Object[] getElements(String productGroup) {
        ArrayList result = new ArrayList();
        for (Map.Entry entry : this.elementRegistry.entrySet()) {
            ElementKey key = (ElementKey)entry.getKey();
            if (!ObjectUtil.equals(key.getProductGroup(), productGroup)) continue;
            result.add(entry.getValue());
        }
        return result.toArray();
    }

    @Override
    public Object[] getElements(String productGroup, String factoryType) {
        ArrayList result = new ArrayList();
        for (Map.Entry entry : this.elementRegistry.entrySet()) {
            ElementKey key = (ElementKey)entry.getKey();
            if (!ObjectUtil.equals(key.getProductGroup(), productGroup) || !ObjectUtil.equals(key.getFactoryType(), factoryType)) continue;
            result.add(entry.getValue());
        }
        return result.toArray();
    }

    @Override
    public Object getElement(String productGroup, String factoryType, String description) {
        ElementKey key = new ElementKey(productGroup, factoryType, description);
        Object element = this.elementRegistry.get(key);
        if (element == null) {
            element = this.createElement(productGroup, factoryType, description);
            element = this.postProcessElement(productGroup, factoryType, description, element);
            LifecycleUtil.activate(element);
            this.putElement(key, element);
        }
        return element;
    }

    @Override
    public Object putElement(String productGroup, String factoryType, String description, Object element) {
        ElementKey key = new ElementKey(productGroup, factoryType, description);
        return this.putElement(key, element);
    }

    protected Object putElement(ElementKey key, Object element) {
        ContainerEvent<Object> event = new ContainerEvent<Object>(this);
        key.setID(++this.maxElementID);
        Object oldElement = this.elementRegistry.put(key, element);
        if (oldElement != null) {
            EventUtil.removeListener(oldElement, this.elementListener);
            event.addDelta(oldElement, IContainerDelta.Kind.REMOVED);
        }
        event.addDelta(element, IContainerDelta.Kind.ADDED);
        this.fireEvent(event);
        EventUtil.addListener(element, this.elementListener);
        return oldElement;
    }

    @Override
    public Object removeElement(String productGroup, String factoryType, String description) {
        ElementKey key = new ElementKey(productGroup, factoryType, description);
        return this.removeElement(key);
    }

    protected Object removeElement(ElementKey key) {
        Object element = this.elementRegistry.remove(key);
        if (element != null) {
            EventUtil.removeListener(element, this.elementListener);
            this.fireEvent(new SingleDeltaContainerEvent<Object>(this, element, IContainerDelta.Kind.REMOVED));
        }
        return element;
    }

    @Override
    public void clearElements() {
        if (!this.elementRegistry.isEmpty()) {
            ContainerEvent<Object> event = new ContainerEvent<Object>(this);
            for (Object element : this.elementRegistry.values()) {
                EventUtil.removeListener(element, this.elementListener);
                event.addDelta(element, IContainerDelta.Kind.REMOVED);
            }
            this.elementRegistry.clear();
            this.fireEvent(event);
        }
    }

    @Override
    public void loadElements(InputStream stream) throws IOException {
        this.clearElements();
        ObjectInputStream ois = new ObjectInputStream(stream);
        int size = ois.readInt();
        int i = 0;
        while (i < size) {
            try {
                ElementKey key = (ElementKey)ois.readObject();
                Object element = this.getElement(key.getProductGroup(), key.getFactoryType(), key.getDescription());
                boolean active = ois.readBoolean();
                if (active) {
                    LifecycleUtil.activate(element);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {}
            ++i;
        }
        this.initMaxElementID();
    }

    @Override
    public void saveElements(OutputStream stream) throws IOException {
        ObjectOutputStream oos = new ObjectOutputStream(stream);
        ArrayList entries = new ArrayList(this.elementRegistry.entrySet());
        Collections.sort(entries, new EntryComparator());
        oos.writeInt(entries.size());
        for (Map.Entry entry : entries) {
            oos.writeObject(entry.getKey());
            oos.writeBoolean(LifecycleUtil.isActive(entry.getValue()));
        }
    }

    @Override
    public void fireEvent(IEvent event) {
        IContainerEvent containerEvent;
        if (event instanceof IContainerEvent && (containerEvent = (IContainerEvent)event).isEmpty()) {
            return;
        }
        super.fireEvent(event);
    }

    @Override
    public String toString() {
        return "ManagedContainer";
    }

    protected IRegistry<IFactoryKey, IFactory> createFactoryRegistry() {
        return new HashMapRegistry<IFactoryKey, IFactory>();
    }

    protected List<IElementProcessor> createPostProcessors() {
        return new ArrayList<IElementProcessor>();
    }

    protected Object createElement(String productGroup, String factoryType, String description) {
        IFactory factory = this.getFactory(productGroup, factoryType);
        return factory.create(description);
    }

    protected Object postProcessElement(String productGroup, String factoryType, String description, Object element) {
        for (IElementProcessor processor : this.getPostProcessors()) {
            element = processor.process(this, productGroup, factoryType, description, element);
        }
        return element;
    }

    protected void initMaxElementID() {
        this.maxElementID = 0L;
        for (ElementKey key : this.elementRegistry.keySet()) {
            long id = key.getID();
            if (this.maxElementID >= id) continue;
            this.maxElementID = id;
        }
    }

    @Override
    protected void doActivate() throws Exception {
        super.doActivate();
        LifecycleUtil.activate(this.getFactoryRegistry());
        LifecycleUtil.activate(this.getPostProcessors());
    }

    @Override
    protected void doDeactivate() throws Exception {
        Collection values = this.elementRegistry.values();
        Object[] objectArray = values.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            try {
                LifecycleUtil.deactivateNoisy(element);
                EventUtil.removeListener(element, this.elementListener);
            }
            catch (RuntimeException ex) {
                OM.LOG.warn(ex);
            }
            ++n2;
        }
        LifecycleUtil.deactivate(this.factoryRegistry);
        LifecycleUtil.deactivate(this.postProcessors);
        super.doDeactivate();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ElementKey
    implements Serializable,
    Comparable<ElementKey> {
        private static final long serialVersionUID = 1L;
        private long id;
        private String productGroup;
        private String factoryType;
        private String description;

        public ElementKey(String productGroup, String factoryType, String description) {
            this.productGroup = productGroup;
            this.factoryType = factoryType;
            this.description = description;
        }

        public long getID() {
            return this.id;
        }

        public void setID(long id) {
            this.id = id;
        }

        public String getProductGroup() {
            return this.productGroup;
        }

        public String getFactoryType() {
            return this.factoryType;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof ElementKey) {
                ElementKey key = (ElementKey)obj;
                return ObjectUtil.equals(this.productGroup, key.productGroup) && ObjectUtil.equals(this.factoryType, key.factoryType) && ObjectUtil.equals(this.description, key.description);
            }
            return false;
        }

        public int hashCode() {
            return ObjectUtil.hashCode(this.productGroup) ^ ObjectUtil.hashCode(this.factoryType) ^ ObjectUtil.hashCode(this.description);
        }

        public String toString() {
            return MessageFormat.format("{0}[{1}, {2}]", this.productGroup, this.factoryType, this.description);
        }

        @Override
        public int compareTo(ElementKey key) {
            if (this.id < key.id) {
                return -1;
            }
            if (this.id > key.id) {
                return 1;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EntryComparator
    implements Comparator<Map.Entry<ElementKey, Object>> {
        private EntryComparator() {
        }

        @Override
        public int compare(Map.Entry<ElementKey, Object> entry1, Map.Entry<ElementKey, Object> entry2) {
            return entry1.getKey().compareTo(entry2.getKey());
        }
    }
}

