/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.container;

import java.util.List;
import org.eclipse.net4j.util.container.ContainerEvent;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.container.IContainerDelta;
import org.eclipse.net4j.util.container.SingleDeltaContainerEvent;
import org.eclipse.net4j.util.lifecycle.Lifecycle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Container<E>
extends Lifecycle
implements IContainer<E> {
    @Override
    public boolean isEmpty() {
        E[] elements = this.getElements();
        return elements == null || elements.length == 0;
    }

    public void fireElementAddedEvent(E element) {
        this.fireContainerEvent(element, IContainerDelta.Kind.ADDED);
    }

    public void fireElementRemovedEvent(E element) {
        this.fireContainerEvent(element, IContainerDelta.Kind.REMOVED);
    }

    public void fireContainerEvent(E element, IContainerDelta.Kind kind) {
        this.fireEvent(this.newContainerEvent(element, kind));
    }

    public void fireContainerEvent(List<IContainerDelta<E>> deltas) {
        this.fireEvent(new ContainerEvent<E>(this, deltas));
    }

    protected SingleDeltaContainerEvent<E> newContainerEvent(E element, IContainerDelta.Kind kind) {
        return new SingleDeltaContainerEvent<E>(this, element, kind);
    }

    protected ContainerEvent<E> newContainerEvent() {
        return new ContainerEvent(this);
    }
}

