/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.tcp;

import java.nio.ByteBuffer;
import org.eclipse.internal.net4j.buffer.BufferUtil;
import org.eclipse.internal.net4j.channel.Channel;
import org.eclipse.net4j.buffer.IBuffer;
import org.eclipse.net4j.channel.IChannelMultiplexer;
import org.eclipse.net4j.internal.tcp.TCPConnector;
import org.eclipse.net4j.internal.tcp.bundle.OM;
import org.eclipse.net4j.protocol.IProtocol;
import org.eclipse.net4j.util.concurrent.ConcurrencyUtil;
import org.eclipse.net4j.util.concurrent.ISynchronizer;
import org.eclipse.net4j.util.concurrent.SynchronizingCorrelator;
import org.eclipse.net4j.util.concurrent.TimeoutRuntimeException;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.eclipse.net4j.util.security.INegotiationContext;
import org.eclipse.spi.net4j.InternalChannel;

public class ControlChannel
extends Channel {
    public static final short CONTROL_CHANNEL_INDEX = -1;
    public static final byte OPCODE_NEGOTIATION = 1;
    public static final byte OPCODE_REGISTRATION = 2;
    public static final byte OPCODE_REGISTRATION_ACK = 3;
    public static final byte OPCODE_DEREGISTRATION = 4;
    public static final byte SUCCESS = 1;
    public static final byte FAILURE = 0;
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, ControlChannel.class);
    private SynchronizingCorrelator<Short, Boolean> registrations = new SynchronizingCorrelator();

    public ControlChannel(int channelID, TCPConnector connector) {
        this.setChannelID(channelID);
        this.setChannelIndex((short)-1);
        this.setChannelMultiplexer((IChannelMultiplexer)connector);
        this.setReceiveExecutor(connector.getReceiveExecutor());
    }

    public TCPConnector getConnector() {
        return (TCPConnector)this.getChannelMultiplexer();
    }

    public boolean registerChannel(int channelID, short channelIndex, IProtocol protocol, long timeout) {
        if (TRACER.isEnabled()) {
            TRACER.format("Registering channel {0} with protocol {1}", new Object[]{channelIndex, protocol});
        }
        this.assertValidChannelIndex(channelIndex);
        ISynchronizer registration = this.registrations.correlate((Object)channelIndex);
        IBuffer buffer = this.provideBuffer();
        ByteBuffer byteBuffer = buffer.startPutting((short)-1);
        byteBuffer.put((byte)2);
        byteBuffer.putInt(channelID);
        byteBuffer.putShort(channelIndex);
        BufferUtil.putUTF8((ByteBuffer)byteBuffer, (String)(protocol == null ? null : protocol.getType()));
        this.handleBuffer(buffer);
        Boolean acknowledged = (Boolean)registration.get(timeout);
        if (acknowledged == null) {
            throw new TimeoutRuntimeException("Registration timeout after " + timeout + " milliseconds");
        }
        return acknowledged;
    }

    public void deregisterChannel(int channelID, short channelIndex) {
        if (TRACER.isEnabled()) {
            TRACER.format("Deregistering channel {0}", new Object[]{channelIndex});
        }
        this.assertValidChannelIndex(channelIndex);
        IBuffer buffer = this.provideBuffer();
        ByteBuffer byteBuffer = buffer.startPutting((short)-1);
        byteBuffer.put((byte)4);
        byteBuffer.putInt(channelID);
        byteBuffer.putShort(channelIndex);
        this.handleBuffer(buffer);
    }

    public void handleBufferFromMultiplexer(IBuffer buffer) {
        try {
            ByteBuffer byteBuffer = buffer.getByteBuffer();
            byte opcode = byteBuffer.get();
            switch (opcode) {
                case 1: {
                    this.assertNegotiating();
                    INegotiationContext negotiationContext = this.getConnector().getNegotiationContext();
                    while (negotiationContext == null) {
                        ConcurrencyUtil.sleep((long)20L);
                        negotiationContext = this.getConnector().getNegotiationContext();
                    }
                    INegotiationContext.Receiver receiver = negotiationContext.getReceiver();
                    receiver.receiveBuffer(negotiationContext, byteBuffer);
                    break;
                }
                case 2: {
                    this.assertConnected();
                    int channelID = byteBuffer.getInt();
                    short channelIndex = byteBuffer.getShort();
                    this.assertValidChannelIndex(channelIndex);
                    boolean success = true;
                    try {
                        byte[] handlerFactoryUTF8 = BufferUtil.getByteArray((ByteBuffer)byteBuffer);
                        String protocolID = BufferUtil.fromUTF8((byte[])handlerFactoryUTF8);
                        InternalChannel channel = this.getConnector().createChannel(channelID, channelIndex, protocolID);
                        if (channel != null) {
                            channel.activate();
                        } else {
                            success = false;
                        }
                    }
                    catch (Exception ex) {
                        OM.LOG.error((Throwable)ex);
                        success = false;
                    }
                    this.sendStatus((byte)3, channelIndex, success);
                    break;
                }
                case 3: {
                    this.assertConnected();
                    short channelIndex = byteBuffer.getShort();
                    boolean success = byteBuffer.get() == 1;
                    this.registrations.put((Object)channelIndex, (Object)success);
                    break;
                }
                case 4: {
                    this.assertConnected();
                    int channelID = byteBuffer.getInt();
                    short channelIndex = byteBuffer.getShort();
                    if (channelIndex != -1) {
                        try {
                            this.getConnector().inverseRemoveChannel(channelID, channelIndex);
                        }
                        catch (Exception ex) {
                            OM.LOG.error((Throwable)ex);
                        }
                    }
                    break;
                }
                default: {
                    OM.LOG.error("Invalid opcode: " + opcode);
                    this.getConnector().deactivate();
                    break;
                }
            }
        }
        finally {
            buffer.release();
        }
    }

    public String toString() {
        return "Channel[Control]";
    }

    private void sendStatus(byte opcode, short channelIndex, boolean status) {
        IBuffer buffer = this.provideBuffer();
        ByteBuffer byteBuffer = buffer.startPutting((short)-1);
        byteBuffer.put(opcode);
        byteBuffer.putShort(channelIndex);
        byteBuffer.put(status ? (byte)1 : 0);
        this.handleBuffer(buffer);
    }

    private IBuffer provideBuffer() {
        return this.getConnector().getBufferProvider().provideBuffer();
    }

    private void assertNegotiating() {
        if (!this.getConnector().isNegotiating()) {
            this.getConnector().deactivate();
            throw new IllegalStateException("Connector is not negotiating");
        }
    }

    private void assertConnected() {
        if (!this.getConnector().isConnected()) {
            throw new IllegalStateException("Connector is not connected");
        }
    }

    private void assertValidChannelIndex(short channelIndex) {
        if (channelIndex <= -1) {
            throw new IllegalArgumentException("channelIndex <= CONTROL_CHANNEL_ID");
        }
    }
}

