/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.buddies.internal.server.protocol;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.net4j.buddies.common.IBuddy;
import org.eclipse.net4j.buddies.common.ICollaboration;
import org.eclipse.net4j.buddies.internal.common.Collaboration;
import org.eclipse.net4j.buddies.internal.common.Membership;
import org.eclipse.net4j.buddies.internal.common.protocol.ProtocolUtil;
import org.eclipse.net4j.buddies.internal.server.BuddyAdmin;
import org.eclipse.net4j.buddies.internal.server.protocol.CollaborationInitiatedNotification;
import org.eclipse.net4j.channel.IChannel;
import org.eclipse.net4j.signal.Indication;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;

public class InviteBuddiesIndication
extends Indication {
    protected short getSignalID() {
        return 9;
    }

    protected void indicating(ExtendedDataInputStream in) throws IOException {
        long collaborationID = in.readLong();
        String[] userIDs = ProtocolUtil.readUserIDs((ExtendedDataInputStream)in);
        Collaboration collaboration = (Collaboration)BuddyAdmin.INSTANCE.getCollaboration(collaborationID);
        if (collaboration != null) {
            HashSet<IBuddy> added = new HashSet<IBuddy>();
            String[] stringArray = userIDs;
            int n = userIDs.length;
            int n2 = 0;
            while (n2 < n) {
                String userID = stringArray[n2];
                IBuddy buddy = BuddyAdmin.INSTANCE.getBuddy(userID);
                if (buddy != null && collaboration.getMembership(buddy) == null) {
                    Membership.create((IBuddy)buddy, (ICollaboration)collaboration);
                    added.add(buddy);
                }
                ++n2;
            }
            List<IBuddy> buddies = Arrays.asList(collaboration.getBuddies());
            for (IBuddy buddy : buddies) {
                IChannel channel = buddy.getSession().getChannel();
                String[] facilityTypes = null;
                HashSet<IBuddy> set = new HashSet<IBuddy>();
                if (added.contains(buddy)) {
                    set.addAll(buddies);
                    set.remove(buddy);
                    facilityTypes = collaboration.getFacilityTypes();
                } else {
                    set.addAll(added);
                }
                if (set.isEmpty()) continue;
                try {
                    new CollaborationInitiatedNotification(channel, collaborationID, set, facilityTypes).send();
                }
                catch (Exception ex) {
                    throw WrappedException.wrap((Exception)ex);
                }
            }
        }
    }
}

