/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.net4j.util.ui.StaticContentProvider;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BulkAddDialog
extends TitleAreaDialog {
    public static final String TITLE = "Bulk Add";
    private IWorkbenchPage page;
    private List<EReference> features = new ArrayList<EReference>();
    private EReference feature;
    private int instances = 100;

    public BulkAddDialog(IWorkbenchPage page, List<EReference> features) {
        super(new Shell(page.getWorkbenchWindow().getShell()));
        this.setShellStyle(this.getShellStyle() | 0x10000 | 0x400 | 0x20 | 0x10);
        this.page = page;
        this.features = features;
    }

    public IWorkbenchPage getPage() {
        return this.page;
    }

    public List<EReference> getFeatures() {
        return this.features;
    }

    public EReference getFeature() {
        return this.feature;
    }

    public int getInstances() {
        return this.instances;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(TITLE);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite((Composite)super.createDialogArea(parent), 0);
        composite.setLayoutData((Object)UIUtil.createGridData());
        composite.setLayout((Layout)new GridLayout(2, false));
        this.setTitle("Select a child type and number of child instances");
        Label label = new Label(composite, 0);
        label.setText("Type:");
        label.setLayoutData((Object)new GridData(1, 1, false, false));
        final TableViewer featureViewer = new TableViewer(composite, 2052);
        featureViewer.getTable().setLayoutData((Object)UIUtil.createGridData((boolean)true, (boolean)true));
        featureViewer.setContentProvider((IContentProvider)new StaticContentProvider(this.features));
        featureViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((EReference)element).getName();
            }
        });
        featureViewer.setInput(this.features);
        featureViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)featureViewer.getSelection();
                BulkAddDialog.this.feature = selection.isEmpty() ? null : (EReference)selection.getFirstElement();
                BulkAddDialog.this.dialogChanged();
            }
        });
        new Label(composite, 0).setText("Instances:");
        final Text instancesText = new Text(composite, 2048);
        instancesText.setLayoutData((Object)UIUtil.createGridData((boolean)true, (boolean)false));
        instancesText.setText(String.valueOf(this.instances));
        instancesText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    String text = instancesText.getText();
                    BulkAddDialog.this.instances = Integer.parseInt(text);
                }
                catch (NumberFormatException numberFormatException) {
                    BulkAddDialog.this.instances = 0;
                }
                BulkAddDialog.this.dialogChanged();
            }
        });
        return composite;
    }

    protected Control createButtonBar(Composite parent) {
        try {
            Control control = super.createButtonBar(parent);
            return control;
        }
        finally {
            this.dialogChanged();
        }
    }

    protected void dialogChanged() {
        this.getButton(0).setEnabled(false);
        if (this.feature == null) {
            this.setErrorMessage("Select a feature");
            return;
        }
        if (this.instances == 0) {
            this.setErrorMessage("Enter a valid number of instances (>0)");
            return;
        }
        this.getButton(0).setEnabled(true);
        this.setErrorMessage(null);
    }
}

