/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server.protocol;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.io.CDODataInput;
import org.eclipse.emf.cdo.common.io.CDODataOutput;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.internal.server.bundle.OM;
import org.eclipse.emf.cdo.internal.server.protocol.CDOReadIndication;
import org.eclipse.emf.cdo.internal.server.protocol.CDOServerProtocol;
import org.eclipse.emf.cdo.internal.server.protocol.SyncRevisionsIndication;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.net4j.util.collection.Pair;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public abstract class AbstractSyncRevisionsIndication
extends CDOReadIndication {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_PROTOCOL, SyncRevisionsIndication.class);
    protected List<Pair<InternalCDORevision, Long>> dirtyObjects = new ArrayList<Pair<InternalCDORevision, Long>>();
    protected List<Pair<CDOID, Long>> detachedObjects = new ArrayList<Pair<CDOID, Long>>();
    protected int referenceChunk = -1;

    public AbstractSyncRevisionsIndication(CDOServerProtocol protocol, short signalID) {
        super(protocol, signalID);
    }

    protected void indicating(CDODataInput in) throws IOException {
        this.referenceChunk = in.readInt();
        int size = in.readInt();
        int i = 0;
        while (i < size) {
            CDOID id = in.readCDOID();
            int version = in.readInt();
            this.process(id, version);
            ++i;
        }
    }

    protected void responding(CDODataOutput out) throws IOException {
        if (TRACER.isEnabled()) {
            TRACER.format("Sync found " + this.dirtyObjects.size() + " dirty objects", new Object[0]);
        }
        out.writeInt(this.dirtyObjects.size());
        for (Pair<InternalCDORevision, Long> pair : this.dirtyObjects) {
            out.writeCDORevision((CDORevision)pair.getElement1(), this.referenceChunk);
            out.writeLong(((Long)pair.getElement2()).longValue());
        }
        out.writeInt(this.detachedObjects.size());
        for (Pair<InternalCDORevision, Long> pair : this.detachedObjects) {
            out.writeCDOID((CDOID)pair.getElement1());
            out.writeLong(((Long)pair.getElement2()).longValue());
        }
    }

    protected abstract void process(CDOID var1, int var2);

    protected void udpateObjectList(CDOID id, int version) {
        try {
            InternalCDORevision revision = this.getRepository().getRevisionManager().getRevision(id, this.referenceChunk);
            if (revision == null) {
                this.detachedObjects.add((Pair<CDOID, Long>)new Pair((Object)id, (Object)this.getTimestamp(id, version)));
            } else if (revision.getVersion() > version || version == 0) {
                this.dirtyObjects.add((Pair<InternalCDORevision, Long>)new Pair((Object)revision, (Object)this.getTimestamp(id, version)));
            } else if (revision.getVersion() < version) {
                throw new IllegalStateException("The object " + revision.getID() + " have a higher version (" + revision.getVersion() + ") in the repository than the version (" + version + ") submitted.");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.detachedObjects.add((Pair<CDOID, Long>)new Pair((Object)id, (Object)this.getTimestamp(id, version)));
        }
    }

    protected long getTimestamp(CDOID id, int version) {
        InternalCDORevision revision = this.getRepository().getRevisionManager().getRevisionByVersion(id, 0, version, false);
        if (revision != null) {
            return revision.getRevised() + 1L;
        }
        return 0L;
    }
}

