/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.samples.issues.bz225296_2.ops;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum IpType implements Enumerator
{
    EXTERNAL(0, "External", "External"),
    INTERNAL(1, "Internal", "Internal");

    public static final int EXTERNAL_VALUE = 0;
    public static final int INTERNAL_VALUE = 1;
    private static final IpType[] VALUES_ARRAY;
    public static final List<IpType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new IpType[]{EXTERNAL, INTERNAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static IpType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            IpType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static IpType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            IpType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static IpType get(int value) {
        switch (value) {
            case 0: {
                return EXTERNAL;
            }
            case 1: {
                return INTERNAL;
            }
        }
        return null;
    }

    private IpType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

