/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.eclipse.resourcehandler;

import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.teneo.eclipse.StoreEclipseException;
import org.eclipse.emf.teneo.eclipse.StoreEclipseUtil;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorMapping;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public abstract class StoreOpenResource
implements IObjectActionDelegate {
    private static Log log = LogFactory.getLog(StoreOpenResource.class);
    protected IStructuredSelection selection = null;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        IFile propFile = (IFile)this.selection.getFirstElement();
        try {
            Properties props = StoreEclipseUtil.readPropFile(this.selection);
            this.openDataStore(props);
            String editorextension = this.doTrim(props.getProperty("editorextension"));
            String editorid = this.doTrim(props.getProperty("editorid"));
            String foundEditorID = this.getEditorID(editorid, editorextension);
            IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            IWorkbenchPage page = workbenchWindow.getActivePage();
            page.openEditor((IEditorInput)new FileEditorInput(propFile), foundEditorID);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            log.error((Object)e);
            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Error Occured", (String)e.getMessage());
        }
    }

    protected abstract void openDataStore(Properties var1);

    private String doTrim(String totrim) {
        if (totrim == null) {
            return null;
        }
        return totrim.trim();
    }

    private String getEditorID(String propID, String propExtension) {
        if (propID != null) {
            return propID;
        }
        IWorkbench workbench = PlatformUI.getWorkbench();
        IEditorDescriptor editorDesc = workbench.getEditorRegistry().getDefaultEditor(propExtension);
        if (editorDesc == null) {
            IFileEditorMapping[] mappings;
            IFileEditorMapping[] iFileEditorMappingArray = mappings = workbench.getEditorRegistry().getFileEditorMappings();
            int n = mappings.length;
            int n2 = 0;
            while (n2 < n) {
                IFileEditorMapping map = iFileEditorMappingArray[n2];
                if (map.getExtension().compareTo(propExtension.toLowerCase()) == 0) {
                    editorDesc = map.getEditors()[0];
                    break;
                }
                ++n2;
            }
        }
        if (editorDesc == null) {
            throw new StoreEclipseException("No editor can be found for extension: " + propExtension);
        }
        return editorDesc.getId();
    }

    public IFile getModelFile(IFile ehbFile, String extension) {
        return ResourcesPlugin.getWorkspace().getRoot().getFile(ehbFile.getFullPath().append("hibernate." + extension));
    }

    public void selectionChanged(IAction action, ISelection selected) {
        IStructuredSelection structSelection;
        if (!(selected instanceof IStructuredSelection)) {
            return;
        }
        this.selection = structSelection = (IStructuredSelection)selected;
    }
}

