/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate.mapping.elist;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.teneo.EContainerRepairControl;
import org.eclipse.emf.teneo.extension.ExtensionPoint;
import org.eclipse.emf.teneo.hibernate.HbMapperException;
import org.eclipse.emf.teneo.hibernate.LazyCollectionUtils;
import org.eclipse.emf.teneo.hibernate.SessionWrapper;
import org.eclipse.emf.teneo.hibernate.mapping.elist.HibernatePersistableEList;
import org.eclipse.emf.teneo.hibernate.resource.HbResource;
import org.eclipse.emf.teneo.resource.StoreResource;
import org.eclipse.emf.teneo.util.StoreUtil;
import org.hibernate.Session;
import org.hibernate.collection.internal.AbstractPersistentCollection;
import org.hibernate.collection.internal.PersistentBag;
import org.hibernate.collection.internal.PersistentIdentifierBag;
import org.hibernate.collection.internal.PersistentList;
import org.hibernate.collection.spi.PersistentCollection;

public class HbExtraLazyPersistableEList<E>
extends HibernatePersistableEList<E>
implements ExtensionPoint {
    private static final long serialVersionUID = 5479222310361594394L;
    private boolean previousDeliverSetting = false;

    public HbExtraLazyPersistableEList(InternalEObject owner, EStructuralFeature feature, List<E> list) {
        super(owner, feature, list);
    }

    public boolean isUnique() {
        return false;
    }

    protected void delegateAdd(int index, E object) {
        if (index == this.size()) {
            this.delegateAdd(object);
            return;
        }
        this.delegateList().iterator();
        this.delegateList().add(index, object);
        int newIndex = index;
        for (E element : this.delegateList().subList(index, this.size())) {
            if (newIndex == index) {
                StoreUtil.setSyntheticListOwner((EStructuralFeature)this.getEStructuralFeature(), element, (Object)this.getOwner());
            }
            StoreUtil.setSyntheticListIndex((EStructuralFeature)this.getEStructuralFeature(), element, (Integer)newIndex++);
        }
    }

    protected void delegateAdd(E object) {
        int newIndex = this.delegateList().size();
        this.delegateList().add(object);
        StoreUtil.setSyntheticListIndex((EStructuralFeature)this.getEStructuralFeature(), object, (Integer)newIndex);
        StoreUtil.setSyntheticListOwner((EStructuralFeature)this.getEStructuralFeature(), object, (Object)this.getOwner());
    }

    protected void delegateClear() {
        for (E element : this.delegateList()) {
            StoreUtil.resetSyntheticListInfo((EStructuralFeature)this.getEStructuralFeature(), element);
        }
        this.delegateList().clear();
    }

    public Iterator<E> delegateIterator() {
        return this.iterator();
    }

    public Iterator<E> iterator() {
        return LazyCollectionUtils.getPagedLoadingIterator(this, 100);
    }

    protected boolean delegateContains(Object object) {
        return this.delegateList().contains(object);
    }

    protected boolean delegateContainsAll(Collection<?> collection) {
        return this.delegateList().containsAll(collection);
    }

    protected List<E> delegateList() {
        return this.getDelegate();
    }

    protected E delegateGet(int index) {
        boolean callAfterLoadInstance = false;
        if (!this.isLoaded()) {
            this.beforeLoadInstance();
            callAfterLoadInstance = true;
        }
        E object = this.delegateList().get(index);
        if (callAfterLoadInstance && object instanceof EObject) {
            EObject eObject = (EObject)object;
            this.afterLoadInstance(eObject);
        }
        return object;
    }

    protected E delegateRemove(int index) {
        if (index == this.size() - 1 && !this.isInitialized() && this.isConnectedToSession()) {
            E result = this.delegateList().remove(index);
            StoreUtil.resetSyntheticListInfo((EStructuralFeature)this.getEStructuralFeature(), result);
            if (this.getEStructuralFeature() instanceof EReference && ((EReference)this.getEStructuralFeature()).isContainment()) {
                Session session = (Session)((PersistentList)this.getDelegate()).getSession();
                session.delete(result);
            }
            return result;
        }
        this.delegateList().iterator();
        E result = this.delegateList().remove(index);
        StoreUtil.resetSyntheticListInfo((EStructuralFeature)this.getEStructuralFeature(), result);
        int newIndex = index;
        for (E element : this.delegateList().subList(index, this.size())) {
            if (element == null) continue;
            StoreUtil.setSyntheticListIndex((EStructuralFeature)this.getEStructuralFeature(), element, (Integer)newIndex++);
        }
        return result;
    }

    protected E delegateSet(int index, E object) {
        E oldObject = this.delegateList().set(index, object);
        if (oldObject != null) {
            StoreUtil.resetSyntheticListInfo((EStructuralFeature)this.getEStructuralFeature(), oldObject);
        }
        StoreUtil.setSyntheticListIndex((EStructuralFeature)this.getEStructuralFeature(), object, (Integer)index);
        StoreUtil.setSyntheticListOwner((EStructuralFeature)this.getEStructuralFeature(), object, (Object)this.getOwner());
        return oldObject;
    }

    protected synchronized void beforeLoadInstance() {
        Resource res = this.owner.eResource();
        if (res != null && res instanceof HbResource) {
            SessionWrapper sessionWrapper = ((HbResource)res).getSessionWrapper();
            if (res.isLoaded()) {
                boolean isDelegateLoaded;
                boolean bl = isDelegateLoaded = this.delegate instanceof AbstractPersistentCollection && ((AbstractPersistentCollection)this.delegate).wasInitialized();
                if (!isDelegateLoaded && !sessionWrapper.isTransactionActive()) {
                    sessionWrapper.setFlushModeManual();
                }
                ((StoreResource)res).setIsLoading(true);
            }
        }
        this.previousDeliverSetting = this.owner.eDeliver();
        try {
            if (this.previousDeliverSetting) {
                this.owner.eSetDeliver(false);
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    protected void afterLoadInstance(EObject eObject) {
        Resource res;
        if (this.isContainment() && eObject.eContainer() == null) {
            EContainerRepairControl.setContainer((InternalEObject)this.owner, (InternalEObject)((InternalEObject)eObject), (EStructuralFeature)this.getEStructuralFeature());
        }
        if ((res = this.owner.eResource()) != null && res instanceof HbResource) {
            ((StoreResource)res).addToContentOrAttach((InternalEObject)eObject, (EReference)this.getEStructuralFeature());
            ((StoreResource)res).setIsLoading(false);
        }
        try {
            if (this.previousDeliverSetting) {
                this.owner.eSetDeliver(true);
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Override
    public boolean isInitialized() {
        return ((PersistentCollection)this.delegate).wasInitialized();
    }

    @Override
    public void replaceDelegate(List<E> newDelegate) {
        if (newDelegate instanceof PersistentList) {
            super.replaceDelegate(newDelegate);
        } else if (newDelegate instanceof PersistentBag) {
            super.replaceDelegate(newDelegate);
        } else if (newDelegate instanceof PersistentIdentifierBag) {
            super.replaceDelegate(newDelegate);
        } else if (newDelegate != this.delegate) {
            throw new HbMapperException("Type " + newDelegate.getClass().getName() + " can not be " + " used as a replacement for elist " + this.logString);
        }
    }

    @Override
    public boolean isPersistencyWrapped() {
        return this.delegate instanceof PersistentCollection;
    }
}

