/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.annotations.mapper;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.teneo.annotations.mapper.AbstractAnnotator;
import org.eclipse.emf.teneo.annotations.mapper.BidirectionalManyToManyAnnotator;
import org.eclipse.emf.teneo.annotations.mapper.ManyToOneReferenceAnnotator;
import org.eclipse.emf.teneo.annotations.mapper.OneToManyAttributeAnnotator;
import org.eclipse.emf.teneo.annotations.mapper.OneToManyReferenceAnnotator;
import org.eclipse.emf.teneo.annotations.mapper.OneToOneReferenceAnnotator;
import org.eclipse.emf.teneo.annotations.mapper.SingleAttributeAnnotator;
import org.eclipse.emf.teneo.annotations.mapper.UnidirectionalManyToManyAnnotator;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEAttribute;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEReference;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEStructuralFeature;
import org.eclipse.emf.teneo.annotations.pannotation.Transient;
import org.eclipse.emf.teneo.extension.ExtensionPoint;
import org.eclipse.emf.teneo.util.StoreUtil;

public class EFeatureAnnotator
extends AbstractAnnotator
implements ExtensionPoint {
    protected static final Log log = LogFactory.getLog(EFeatureAnnotator.class);
    protected OneToManyAttributeAnnotator otmAttributeAnnotator;
    protected SingleAttributeAnnotator singleAttributeAnnotator;
    protected BidirectionalManyToManyAnnotator bidirectionalManyToManyAnnotator;
    protected UnidirectionalManyToManyAnnotator unidirectionalManyToManyAnnotator;
    protected OneToManyReferenceAnnotator oneToManyReferenceAnnotator;
    protected OneToOneReferenceAnnotator oneToOneReferenceAnnotator;
    protected ManyToOneReferenceAnnotator manyToOneReferenceAnnotator;

    protected void initialize() {
        super.initialize();
        this.otmAttributeAnnotator = this.createAnnotator(OneToManyAttributeAnnotator.class);
        this.otmAttributeAnnotator.setEFeatureAnnotator(this);
        this.singleAttributeAnnotator = this.createAnnotator(SingleAttributeAnnotator.class);
        this.singleAttributeAnnotator.setEFeatureAnnotator(this);
        this.bidirectionalManyToManyAnnotator = this.createAnnotator(BidirectionalManyToManyAnnotator.class);
        this.bidirectionalManyToManyAnnotator.setEFeatureAnnotator(this);
        this.unidirectionalManyToManyAnnotator = this.createAnnotator(UnidirectionalManyToManyAnnotator.class);
        this.unidirectionalManyToManyAnnotator.setEFeatureAnnotator(this);
        this.oneToManyReferenceAnnotator = this.createAnnotator(OneToManyReferenceAnnotator.class);
        this.oneToManyReferenceAnnotator.setEFeatureAnnotator(this);
        this.oneToOneReferenceAnnotator = this.createAnnotator(OneToOneReferenceAnnotator.class);
        this.oneToOneReferenceAnnotator.setEFeatureAnnotator(this);
        this.manyToOneReferenceAnnotator = this.createAnnotator(ManyToOneReferenceAnnotator.class);
        this.manyToOneReferenceAnnotator.setEFeatureAnnotator(this);
    }

    public void annotate(PAnnotatedEStructuralFeature aStructuralFeature) {
        EStructuralFeature eStructuralFeature = aStructuralFeature.getModelEStructuralFeature();
        boolean errorOccured = true;
        try {
            PAnnotatedEReference aReference;
            boolean isTransient;
            boolean bl = isTransient = eStructuralFeature.isTransient() && (eStructuralFeature instanceof EAttribute || ((EReference)eStructuralFeature).getEOpposite() == null || !((EReference)eStructuralFeature).getEOpposite().isContainment() || ((EReference)eStructuralFeature).getEOpposite().isTransient());
            if (!isTransient && eStructuralFeature instanceof EReference) {
                Transient trans;
                aReference = (PAnnotatedEReference)aStructuralFeature;
                if (aReference.getTransient() != null) {
                    trans = this.getFactory().createTransient();
                    trans.setEModelElement((EModelElement)eStructuralFeature);
                    aStructuralFeature.setTransient(trans);
                } else if (aReference.getExternal() == null) {
                    if (this.hasTransientAnnotation(aReference.getEReferenceType())) {
                        trans = this.getFactory().createTransient();
                        trans.setEModelElement((EModelElement)eStructuralFeature);
                        aStructuralFeature.setTransient(trans);
                    } else if (aReference.getAReferenceType() != null) {
                        boolean bl2 = isTransient = aReference.getAReferenceType().getTransient() != null;
                    }
                }
                if (aReference != null && aReference.getTransient() == null && aReference.getExternal() == null && aReference.getAReferenceType() != null && aReference.getAReferenceType().getExternal() != null) {
                    aReference.setExternal(aReference.getAReferenceType().getExternal());
                }
            }
            if (aStructuralFeature.getTransient() != null) {
                return;
            }
            if (aStructuralFeature.getTransient() == null && (!this.mapVolitatileFeature() && eStructuralFeature.isVolatile() || isTransient)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Structural feature " + eStructuralFeature.getName() + " is transient, therefore adding transient annotation"));
                }
                Transient trans = this.getFactory().createTransient();
                trans.setEModelElement((EModelElement)eStructuralFeature);
                aStructuralFeature.setTransient(trans);
            }
            if (aStructuralFeature instanceof PAnnotatedEAttribute) {
                PAnnotatedEAttribute aAttribute = (PAnnotatedEAttribute)aStructuralFeature;
                if (((PAnnotatedEAttribute)aStructuralFeature).getVersion() != null) {
                    return;
                }
                Class instanceClass = eStructuralFeature.getEType().getInstanceClass();
                boolean isMany = false;
                if (instanceClass != null) {
                    if (aAttribute.getLob() != null && instanceClass.isArray()) {
                        isMany = false;
                    } else {
                        isMany = eStructuralFeature.isMany() || instanceClass.isArray() || Collection.class.isAssignableFrom(instanceClass) || Set.class.isAssignableFrom(instanceClass) || List.class.isAssignableFrom(instanceClass);
                        boolean bl3 = isMany = isMany && !StoreUtil.isElementOfAGroup(eStructuralFeature);
                    }
                }
                if (isMany) {
                    this.otmAttributeAnnotator.annotate(aAttribute);
                } else {
                    this.singleAttributeAnnotator.annotate(aAttribute);
                }
                if (aAttribute.getColumn() != null && aAttribute.getColumn().getName() == null) {
                    aAttribute.getColumn().setName(this.getSqlNameStrategy().getColumnName((PAnnotatedEStructuralFeature)aAttribute, null));
                }
            } else if (aStructuralFeature instanceof PAnnotatedEReference) {
                boolean mtoUnidirectionalRelation;
                aReference = (PAnnotatedEReference)aStructuralFeature;
                EReference eReference = (EReference)aStructuralFeature.getModelElement();
                EReference eOpposite = eReference.getEOpposite();
                boolean isMany = eReference.isMany() && !StoreUtil.isElementOfAGroup((EStructuralFeature)eReference);
                boolean isOppositeMany = eOpposite != null && eOpposite.isMany() && !StoreUtil.isElementOfAGroup((EStructuralFeature)eOpposite);
                boolean mtmBidirectionalRelation = isMany && eOpposite != null && isOppositeMany;
                boolean mtmUnidirectionalRelation = isMany && eOpposite == null && aReference.getManyToMany() != null;
                boolean otmBidirectionalRelation = isMany && eOpposite != null && !isOppositeMany;
                boolean otmUnidirectionalRelation = isMany && eOpposite == null;
                boolean otoBidirectionalRelation = aReference.getManyToOne() == null && !isMany && eOpposite != null && !isOppositeMany;
                boolean otoUnidirectionalRelation = aReference.getManyToOne() == null && !isMany && eOpposite == null && (aReference.getOneToOne() != null || !aReference.getPrimaryKeyJoinColumns().isEmpty());
                boolean mtoBidirectionalRelation = !isMany && eOpposite != null && isOppositeMany;
                boolean bl4 = mtoUnidirectionalRelation = !isMany && eOpposite == null && !otoUnidirectionalRelation;
                if (mtmBidirectionalRelation) {
                    this.bidirectionalManyToManyAnnotator.annotate(aReference);
                } else if (mtmUnidirectionalRelation) {
                    this.unidirectionalManyToManyAnnotator.annotate(aReference);
                } else if (otmBidirectionalRelation || otmUnidirectionalRelation) {
                    this.oneToManyReferenceAnnotator.annotate(aReference);
                } else if (aReference.getManyToOne() == null && (otoBidirectionalRelation || otoUnidirectionalRelation)) {
                    this.oneToOneReferenceAnnotator.annotate(aReference);
                } else if (mtoBidirectionalRelation) {
                    this.manyToOneReferenceAnnotator.annotate(aReference);
                } else if (mtoUnidirectionalRelation) {
                    this.manyToOneReferenceAnnotator.annotate(aReference);
                }
                if (aReference.getColumn() != null && aReference.getColumn().getName() == null) {
                    aReference.getColumn().setName(this.getSqlNameStrategy().getColumnName((PAnnotatedEStructuralFeature)aReference, null));
                }
            } else {
                throw new IllegalArgumentException("This type of StructuralFeature is not supported: " + aStructuralFeature.getClass().getName());
            }
            errorOccured = false;
        }
        finally {
            if (aStructuralFeature instanceof PAnnotatedEAttribute) {
                PAnnotatedEAttribute pae = (PAnnotatedEAttribute)aStructuralFeature;
                assert (errorOccured || pae.getBasic() != null || pae.getVersion() != null || pae.getId() != null || pae.getTransient() != null || pae.getOneToMany() != null);
            } else {
                PAnnotatedEReference par = (PAnnotatedEReference)aStructuralFeature;
                assert (errorOccured || par.getTransient() != null || par.getOneToMany() != null || par.getManyToMany() != null || par.getManyToOne() != null || par.getOneToOne() != null);
            }
        }
    }

    protected boolean mapVolitatileFeature() {
        return false;
    }

    public ManyToOneReferenceAnnotator getManyToOneReferenceAnnotator() {
        return this.manyToOneReferenceAnnotator;
    }

    private boolean hasTransientAnnotation(EClass eClass) {
        EAnnotation eAnnotation = eClass.getEAnnotation("teneo.jpa");
        if (eAnnotation == null) {
            return false;
        }
        for (String value : eAnnotation.getDetails().values()) {
            if (!value.contains("@Transient")) continue;
            return true;
        }
        return false;
    }
}

