/**
 * <copyright>
 * </copyright>
 *
 * $Id: PAnnotatedEPackageValidator.java,v 1.4 2009/12/13 10:14:13 mtaal Exp $
 */
package org.eclipse.emf.teneo.annotations.pamodel.validation;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEClass;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEDataType;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedModel;
import org.eclipse.emf.teneo.annotations.pannotation.SequenceGenerator;
import org.eclipse.emf.teneo.annotations.pannotation.SequenceStyleGenerator;
import org.eclipse.emf.teneo.annotations.pannotation.TableGenerator;

/**
 * A sample validator interface for {@link org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEPackage}.
 * This doesn't really do anything, and it's not a real EMF artifact.
 * It was generated by the org.eclipse.emf.examples.generator.validator plug-in to illustrate how EMF's code generator can be extended.
 * This can be disabled with -vmargs -Dorg.eclipse.emf.examples.generator.validator=false.
 */
public interface PAnnotatedEPackageValidator {
	boolean validate();

	boolean validatePaModel(PAnnotatedModel value);
	boolean validateModelEPackage(EPackage value);

	boolean validateAnnotatedEPackage(EPackage value);
	boolean validatePaEClasses(EList<PAnnotatedEClass> value);
	boolean validateSequenceGenerators(EList<SequenceGenerator> value);
	boolean validateTableGenerators(EList<TableGenerator> value);
	boolean validatePaEDataTypes(EList<PAnnotatedEDataType> value);

	boolean validateSequenceStyleGenerators(EList<SequenceStyleGenerator> value);
}
