/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.annotations;

import java.util.List;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.teneo.annotations.pannotation.PAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationUtil {
    public static String getAnnotationValue(EObject eObject, EStructuralFeature eFeature, boolean prependComma, List<String> importStatements) {
        String result;
        Object value = eObject.eGet(eFeature);
        if (value == null) {
            return "";
        }
        if (value instanceof String) {
            result = String.valueOf(eFeature.getName()) + " = \"" + (String)value + "\"";
        } else if (value instanceof Enumerator) {
            result = String.valueOf(eFeature.getName()) + " = " + ((Enumerator)value).getLiteral();
        } else if (value instanceof List) {
            List values = (List)value;
            if (values.size() == 0) {
                return "";
            }
            StringBuffer sb = new StringBuffer();
            for (Object o : values) {
                PAnnotation pAnnotation = (PAnnotation)o;
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(pAnnotation.getJavaAnnotation(importStatements));
            }
            result = String.valueOf(eFeature.getName()) + " = {" + sb.toString() + "}";
        } else {
            throw new IllegalArgumentException("Unknown type " + value.getClass());
        }
        if (prependComma) {
            return ", " + result;
        }
        return result;
    }
}

