/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.jpox.mapper;

import java.util.HashMap;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.teneo.annotations.mapper.AbstractProcessingContext;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEClass;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEStructuralFeature;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedModel;
import org.eclipse.emf.teneo.extension.ExtensionInitializable;
import org.eclipse.emf.teneo.extension.ExtensionManager;
import org.eclipse.emf.teneo.extension.ExtensionManagerAware;
import org.eclipse.emf.teneo.extension.ExtensionPoint;
import org.eclipse.emf.teneo.jpox.mapper.AbstractMapper;
import org.eclipse.emf.teneo.jpox.mapper.NamingHandler;
import org.eclipse.emf.teneo.jpox.mapper.association.EmbeddedMapper;
import org.eclipse.emf.teneo.jpox.mapper.association.ManyToManyMapper;
import org.eclipse.emf.teneo.jpox.mapper.association.ManyToOneMapper;
import org.eclipse.emf.teneo.jpox.mapper.association.OneToManyMapper;
import org.eclipse.emf.teneo.jpox.mapper.association.OneToOneMapper;
import org.eclipse.emf.teneo.jpox.mapper.property.BasicMapper;
import org.eclipse.emf.teneo.jpox.mapper.property.ColumnMapper;
import org.eclipse.emf.teneo.jpox.mapper.property.EClassFeatureMapper;
import org.eclipse.emf.teneo.jpox.mapper.property.IdMapper;
import org.eclipse.emf.teneo.jpox.mapper.property.InheritanceMapper;
import org.eclipse.emf.teneo.jpox.mapper.property.JoinColumnMapper;
import org.eclipse.emf.teneo.jpox.mapper.property.ManyBasicMapper;
import org.eclipse.emf.teneo.jpox.mapper.property.TableMapper;
import org.eclipse.emf.teneo.mapping.strategy.EntityNameStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappingContext
extends AbstractProcessingContext
implements ExtensionPoint,
ExtensionManagerAware,
ExtensionInitializable {
    protected static final Log log = LogFactory.getLog(MappingContext.class);
    private OneToManyMapper otmMapper;
    private ManyToManyMapper mtmMapper;
    private OneToOneMapper otoMapper;
    private ManyToOneMapper mtoMapper;
    private InheritanceMapper inheritanceMapper;
    private ColumnMapper columnMapper;
    private IdMapper idMapper;
    private BasicMapper basicMapper;
    private ManyBasicMapper manyBasicMapper;
    private NamingHandler namingHandler;
    private PAnnotatedModel paModel;
    private Stack mappedEFeatures = new Stack();
    private PAnnotatedEStructuralFeature currentAFeature = null;
    private PAnnotatedEClass currentAClass = null;
    private HashMap attributeOverridesByFeature = new HashMap();
    private EClassFeatureMapper eClassFeatureMapper;
    private EmbeddedMapper embeddedMapper;
    private JoinColumnMapper jcMapper;
    private TableMapper tableMapper;
    private EntityNameStrategy entityNameStrategy;
    private EPackage[] epackages;
    private boolean forceOptional = false;
    private ExtensionManager extensionManager;

    public void initializeExtension() {
        this.namingHandler = (NamingHandler)this.getExtensionManager().getExtension(NamingHandler.class);
        this.otmMapper = this.createMapper(OneToManyMapper.class);
        this.mtmMapper = this.createMapper(ManyToManyMapper.class);
        this.otoMapper = this.createMapper(OneToOneMapper.class);
        this.mtoMapper = this.createMapper(ManyToOneMapper.class);
        this.inheritanceMapper = this.createMapper(InheritanceMapper.class);
        this.columnMapper = this.createMapper(ColumnMapper.class);
        this.idMapper = this.createMapper(IdMapper.class);
        this.basicMapper = this.createMapper(BasicMapper.class);
        this.manyBasicMapper = this.createMapper(ManyBasicMapper.class);
        this.eClassFeatureMapper = this.createMapper(EClassFeatureMapper.class);
        this.embeddedMapper = this.createMapper(EmbeddedMapper.class);
        this.jcMapper = this.createMapper(JoinColumnMapper.class);
        this.tableMapper = this.createMapper(TableMapper.class);
    }

    protected <T> T createMapper(Class<T> clz) {
        Object t = this.getExtensionManager().getExtension(clz);
        ((AbstractMapper)t).setMappingContext(this);
        return (T)t;
    }

    public BasicMapper getBasicMapper() {
        return this.basicMapper;
    }

    public ColumnMapper getColumnMapper() {
        return this.columnMapper;
    }

    public IdMapper getIdMapper() {
        return this.idMapper;
    }

    public InheritanceMapper getInheritanceMapper() {
        return this.inheritanceMapper;
    }

    public ManyBasicMapper getManyBasicMapper() {
        return this.manyBasicMapper;
    }

    public ManyToManyMapper getManyToManyMapper() {
        return this.mtmMapper;
    }

    public ManyToOneMapper getManyToOneMapper() {
        return this.mtoMapper;
    }

    public NamingHandler getNamingHandler() {
        return this.namingHandler;
    }

    public OneToManyMapper getOneToManyMapper() {
        return this.otmMapper;
    }

    public OneToOneMapper getOneToOneMapper() {
        return this.otoMapper;
    }

    public EClassFeatureMapper getEClassFeatureMapper() {
        return this.eClassFeatureMapper;
    }

    public void startMapping(PAnnotatedEStructuralFeature annotatedFeature) {
        this.mappedEFeatures.push(this.currentAFeature);
        this.currentAFeature = annotatedFeature;
    }

    public void endMapping(PAnnotatedEStructuralFeature aFeature) {
        assert (aFeature == this.currentAFeature);
        this.currentAFeature = (PAnnotatedEStructuralFeature)this.mappedEFeatures.pop();
    }

    public void assertEmpty() {
        assert (this.mappedEFeatures.empty());
        assert (this.attributeOverridesByFeature.isEmpty());
    }

    public EmbeddedMapper getEmbeddedMapper() {
        return this.embeddedMapper;
    }

    public JoinColumnMapper getJoinColumnMapper() {
        return this.jcMapper;
    }

    public TableMapper getTableMapper() {
        return this.tableMapper;
    }

    public PAnnotatedEClass getCurrentAClass() {
        return this.currentAClass;
    }

    public void setCurrentAClass(PAnnotatedEClass currentAClass) {
        this.currentAClass = currentAClass;
    }

    public EntityNameStrategy getEntityNameStrategy() {
        if (this.entityNameStrategy == null) {
            this.entityNameStrategy = (EntityNameStrategy)this.getExtensionManager().getExtension(EntityNameStrategy.class);
            this.entityNameStrategy.setPaModel(this.getPaModel());
        }
        return this.entityNameStrategy;
    }

    public EPackage[] getEpackages() {
        return this.epackages;
    }

    public void setEpackages(EPackage[] epackages) {
        this.epackages = epackages;
    }

    public boolean isForceOptional() {
        return this.forceOptional;
    }

    public void setForceOptional(boolean forceOptional) {
        this.forceOptional = forceOptional;
    }

    public ExtensionManager getExtensionManager() {
        return this.extensionManager;
    }

    public void setExtensionManager(ExtensionManager extensionManager) {
        this.extensionManager = extensionManager;
    }

    public PAnnotatedModel getPaModel() {
        return this.paModel;
    }

    public void setPaModel(PAnnotatedModel paModel) {
        this.paModel = paModel;
    }
}

