/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.jpox;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.Query;
import javax.jdo.listener.InstanceLifecycleListener;
import javax.jdo.spi.PersistenceCapable;
import javax.xml.datatype.Duration;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.common.util.AbstractEnumerator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.eclipse.emf.teneo.DataStore;
import org.eclipse.emf.teneo.EContainerRepairControl;
import org.eclipse.emf.teneo.ERuntime;
import org.eclipse.emf.teneo.annotations.pannotation.InheritanceType;
import org.eclipse.emf.teneo.ecore.EModelResolver;
import org.eclipse.emf.teneo.extension.ExtensionManager;
import org.eclipse.emf.teneo.jpox.JpoxHelper;
import org.eclipse.emf.teneo.jpox.JpoxStoreException;
import org.eclipse.emf.teneo.jpox.cache.EMFHardRefCache;
import org.eclipse.emf.teneo.jpox.cache.EMFNullCache;
import org.eclipse.emf.teneo.jpox.cache.EMFSoftRefCache;
import org.eclipse.emf.teneo.jpox.cache.EMFWeakRefCache;
import org.eclipse.emf.teneo.jpox.elist.AnyFeatureMapEntry;
import org.eclipse.emf.teneo.jpox.elist.EListMapping;
import org.eclipse.emf.teneo.jpox.elist.EListWrapper;
import org.eclipse.emf.teneo.jpox.elist.FeatureMapMapping;
import org.eclipse.emf.teneo.jpox.elist.FeatureMapWrapper;
import org.eclipse.emf.teneo.jpox.elist.GenericFeatureMapEntry;
import org.eclipse.emf.teneo.jpox.elist.RemoveLifeCycleListener;
import org.eclipse.emf.teneo.jpox.mapping.AnyTypeEObject;
import org.eclipse.emf.teneo.jpox.mapping.DurationMapping;
import org.eclipse.emf.teneo.jpox.mapping.ENumMapping;
import org.eclipse.emf.teneo.jpox.mapping.EObjectMapping;
import org.eclipse.emf.teneo.jpox.mapping.QNameMapping;
import org.eclipse.emf.teneo.jpox.resource.JPOXResource;
import org.eclipse.emf.teneo.type.FeatureMapEntry;
import org.eclipse.emf.teneo.util.AssertUtil;
import org.eclipse.emf.teneo.util.StoreUtil;
import org.jpox.AbstractPersistenceManagerFactory;
import org.jpox.ClassLoaderResolver;
import org.jpox.JDOClassLoaderResolver;
import org.jpox.PersistenceManagerFactoryImpl;
import org.jpox.TypeManager;
import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.metadata.AbstractPropertyMetaData;
import org.jpox.metadata.ExtensionMetaData;
import org.jpox.metadata.InheritanceStrategy;
import org.jpox.metadata.MetaDataManager;
import org.jpox.plugin.ConfigurationElement;
import org.jpox.plugin.Extension;
import org.jpox.plugin.ExtensionPoint;
import org.jpox.store.StoreManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpoxDataStore
implements DataStore {
    private static final Log log = LogFactory.getLog(JpoxDataStore.class);
    private static final Class<?> emfEnumClass = AbstractEnumerator.class;
    private static final Class<?> nextEmfEnumClass = Enumerator.class;
    private String name;
    private EPackage[] ePackages;
    private PersistenceManagerFactory pmf;
    private HashMap refersToMap;
    private Class[] storeTopClasses;
    private boolean loadContainmentEagerly;
    private final Properties properties = new Properties();
    private boolean havePropertiesBeenSet = false;
    private boolean updateSchema = false;
    private ExtensionManager extensionManager;

    JpoxDataStore() {
        this.properties.setProperty("javax.jdo.option.IgnoreCache", "false");
        this.properties.setProperty("javax.jdo.PersistenceManagerFactoryClass", "org.jpox.PersistenceManagerFactoryImpl");
        this.properties.setProperty("javax.jdo.option.RetainValues", "true");
        this.properties.setProperty("javax.jdo.option.NontransactionalRead", "true");
        this.properties.setProperty("org.jpox.rdbms.stringDefaultLength", "255");
        this.properties.setProperty("org.jpox.autoCreateSchema", "false");
        this.properties.setProperty("org.jpox.autoCreateConstraints", "false");
        this.properties.setProperty("org.jpox.autoCreateSchema", "false");
        this.properties.setProperty("org.jpox.autoCreateTables", "false");
        this.properties.setProperty("org.jpox.validateColumns", "false");
        this.properties.setProperty("org.jpox.validateConstraints", "false");
        this.properties.setProperty("org.jpox.validateTables", "false");
        this.properties.setProperty("org.jpox.persistenceByReachabilityAtCommit", "true");
        this.properties.setProperty("org.jpox.deletionPolicy", "JPOX");
        this.properties.setProperty("org.jpox.cache.level1.type", "org.eclipse.emf.teneo.jpox.cache.EMFWeakRefCache");
        this.properties.setProperty("org.jpox.metadata.jdoFileExtension", JpoxHelper.INSTANCE.getJdoFileExtension());
        this.properties.setProperty("teneo.mapping.emap_as_true_map", "false");
    }

    public final void initialize() {
        String jdoFileName;
        String[] jdoFileList;
        if (this.ePackages == null) {
            throw new JpoxStoreException("EPackages are not set");
        }
        if (this.name == null) {
            throw new JpoxStoreException("Name is not set");
        }
        if (!this.havePropertiesBeenSet) {
            throw new JpoxStoreException("Specific properties have not been set");
        }
        EModelResolver.instance().register(this.getEPackages());
        String suffix = this.properties.getProperty("org.jpox.metadata.jdoFileExtension");
        if (suffix == null) {
            suffix = "jdo";
        }
        if ((jdoFileList = StoreUtil.getFileList((String)(jdoFileName = "package." + suffix), null)).length == 0) {
            throw new JpoxStoreException("No jdo files can be found in the classpath");
        }
        Set classes = ERuntime.INSTANCE.getAllConcreteClasses();
        ArrayList<Class> pcList = new ArrayList<Class>();
        for (Class clz : classes) {
            if (!PersistenceCapable.class.isAssignableFrom(clz)) continue;
            pcList.add(clz);
        }
        String[] pcClassNames = new String[pcList.size()];
        int i = 0;
        StringBuffer classNameList = new StringBuffer();
        for (Class clz : pcList) {
            if (i > 0) {
                classNameList.append(",");
            }
            classNameList.append(clz.getName());
            pcClassNames[i++] = clz.getName();
        }
        this.createSchema(pcClassNames, this.properties);
        classNameList.append(",");
        classNameList.append(AnyTypeEObject.class.getName());
        classNameList.append(",");
        classNameList.append(AnyFeatureMapEntry.class.getName());
        this.properties.setProperty("org.jpox.autoStartMechanism", "Classes");
        this.properties.setProperty("org.jpox.autoStartClassNames", classNameList.toString());
        this.pmf = JpoxHelper.INSTANCE.getPMFCreator().getPersistenceManagerFactory(this.properties);
        this.initializeTypeManager((AbstractPersistenceManagerFactory)this.pmf);
        this.pmf.addInstanceLifecycleListener((InstanceLifecycleListener)new RemoveLifeCycleListener(), null);
        this.loadContainmentEagerly = this.properties.getProperty("teneo.mapping.fetch_containment_eagerly") != null && "true".compareTo(this.properties.getProperty("teneo.mapping.fetch_containment_eagerly")) == 0;
        MetaDataManager mdm = ((PersistenceManagerFactoryImpl)this.pmf).getPMFContext().getMetaDataManager();
        this.refersToMap = this.createRefersToMap(mdm, pcClassNames);
        JDOClassLoaderResolver clr = new JDOClassLoaderResolver();
        Class[] topClasses = ((ERuntime)EModelResolver.instance()).getTopClasses();
        ArrayList<Class> newTopClasses = new ArrayList<Class>();
        Class[] classArray = topClasses;
        int n = topClasses.length;
        int n2 = 0;
        while (n2 < n) {
            Class element = classArray[n2];
            Class concrete = ((ERuntime)EModelResolver.instance()).getInstanceClass(element);
            if (concrete != null && PersistenceCapable.class.isAssignableFrom(concrete)) {
                if (this.isMappedSuperClass(concrete, mdm, clr)) {
                    List<Class<?>> result = this.getSubClasses(concrete, mdm, clr);
                    newTopClasses.removeAll(result);
                    newTopClasses.addAll(result);
                } else if (!newTopClasses.contains(concrete)) {
                    newTopClasses.add(concrete);
                }
            }
            ++n2;
        }
        this.storeTopClasses = newTopClasses.toArray(new Class[newTopClasses.size()]);
        if (log.isInfoEnabled()) {
            log.info((Object)"Persistence manager factory created using properties: ");
            this.logProperties(this.properties);
        }
    }

    private boolean isMappedSuperClass(Class clazz, MetaDataManager mdm, JDOClassLoaderResolver clr) {
        AbstractClassMetaData amd = mdm.getMetaDataForClass(clazz, (ClassLoaderResolver)clr);
        return amd.getInheritanceMetaData().getStrategyValue().equals((Object)InheritanceStrategy.SUBCLASS_TABLE);
    }

    protected List<Class<?>> getSubClasses(Class<?> clz, MetaDataManager mdm, JDOClassLoaderResolver clr) {
        ArrayList subClasses = new ArrayList();
        String[] subs = mdm.getSubclassesForClass(clz.getName(), false);
        if (subs == null) {
            return subClasses;
        }
        String[] stringArray = subs;
        int n = subs.length;
        int n2 = 0;
        while (n2 < n) {
            String sub = stringArray[n2];
            Class subClass = org.eclipse.emf.teneo.classloader.ClassLoaderResolver.classForName((String)sub);
            if (this.isMappedSuperClass(subClass, mdm, clr)) {
                subClasses.addAll(this.getSubClasses(subClass, mdm, clr));
            } else {
                subClasses.add(subClass);
            }
            ++n2;
        }
        return subClasses;
    }

    protected void initializeTypeManager(AbstractPersistenceManagerFactory initPmf) {
        log.debug((Object)"Registering EListMapping, EListWrapper at the jpox manager for handling elists");
        log.debug((Object)"Registering FeatureMapMapping, FeatureMapWrapper at the jpox manager for handling FeatureMap");
        log.debug((Object)"Registering EObjectMapping at the jpox manager for handling EObjects/AnyType");
        log.debug((Object)"Registering XMLCalendarMapping at the jpox manager for handling EObjects/AnyType");
        log.debug((Object)"Registering XMLDurationMapping at the jpox manager for handling EObjects/AnyType");
        TypeManager tm = initPmf.getPMFContext().getTypeManager();
        ClassLoader contextLoader = org.eclipse.emf.teneo.classloader.ClassLoaderResolver.getClassLoader();
        ClassLoaderResolver clr = initPmf.getPMFContext().getClassLoaderResolver(contextLoader);
        log.debug((Object)"Registering level 1 Cache Implementations");
        ExtensionPoint ep = initPmf.getPMFContext().getPluginManager().getExtensionPoint("org.jpox.cache_level1");
        Extension extension = new Extension(ep, ep.getPlugin());
        ep.addExtension(extension);
        ConfigurationElement ce1 = new ConfigurationElement(extension, "cache", null);
        ce1.putAttribute("name", EMFWeakRefCache.class.getName());
        ce1.putAttribute("class-name", EMFWeakRefCache.class.getName());
        extension.addConfigurationElement(ce1);
        log.debug((Object)("Registered " + EMFWeakRefCache.class.getName()));
        ConfigurationElement ce2 = new ConfigurationElement(extension, "cache", null);
        ce2.putAttribute("name", EMFHardRefCache.class.getName());
        ce2.putAttribute("class-name", EMFHardRefCache.class.getName());
        extension.addConfigurationElement(ce2);
        log.debug((Object)("Registered " + EMFHardRefCache.class.getName()));
        ConfigurationElement ce3 = new ConfigurationElement(extension, "cache", null);
        ce3.putAttribute("name", EMFNullCache.class.getName());
        ce3.putAttribute("class-name", EMFNullCache.class.getName());
        extension.addConfigurationElement(ce3);
        log.debug((Object)("Registered " + EMFNullCache.class.getName()));
        ConfigurationElement ce4 = new ConfigurationElement(extension, "cache", null);
        ce4.putAttribute("name", EMFSoftRefCache.class.getName());
        ce4.putAttribute("class-name", EMFSoftRefCache.class.getName());
        extension.addConfigurationElement(ce4);
        log.debug((Object)("Registered " + EMFSoftRefCache.class.getName()));
        ExtensionPoint mappingEP = initPmf.getPMFContext().getPluginManager().getExtensionPoint("org.jpox.store_mapping");
        Extension mappingExt = new Extension(mappingEP, mappingEP.getPlugin());
        mappingEP.addExtension(mappingExt);
        ConfigurationElement mce = new ConfigurationElement(extension, "mapping", null);
        mce.putAttribute("java-type", QName.class.getName());
        mce.putAttribute("mapping-class", QNameMapping.class.getName());
        mappingExt.addConfigurationElement(mce);
        ConfigurationElement mce2 = new ConfigurationElement(extension, "mapping", null);
        mce2.putAttribute("java-type", Duration.class.getName());
        mce2.putAttribute("mapping-class", DurationMapping.class.getName());
        tm.addType(initPmf.getPMFContext().getPluginManager(), "org.jpox.store_mapping", List.class.getName(), EListMapping.class.getName(), EListWrapper.class.getName(), false, "1.4", true, false, false, clr);
        tm.addType(initPmf.getPMFContext().getPluginManager(), "org.jpox.store_mapping", EList.class.getName(), EListMapping.class.getName(), EListWrapper.class.getName(), false, "1.4", true, false, false, clr);
        tm.addType(initPmf.getPMFContext().getPluginManager(), "org.jpox.store_mapping", EMap.class.getName(), EListMapping.class.getName(), EListWrapper.class.getName(), false, "1.4", true, false, false, clr);
        tm.addType(initPmf.getPMFContext().getPluginManager(), "org.jpox.store_mapping", FeatureMap.class.getName(), FeatureMapMapping.class.getName(), FeatureMapWrapper.class.getName(), false, "1.4", true, false, false, clr);
        tm.addType(initPmf.getPMFContext().getPluginManager(), "org.jpox.store_mapping", EObject.class.getName(), EObjectMapping.class.getName(), null, true, "1.4", true, false, true, clr);
        this.addCustomTypes(initPmf, clr);
        int i = 0;
        while (i < this.getEPackages().length) {
            EPackage epack = this.getEPackages()[i];
            for (EClassifier eclassifier : epack.getEClassifiers()) {
                Class instanceClass = eclassifier.getInstanceClass();
                if (!emfEnumClass.isAssignableFrom(instanceClass) && !nextEmfEnumClass.isAssignableFrom(instanceClass)) continue;
                log.debug((Object)("Registering enum type mapper/wrapper for eclass: " + instanceClass.getName()));
                tm.addType(initPmf.getPMFContext().getPluginManager(), "org.jpox.store_mapping", instanceClass.getName(), ENumMapping.class.getName(), null, true, "1.4", true, false, true, clr);
            }
            ++i;
        }
    }

    protected void addCustomTypes(AbstractPersistenceManagerFactory initPmf, ClassLoaderResolver clr) {
    }

    public boolean isContainedObject(Object obj) {
        ArrayList referers = (ArrayList)this.refersToMap.get(obj.getClass());
        if (referers == null || referers.size() == 0) {
            return false;
        }
        int i = 0;
        while (i < referers.size()) {
            ReferenceTo refTo = (ReferenceTo)referers.get(i);
            if (refTo.isContainer()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public EPackage[] getEPackages() {
        return this.ePackages;
    }

    public PersistenceManagerFactory getPMF() {
        return this.pmf;
    }

    public void close() {
        if (this.pmf == null) {
            return;
        }
        if (this.pmf.isClosed()) {
            return;
        }
        org.jpox.PersistenceManager pm = (org.jpox.PersistenceManager)this.pmf.getPersistenceManager();
        StoreManager store_mgr = pm.getStoreManager();
        store_mgr.close();
        pm.close();
        this.pmf.close();
    }

    public Class getInstanceClass(Class interf) {
        return ((ERuntime)EModelResolver.instance()).getInstanceClass(interf);
    }

    public String[] getTopClasses() {
        String[] topClasses = new String[this.storeTopClasses.length];
        int i = 0;
        while (i < this.storeTopClasses.length) {
            topClasses[i] = this.storeTopClasses[i].getName();
            ++i;
        }
        return topClasses;
    }

    public void importDataStore(InputStream is, int importFormat) {
        Object importResource = importFormat == 0 ? new XMLResourceImpl() : new XMIResourceImpl();
        JPOXResource jpoxResource = new JPOXResource(URI.createFileURI((String)("." + this.name)));
        try {
            importResource.load(is, Collections.EMPTY_MAP);
            jpoxResource.getContents().addAll((Collection)importResource.getContents());
            jpoxResource.save(Collections.EMPTY_MAP);
        }
        catch (IOException e) {
            throw new JpoxStoreException("Exception when exporting " + this.name, e);
        }
    }

    public void exportDataStore(OutputStream os, int exportFormat, String encoding) {
        JPOXResource jpoxResource = new JPOXResource(URI.createFileURI((String)("." + this.name)));
        jpoxResource.load(Collections.EMPTY_MAP);
        try {
            Object exportResource = exportFormat == 0 ? new XMLResourceImpl() : new XMIResourceImpl();
            exportResource.getContents().addAll((Collection)jpoxResource.getContents());
            HashMap<String, String> options = new HashMap<String, String>();
            if (encoding != null) {
                options.put("ENCODING", encoding);
            }
            exportResource.save(os, options);
            jpoxResource.unload();
        }
        catch (IOException e) {
            throw new JpoxStoreException("Exception when exporting " + this.name, e);
        }
    }

    protected void createSchema(String[] pcClassNames, Properties origProps) {
        if (!this.updateSchema) {
            log.debug((Object)"Update of the database schema has been disabled returning");
            return;
        }
        log.debug((Object)"Updating database schema");
        Properties newProps = (Properties)origProps.clone();
        newProps.setProperty("org.jpox.autoCreateColumns", "true");
        newProps.setProperty("org.jpox.autoCreateSchema", "true");
        newProps.setProperty("org.jpox.validateColumns", "true");
        newProps.setProperty("org.jpox.validateConstraints", "true");
        newProps.setProperty("org.jpox.validateTables", "true");
        PersistenceManagerFactory localPmf = JpoxHelper.INSTANCE.getPMFCreator().getPersistenceManagerFactory(newProps);
        this.initializeTypeManager((AbstractPersistenceManagerFactory)localPmf);
        org.jpox.PersistenceManager pm = (org.jpox.PersistenceManager)localPmf.getPersistenceManager();
        StoreManager store_mgr = pm.getStoreManager();
        try {
            store_mgr.addClasses(pcClassNames, pm.getClassLoaderResolver(), null);
        }
        finally {
            pm.close();
            localPmf.close();
        }
    }

    private void logProperties(Properties props) {
        for (String string : props.keySet()) {
            log.info((Object)(String.valueOf(string) + ": " + props.get(string)));
        }
    }

    public Object[] getCrossReferencers(PersistenceManager pm, Object referedTo) {
        ArrayList result = this.getCrossReferencers(pm, referedTo, false);
        return result.toArray(new Object[result.size()]);
    }

    public EObject getContainer(PersistenceManager pm, EObject referedTo) {
        ArrayList result = this.getCrossReferencers(pm, referedTo, true);
        if (result.size() == 1) {
            return (EObject)result.get(0);
        }
        if (result.size() == 0) {
            return null;
        }
        throw new JpoxStoreException("To many containers found for EObject: " + referedTo.getClass().getName() + " total: " + result.size());
    }

    private ArrayList getCrossReferencers(PersistenceManager pm, Object referedTo, boolean onlyContainers) {
        ArrayList refersList = (ArrayList)this.refersToMap.get(referedTo.getClass());
        if (refersList == null || refersList.size() == 0) {
            return new ArrayList();
        }
        ArrayList result = new ArrayList();
        int i = 0;
        while (i < refersList.size()) {
            ReferenceTo refersTo = (ReferenceTo)refersList.get(i);
            if (!onlyContainers || refersTo.isContainer()) {
                Query qry = pm.newQuery(refersTo.getQueryStr());
                for (Object obj : (List)qry.execute(referedTo)) {
                    if (obj instanceof FeatureMapEntry) {
                        ArrayList fms = this.getCrossReferencers(pm, obj, false);
                        if (fms.size() == 0) {
                            new AssertionError((Object)("The featuremap for featuremap entry " + obj.getClass().getName() + " can not be found"));
                        }
                        obj = fms.get(0);
                    }
                    if (result.contains(obj)) continue;
                    result.add(obj);
                }
            }
            ++i;
        }
        return result;
    }

    public boolean setContainer(PersistenceManager pm, EObject child) {
        if (child.eContainer() != null) {
            log.warn((Object)("Container property of " + child.getClass().getName() + " already set to a class: " + child.eContainer().getClass().getName() + ". This method should better only be used to " + "initialize the container property and not to overwrite. Returning without doing anything"));
            return false;
        }
        ArrayList refersList = (ArrayList)this.refersToMap.get(child.getClass());
        if (refersList == null || refersList.size() == 0) {
            return false;
        }
        int i = 0;
        while (i < refersList.size()) {
            ReferenceTo refersTo = (ReferenceTo)refersList.get(i);
            if (refersTo.isContainer()) {
                Query qry = pm.newQuery(refersTo.getQueryStr());
                List list = (List)qry.execute((Object)child);
                EStructuralFeature esf = refersTo.getStructuralFeature();
                if (list.size() == 1) {
                    Object obj = list.get(0);
                    EContainerRepairControl.setContainer((InternalEObject)((InternalEObject)obj), (InternalEObject)((InternalEObject)child), (EStructuralFeature)esf);
                    return true;
                }
                if (list.size() > 1) {
                    throw new AssertionError((Object)("The eobject " + child.getClass().getName() + " is contained by multiple other objects through the feature " + esf.getName() + " of " + refersTo.getFromClass().getName()));
                }
            }
            ++i;
        }
        return false;
    }

    private HashMap createRefersToMap(MetaDataManager mdm, String[] allClassNames) {
        JDOClassLoaderResolver clr = new JDOClassLoaderResolver();
        try {
            Class[] allClasses = new Class[allClassNames.length];
            HashMap result = new HashMap();
            int i = 0;
            while (i < allClasses.length) {
                allClasses[i] = org.eclipse.emf.teneo.classloader.ClassLoaderResolver.classForName((String)allClassNames[i]);
                result.put(allClasses[i], new ArrayList());
                ++i;
            }
            Class[] classArray = allClasses;
            int n = allClasses.length;
            int n2 = 0;
            while (n2 < n) {
                Class element = classArray[n2];
                AbstractClassMetaData cmd = mdm.getMetaDataForClass(element, (ClassLoaderResolver)clr);
                if (!cmd.isEmbeddedOnly()) {
                    int j = 0;
                    while (j < cmd.getNoOfFields()) {
                        AbstractPropertyMetaData fld = cmd.getField(j);
                        this.createRefersToFromField(fld, element, result, false, fld.getName());
                        ++j;
                    }
                }
                ++n2;
            }
            Iterator keyIt = result.keySet().iterator();
            ArrayList classDone = new ArrayList();
            while (keyIt.hasNext()) {
                this.setRefersToOfSupers((Class)keyIt.next(), result, classDone);
            }
            return result;
        }
        catch (Exception e) {
            throw new JpoxStoreException("Exception when determining refers to", e);
        }
    }

    private void createRefersToFromField(AbstractPropertyMetaData fld, Class fromClass, HashMap result, boolean isFeatureMapField, String propName) {
        boolean isMany = false;
        boolean isContained = false;
        Class[] toClasses = null;
        String[] featureNames = null;
        featureNames = this.getFeatureNames(fld);
        if (fld.getCollection() != null) {
            isMany = true;
            isContained = fld.getCollection().isDependentElement();
            Class toClass = org.eclipse.emf.teneo.classloader.ClassLoaderResolver.classForName((String)fld.getCollection().getElementType());
            if (GenericFeatureMapEntry.class.isAssignableFrom(toClass)) {
                AbstractPropertyMetaData[] fmds;
                AbstractPropertyMetaData[] abstractPropertyMetaDataArray = fmds = fld.getElementMetaData().getEmbeddedMetaData().getFieldMetaData();
                int n = fmds.length;
                int n2 = 0;
                while (n2 < n) {
                    AbstractPropertyMetaData fmd = abstractPropertyMetaDataArray[n2];
                    this.createRefersToFromField(fmd, fromClass, result, true, propName);
                    ++n2;
                }
                return;
            }
            if (fld.getExtensions() != null) {
                toClasses = this.getImplementationClasses(fld);
            }
            if (toClasses == null) {
                toClasses = new Class[]{toClass};
            }
        } else {
            if (fld.getExtensions() != null) {
                toClasses = this.getImplementationClasses(fld);
            }
            if (toClasses == null) {
                if (!fld.isFieldTypePersistenceCapable()) {
                    return;
                }
                toClasses = new Class[]{fld.getType()};
            }
            isContained = fld.isDependent();
        }
        if (this.loadContainmentEagerly && isContained) {
            fld.getContainer().addExtension("cache-lazy-loading", "false");
        }
        int c = 0;
        while (c < toClasses.length) {
            ArrayList list;
            AssertUtil.assertTrue((String)"Feature names and toclasses should have the same number of elements", (toClasses.length == featureNames.length ? 1 : 0) != 0);
            Class tclass = toClasses[c];
            if (tclass.isInterface() && EObject.class.isAssignableFrom(tclass) && (tclass = this.getInstanceClass(tclass)) == null) {
                log.debug((Object)("Ignoring " + toClasses[c].getName() + " for computation of referencing classes because it has no concrete implementor"));
            } else if (PersistenceCapable.class.isAssignableFrom(tclass) && (list = (ArrayList)result.get(tclass)) != null) {
                list.add(new ReferenceTo(fromClass, tclass, propName, featureNames[c], isContained, isMany, isFeatureMapField));
            }
            ++c;
        }
    }

    private String[] getFeatureNames(AbstractPropertyMetaData fld) {
        String[] features = this.getSplittedExtension(fld, "estructuralfeatures");
        if (features != null) {
            return features;
        }
        return new String[]{fld.getName()};
    }

    private Class[] getImplementationClasses(AbstractPropertyMetaData fld) {
        Class[] toClasses = null;
        String[] classes = this.getSplittedExtension(fld, "implementation-classes");
        if (classes == null) {
            return null;
        }
        toClasses = new Class[classes.length];
        int c = 0;
        while (c < classes.length) {
            toClasses[c] = this.resolveClass(classes[c]);
            ++c;
        }
        return toClasses;
    }

    private String[] getSplittedExtension(AbstractPropertyMetaData fld, String extension) {
        if (fld.getExtensions() == null) {
            return null;
        }
        int i = 0;
        while (i < fld.getExtensions().length) {
            ExtensionMetaData emd = fld.getExtension(i);
            if (emd.getKey().compareTo(extension) == 0 && emd.getValue() != null && emd.getValue().length() > 0) {
                return emd.getValue().split(",");
            }
            ++i;
        }
        return null;
    }

    private Class resolveClass(String className) {
        if (className.compareTo("boolean") == 0) {
            return Boolean.TYPE;
        }
        if (className.compareTo("byte") == 0) {
            return Byte.TYPE;
        }
        if (className.compareTo("char") == 0) {
            return Character.TYPE;
        }
        if (className.compareTo("short") == 0) {
            return Short.TYPE;
        }
        if (className.compareTo("int") == 0) {
            return Integer.TYPE;
        }
        if (className.compareTo("long") == 0) {
            return Long.TYPE;
        }
        if (className.compareTo("float") == 0) {
            return Float.TYPE;
        }
        if (className.compareTo("double") == 0) {
            return Double.TYPE;
        }
        return org.eclipse.emf.teneo.classloader.ClassLoaderResolver.classForName((String)className);
    }

    private ArrayList setRefersToOfSupers(Class clazz, HashMap refersTo, ArrayList classDone) {
        Class<?>[] interfs;
        if (classDone.contains(clazz)) {
            return (ArrayList)refersTo.get(clazz);
        }
        ArrayList thisList = (ArrayList)refersTo.get(clazz);
        if (thisList == null) {
            return new ArrayList();
        }
        if (clazz.getSuperclass() != null) {
            this.addUnique(thisList, this.setRefersToOfSupers(clazz.getSuperclass(), refersTo, classDone));
        }
        Class<?>[] classArray = interfs = clazz.getInterfaces();
        int n = interfs.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> element = classArray[n2];
            this.addUnique(thisList, (ArrayList)refersTo.get(element));
            ++n2;
        }
        classDone.add(clazz);
        return thisList;
    }

    private void addUnique(ArrayList l1, ArrayList l2) {
        if (l2 == null) {
            return;
        }
        for (Object obj : l2) {
            if (l1.contains(obj)) continue;
            l1.add(obj);
        }
    }

    public void setEPackages(EPackage[] ePackages) {
        this.ePackages = ePackages;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties props) {
        this.properties.putAll((Map<?, ?>)props);
        if (props.get("teneo.mapping.inheritance") != null) {
            log.debug((Object)("Option teneo.mapping.inheritance is set to: " + props.getProperty("teneo.mapping.inheritance") + " translating to option " + "org.jpox.rdbms.defaultInheritanceStrategy"));
            String inheritanceMapping = props.getProperty("teneo.mapping.inheritance");
            if (InheritanceType.get((String)inheritanceMapping) == InheritanceType.JOINED) {
                this.properties.put("org.jpox.rdbms.defaultInheritanceStrategy", "JPOX");
                log.debug((Object)"Option inheritance: JPOX");
            } else if (InheritanceType.get((String)inheritanceMapping) == InheritanceType.SINGLE_TABLE) {
                this.properties.put("org.jpox.rdbms.defaultInheritanceStrategy", "JDO2");
                log.debug((Object)"Option inheritance: JDO2");
            } else {
                throw new IllegalArgumentException("Inheritance mapping option: " + inheritanceMapping + " is not supported");
            }
        }
        this.updateSchema = props.get("teneo.runtime.update_schema") == null || props.getProperty("teneo.runtime.update_schema").compareTo("true") == 0;
        log.debug((Object)("Option updateschema: " + this.updateSchema));
        this.havePropertiesBeenSet = true;
    }

    public ExtensionManager getExtensionManager() {
        return this.extensionManager;
    }

    public void setExtensionManager(ExtensionManager extensionManager) {
        this.extensionManager = extensionManager;
    }

    public class ReferenceTo {
        private final Class fromClass;
        private final String name;
        private final boolean isContainer;
        private final boolean isMany;
        private final String qryStr;
        private final EStructuralFeature structuralFeature;

        public ReferenceTo(Class theFromClass, Class theToClass, String propName, String featureName, boolean myIsContainer, boolean myIsMany, boolean isFeatureMapEntryField) {
            this.fromClass = theFromClass;
            this.name = propName;
            this.isContainer = myIsContainer;
            this.isMany = myIsMany;
            this.qryStr = isFeatureMapEntryField ? "SELECT FROM " + this.fromClass.getName() + " WHERE " + this.name + ".contains(gfme) && gfme.localReferenceValue==:toObject " + "VARIABLES " + GenericFeatureMapEntry.class.getName() + " gfme" : (this.isMany ? "SELECT FROM " + this.fromClass.getName() + " WHERE " + this.name + ".contains(:toObject)" : "SELECT FROM " + this.fromClass.getName() + " WHERE " + this.name + " == :toObject");
            if (this.isContainer) {
                EClass eclass = EModelResolver.instance().getEClass(this.fromClass);
                assert (eclass != null);
                this.structuralFeature = StoreUtil.getEStructuralFeature((EClass)eclass, (String)featureName);
            } else {
                this.structuralFeature = null;
            }
        }

        public boolean isContainer() {
            return this.isContainer;
        }

        public Class getFromClass() {
            return this.fromClass;
        }

        public EStructuralFeature getStructuralFeature() {
            AssertUtil.assertTrue((String)("The getstructural feature may only be called for containment relations. " + this.name + " of " + this.fromClass.getClass().getName() + " is not a containment relation."), (boolean)this.isContainer);
            return this.structuralFeature;
        }

        public String getQueryStr() {
            return this.qryStr;
        }
    }
}

