/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.query.tests;

import java.util.ArrayList;
import java.util.Collection;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.examples.extlibrary.Book;
import org.eclipse.emf.examples.extlibrary.EXTLibraryFactory;
import org.eclipse.emf.examples.extlibrary.EXTLibraryPackage;
import org.eclipse.emf.examples.extlibrary.Library;
import org.eclipse.emf.examples.extlibrary.Writer;
import org.eclipse.emf.query.conditions.Condition;
import org.eclipse.emf.query.conditions.Not;
import org.eclipse.emf.query.conditions.ObjectInstanceCondition;
import org.eclipse.emf.query.conditions.booleans.BooleanCondition;
import org.eclipse.emf.query.conditions.eobjects.EObjectCondition;
import org.eclipse.emf.query.conditions.eobjects.EObjectTypeRelationCondition;
import org.eclipse.emf.query.conditions.eobjects.structuralfeatures.EObjectAttributeValueCondition;
import org.eclipse.emf.query.conditions.eobjects.structuralfeatures.EObjectReferenceValueCondition;
import org.eclipse.emf.query.conditions.eobjects.structuralfeatures.EStructuralFeatureValueGetter;
import org.eclipse.emf.query.conditions.eobjects.structuralfeatures.IEStructuralFeatureValueGetter;
import org.eclipse.emf.query.conditions.strings.StringValue;
import org.eclipse.emf.query.internal.statements.QueryStatement;
import org.eclipse.emf.query.statements.FROM;
import org.eclipse.emf.query.statements.IQueryResult;
import org.eclipse.emf.query.statements.SELECT;
import org.eclipse.emf.query.statements.WHERE;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EMFQueryTest
extends TestCase {
    private Collection<EObject> modelElements;
    private Library library;
    private Book instance_Book1;
    private Resource resource;
    protected IEStructuralFeatureValueGetter eStructuralFeatureValueGetter;
    private EClass book_EClass;
    private EAttribute title_EAttribute;
    private EAttribute name_EAttribute;
    private EReference author_EReference;

    public static void main(String[] args) {
        TestRunner.run((Test)EMFQueryTest.suite());
    }

    public static Test suite() {
        return new TestSuite(EMFQueryTest.class);
    }

    public EMFQueryTest(String name) {
        super(name);
    }

    protected IEStructuralFeatureValueGetter getEStructuralFeatureValueGetter() {
        if (this.eStructuralFeatureValueGetter == null) {
            this.eStructuralFeatureValueGetter = EStructuralFeatureValueGetter.getInstance();
        }
        return this.eStructuralFeatureValueGetter;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.modelElements = new ArrayList<EObject>();
        this.modelElements.add((EObject)this.getLibrary());
        this.book_EClass = EXTLibraryPackage.Literals.BOOK;
        this.title_EAttribute = EXTLibraryPackage.Literals.BOOK__TITLE;
        this.name_EAttribute = EXTLibraryPackage.Literals.PERSON__LAST_NAME;
        this.author_EReference = EXTLibraryPackage.Literals.BOOK__AUTHOR;
    }

    protected void tearDown() throws Exception {
        this.resource = null;
        super.tearDown();
    }

    private void logicalOperatorsTesting() {
        BooleanCondition FALSE = new BooleanCondition(false){

            public boolean isSatisfied(Object object) {
                return false;
            }
        };
        BooleanCondition TRUE = new BooleanCondition(true){

            public boolean isSatisfied(Object object) {
                return true;
            }
        };
        boolean res_1 = this.False() && this.False() || this.TRUE();
        boolean res_2 = FALSE.AND((Condition)FALSE).OR((Condition)TRUE).isSatisfied(null);
        EMFQueryTest.assertEquals((boolean)res_1, (boolean)res_2);
        EMFQueryTest.assertTrue((boolean)res_1);
        res_1 = this.False() && (this.False() || this.TRUE());
        res_2 = FALSE.AND(FALSE.OR((Condition)TRUE)).isSatisfied(null);
        EMFQueryTest.assertEquals((boolean)res_1, (boolean)res_2);
        EMFQueryTest.assertFalse((boolean)res_1);
    }

    private boolean False() {
        return false;
    }

    private boolean TRUE() {
        return true;
    }

    public void test_EMFQuery() {
        this.logicalOperatorsTesting();
        IQueryResult resultSet = this.getBookInstances_TitledQuery(1, "Book1").execute();
        EMFQueryTest.assertTrue((resultSet.size() == 1 ? 1 : 0) != 0);
        this.instance_Book1 = (Book)resultSet.toArray()[0];
        Book bbb = this.getBookTitled_InstanceBruteForce("Book1");
        EMFQueryTest.assertTrue((boolean)bbb.equals(this.instance_Book1));
        resultSet = this.getAllBooksQuery().execute();
        EMFQueryTest.assertTrue((resultSet.size() == 6 ? 1 : 0) != 0);
        resultSet = this.getBookInstances_NOT_TitledQuery("Book2").execute();
        EMFQueryTest.assertTrue((resultSet.size() == 5 ? 1 : 0) != 0);
        resultSet = this.getBookInstances_TitledQuery(1, "BookFoo").execute();
        EMFQueryTest.assertTrue((resultSet.size() == 1 ? 1 : 0) != 0);
        resultSet = this.getBooksWithAuthorNamedQuery("foo").execute();
        EMFQueryTest.assertTrue((resultSet.getException() == null ? 1 : 0) != 0);
        EMFQueryTest.assertTrue((resultSet.size() == 0 ? 1 : 0) != 0);
        resultSet = this.getBooksWithAuthorNamedQuery("Doe").execute();
        EMFQueryTest.assertTrue((resultSet.size() == 1 ? 1 : 0) != 0);
    }

    public void test_QueryStatementExceptionHandling() {
        final RuntimeException exception = new RuntimeException();
        QueryStatement statement = new QueryStatement(false, (IProgressMonitor)new NullProgressMonitor()){

            public boolean canBeResumed() {
                return false;
            }

            protected void doExecute() {
                throw exception;
            }

            protected void doResume() {
                this.doExecute();
            }
        };
        final boolean[] addedLogEntry = new boolean[]{false};
        ILogListener logListener = new ILogListener(){

            public void logging(IStatus status, String plugin) {
                if (status.getException() == exception) {
                    addedLogEntry[0] = true;
                }
            }
        };
        Platform.addLogListener((ILogListener)logListener);
        EMFQueryTest.assertEquals((Object)statement.execute().getException(), (Object)exception);
        Platform.removeLogListener((ILogListener)logListener);
        EMFQueryTest.assertTrue((boolean)addedLogEntry[0]);
    }

    public void test_EAttributeDefaultHandling_RATLC00536311() {
        Book b = EXTLibraryFactory.eINSTANCE.createBook();
        EAttribute categoryAttribute = EXTLibraryPackage.eINSTANCE.getBook_Category();
        SELECT s = new SELECT(new FROM((EObject)b), new WHERE((EObjectCondition)new EObjectAttributeValueCondition(categoryAttribute, (Condition)new ObjectInstanceCondition(categoryAttribute.getDefaultValue()), EStructuralFeatureValueGetter.getInstance())));
        IQueryResult result = s.execute();
        EMFQueryTest.assertNull((Object)result.getException());
        EMFQueryTest.assertEquals((int)1, (int)result.getEObjects().size());
    }

    private QueryStatement getBooksWithAuthorNamedQuery(String lastName) {
        return new SELECT(new FROM(this.getQueryObjects()), new WHERE(new EObjectTypeRelationCondition(this.book_EClass).AND((EObjectCondition)new EObjectReferenceValueCondition(this.author_EReference, (EObjectCondition)new EObjectAttributeValueCondition(this.name_EAttribute, (Condition)new StringValue(lastName), this.getEStructuralFeatureValueGetter()), this.getEStructuralFeatureValueGetter()))));
    }

    private QueryStatement getBookInstances_TitledQuery(int maxCount, String bookTitle) {
        return new SELECT(maxCount, new FROM(this.getQueryObjects()), new WHERE(new EObjectTypeRelationCondition(this.book_EClass).AND((EObjectCondition)new EObjectAttributeValueCondition(this.title_EAttribute, (Condition)new StringValue(bookTitle), this.getEStructuralFeatureValueGetter()))));
    }

    private QueryStatement getAllBooksQuery() {
        return new SELECT(new FROM(this.getQueryObjects()), new WHERE((EObjectCondition)new EObjectTypeRelationCondition(this.book_EClass)));
    }

    private QueryStatement getBookInstances_NOT_TitledQuery(String bookTitle) {
        return new SELECT(new FROM(this.getQueryObjects()), new WHERE((EObjectCondition)new EObjectAttributeValueCondition((EObjectCondition)new EObjectTypeRelationCondition(this.book_EClass), this.title_EAttribute, (Condition)new Not((Condition)new StringValue(bookTitle)), this.getEStructuralFeatureValueGetter())));
    }

    private Book getBookTitled_InstanceBruteForce(final String title) {
        SELECT statement = new SELECT(new FROM(this.getQueryObjects()), new WHERE(new EObjectCondition(){
            private boolean shouldPrune;

            public boolean shouldPrune(EObject object) {
                return this.shouldPrune;
            }

            public boolean isSatisfied(EObject element) {
                if (element instanceof Book && ((Book)element).getTitle().equals(title)) {
                    this.shouldPrune = true;
                    return true;
                }
                return false;
            }
        }));
        IQueryResult resultSet = statement.execute();
        this.instance_Book1 = resultSet.isEmpty() ? null : resultSet.toArray(new Book[resultSet.size()])[0];
        return this.instance_Book1;
    }

    private Resource getResource() {
        if (this.resource == null) {
            this.resource = new ResourceImpl(URI.createURI((String)"foo:///foo.xml"));
            EList contents = this.resource.getContents();
            Library l = EXTLibraryFactory.eINSTANCE.createLibrary();
            l.setName("New Library");
            contents.add(l);
            int i = 1;
            while (i <= 5) {
                Book book = EXTLibraryFactory.eINSTANCE.createBook();
                book.setTitle("Book" + i);
                l.getBooks().add((Object)book);
                ++i;
            }
            Book book = EXTLibraryFactory.eINSTANCE.createBook();
            book.setTitle("BookFoo");
            l.getBooks().add((Object)book);
            Writer writer = EXTLibraryFactory.eINSTANCE.createWriter();
            writer.setName("John Doe");
            l.getWriters().add((Object)writer);
            book.setAuthor(writer);
            writer = EXTLibraryFactory.eINSTANCE.createWriter();
            writer.setName("Richard Roe");
            l.getWriters().add((Object)writer);
        }
        return this.resource;
    }

    private Library getLibrary() {
        if (this.library == null) {
            this.library = (Library)this.getResource().getContents().get(0);
        }
        return this.library;
    }

    private Collection<EObject> getQueryObjects() {
        return this.modelElements;
    }
}

