/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.uml2.tests.implications;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import java.io.IOException;
import java.util.Arrays;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.merge.BatchMerger;
import org.eclipse.emf.compare.uml2.tests.AbstractUMLInputData;
import org.eclipse.emf.compare.uml2.tests.AbstractUMLTest;
import org.eclipse.emf.compare.uml2.tests.implications.data.ImplicationsInputData;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.resource.Resource;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ImplicationsTransitionTest
extends AbstractUMLTest {
    private static final int NB_DIFFS = 6;
    private ImplicationsInputData input = new ImplicationsInputData();

    @BeforeClass
    public static void setupClass() {
        ImplicationsTransitionTest.fillRegistries();
    }

    @AfterClass
    public static void teardownClass() {
        ImplicationsTransitionTest.resetRegistries();
    }

    private DiffsOfInterest getDiffs(Comparison comparison, AbstractUMLTest.TestKind kind) {
        EList differences = comparison.getDifferences();
        Predicate addTransitionDescription = null;
        Predicate addPreConditionDescription = null;
        Predicate addOwnedRuleDescription = null;
        Predicate addGuardDescription = null;
        if (kind.equals((Object)AbstractUMLTest.TestKind.DELETE)) {
            addTransitionDescription = EMFComparePredicates.removed((String)"model.StateMachine0.Region0.transition1");
            addPreConditionDescription = EMFComparePredicates.changedReference((String)"model.StateMachine0.Region0.transition1", (String)"preCondition", (String)"model.StateMachine0.Region0.transition1.rule1", null);
            addOwnedRuleDescription = EMFComparePredicates.removedFromReference((String)"model.StateMachine0.Region0.transition1", (String)"ownedRule", (String)"model.StateMachine0.Region0.transition1.rule1");
            addGuardDescription = EMFComparePredicates.changedReference((String)"model.StateMachine0.Region0.transition1", (String)"guard", (String)"model.StateMachine0.Region0.transition1.rule1", null);
        } else {
            addTransitionDescription = EMFComparePredicates.added((String)"model.StateMachine0.Region0.transition1");
            addPreConditionDescription = EMFComparePredicates.changedReference((String)"model.StateMachine0.Region0.transition1", (String)"preCondition", null, (String)"model.StateMachine0.Region0.transition1.rule1");
            addOwnedRuleDescription = EMFComparePredicates.addedToReference((String)"model.StateMachine0.Region0.transition1", (String)"ownedRule", (String)"model.StateMachine0.Region0.transition1.rule1");
            addGuardDescription = EMFComparePredicates.changedReference((String)"model.StateMachine0.Region0.transition1", (String)"guard", null, (String)"model.StateMachine0.Region0.transition1.rule1");
        }
        DiffsOfInterest diffs = new DiffsOfInterest();
        diffs.addTransition = (Diff)Iterators.find(differences.iterator(), (Predicate)addTransitionDescription, null);
        diffs.addPrecondition = (Diff)Iterators.find(differences.iterator(), (Predicate)addPreConditionDescription, null);
        diffs.addOwnedRule = (Diff)Iterators.find(differences.iterator(), (Predicate)addOwnedRuleDescription, null);
        diffs.addGuard = (Diff)Iterators.find(differences.iterator(), (Predicate)addGuardDescription, null);
        return diffs;
    }

    @Test
    public void testA10UseCase() throws IOException {
        Resource left = this.input.getA2Left();
        Resource right = this.input.getA2Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right);
        this.testAB1(AbstractUMLTest.TestKind.ADD, comparison);
    }

    @Test
    public void testA10UseCase3way1() throws IOException {
        Resource left = this.input.getA2Left();
        Resource right = this.input.getA2Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)right);
        this.testAB1(AbstractUMLTest.TestKind.ADD, comparison);
    }

    @Test
    public void testA10UseCase3way2() throws IOException {
        Resource left = this.input.getA2Right();
        Resource right = this.input.getA2Left();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)left);
        this.testAB1(AbstractUMLTest.TestKind.ADD, comparison);
    }

    @Test
    public void testA10MergeLtR1UseCase() throws IOException {
        Resource left = this.input.getA2Left();
        Resource right = this.input.getA2Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.ADD);
        new BatchMerger(this.getMergerRegistry()).copyAllLeftToRight(Arrays.asList(diffs.addPrecondition), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right);
        diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.ADD);
        this.checkMergeAddPrecondition(comparison, diffs);
    }

    private void checkMergeAddPrecondition(Comparison comparison, DiffsOfInterest diffs) {
        Assert.assertEquals((long)2L, (long)comparison.getDifferences().size());
        Assert.assertNull((Object)diffs.addPrecondition);
        Assert.assertNull((Object)diffs.addGuard);
        Assert.assertNull((Object)diffs.addOwnedRule);
        Assert.assertNull((Object)diffs.addTransition);
    }

    @Test
    public void testA10MergeLtR1UseCase3way1() throws IOException {
        Resource left = this.input.getA2Left();
        Resource right = this.input.getA2Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)right);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.ADD);
        new BatchMerger(this.getMergerRegistry()).copyAllLeftToRight(Arrays.asList(diffs.addPrecondition), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right);
        diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.ADD);
        this.checkMergeAddPrecondition(comparison, diffs);
    }

    @Test
    public void testA10MergeLtR1UseCase3way2() throws IOException {
        Resource left = this.input.getA2Right();
        Resource right = this.input.getA2Left();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)left);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.ADD);
        new BatchMerger(this.getMergerRegistry()).copyAllLeftToRight(Arrays.asList(diffs.addPrecondition), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right);
        diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.ADD);
        this.checkMergeDeletePrecondition(comparison, diffs);
    }

    private void checkMergeDeletePrecondition(Comparison comparison, DiffsOfInterest diffs) {
        Assert.assertEquals((long)3L, (long)comparison.getDifferences().size());
        Assert.assertNull((Object)diffs.addPrecondition);
        Assert.assertNull((Object)diffs.addGuard);
        Assert.assertNull((Object)diffs.addOwnedRule);
    }

    @Test
    public void testA10MergeLtR2UseCase() throws IOException {
        Resource left = this.input.getA2Left();
        Resource right = this.input.getA2Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.ADD);
        new BatchMerger(this.getMergerRegistry()).copyAllLeftToRight(Arrays.asList(diffs.addGuard), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right);
        diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.ADD);
        this.checkMergeAddGuard(comparison, diffs);
    }

    private void checkMergeAddGuard(Comparison comparison, DiffsOfInterest diffs) {
        Assert.assertEquals((long)2L, (long)comparison.getDifferences().size());
        Assert.assertNull((Object)diffs.addGuard);
        Assert.assertNull((Object)diffs.addOwnedRule);
        Assert.assertNull((Object)diffs.addPrecondition);
        Assert.assertNull((Object)diffs.addTransition);
    }

    @Test
    public void testA10MergeLtR2UseCase3way1() throws IOException {
        Resource left = this.input.getA2Left();
        Resource right = this.input.getA2Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)right);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.ADD);
        new BatchMerger(this.getMergerRegistry()).copyAllLeftToRight(Arrays.asList(diffs.addGuard), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right);
        diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.ADD);
        this.checkMergeAddGuard(comparison, diffs);
    }

    @Test
    public void testA10MergeLtR2UseCase3way2() throws IOException {
        Resource left = this.input.getA2Right();
        Resource right = this.input.getA2Left();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)left);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.ADD);
        new BatchMerger(this.getMergerRegistry()).copyAllLeftToRight(Arrays.asList(diffs.addGuard), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right);
        diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.ADD);
        this.checkMergeDeleteGuard(comparison, diffs);
    }

    private void checkMergeDeleteGuard(Comparison comparison, DiffsOfInterest diffs) {
        Assert.assertEquals((long)3L, (long)comparison.getDifferences().size());
        Assert.assertNull((Object)diffs.addGuard);
        Assert.assertNull((Object)diffs.addPrecondition);
        Assert.assertNull((Object)diffs.addOwnedRule);
    }

    @Test
    public void testA10MergeLtR3UseCase() throws IOException {
        Resource left = this.input.getA2Left();
        Resource right = this.input.getA2Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.ADD);
        new BatchMerger(this.getMergerRegistry()).copyAllLeftToRight(Arrays.asList(diffs.addOwnedRule), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right);
        diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.ADD);
        this.checkMergeAddOwnedRule(comparison, diffs);
    }

    private void checkMergeAddOwnedRule(Comparison comparison, DiffsOfInterest diffs) {
        Assert.assertEquals((long)2L, (long)comparison.getDifferences().size());
        Assert.assertNull((Object)diffs.addOwnedRule);
        Assert.assertNull((Object)diffs.addGuard);
        Assert.assertNull((Object)diffs.addTransition);
        Assert.assertNull((Object)diffs.addPrecondition);
    }

    @Test
    public void testA10MergeLtR3UseCase3way1() throws IOException {
        Resource left = this.input.getA2Left();
        Resource right = this.input.getA2Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)right);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.ADD);
        new BatchMerger(this.getMergerRegistry()).copyAllLeftToRight(Arrays.asList(diffs.addOwnedRule), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right);
        diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.ADD);
        this.checkMergeAddOwnedRule(comparison, diffs);
    }

    @Test
    public void testA10MergeLtR3UseCase3way2() throws IOException {
        Resource left = this.input.getA2Right();
        Resource right = this.input.getA2Left();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)left);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.ADD);
        new BatchMerger(this.getMergerRegistry()).copyAllLeftToRight(Arrays.asList(diffs.addOwnedRule), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right);
        diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.ADD);
        this.checkMergeDeleteOwnedRule(comparison, diffs);
    }

    private void checkMergeDeleteOwnedRule(Comparison comparison, DiffsOfInterest diffs) {
        Assert.assertEquals((long)3L, (long)comparison.getDifferences().size());
        Assert.assertNull((Object)diffs.addOwnedRule);
        Assert.assertNull((Object)diffs.addGuard);
        Assert.assertNull((Object)diffs.addPrecondition);
    }

    @Test
    public void testA10MergeRtL1UseCase() throws IOException {
        Resource left = this.input.getA2Left();
        Resource right = this.input.getA2Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.ADD);
        new BatchMerger(this.getMergerRegistry()).copyAllRightToLeft(Arrays.asList(diffs.addPrecondition), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right);
        diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.ADD);
        this.checkMergeDeletePrecondition(comparison, diffs);
    }

    @Test
    public void testA10MergeRtL1UseCase3way1() throws IOException {
        Resource left = this.input.getA2Left();
        Resource right = this.input.getA2Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)right);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.ADD);
        new BatchMerger(this.getMergerRegistry()).copyAllRightToLeft(Arrays.asList(diffs.addPrecondition), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right);
        diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.ADD);
        this.checkMergeDeletePrecondition(comparison, diffs);
    }

    @Test
    public void testA10MergeRtL1UseCase3way2() throws IOException {
        Resource left = this.input.getA2Right();
        Resource right = this.input.getA2Left();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)left);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.ADD);
        new BatchMerger(this.getMergerRegistry()).copyAllRightToLeft(Arrays.asList(diffs.addPrecondition), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right);
        diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.ADD);
        this.checkMergeAddPrecondition(comparison, diffs);
    }

    @Test
    public void testA10MergeRtL2UseCase() throws IOException {
        Resource left = this.input.getA2Left();
        Resource right = this.input.getA2Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.ADD);
        new BatchMerger(this.getMergerRegistry()).copyAllRightToLeft(Arrays.asList(diffs.addGuard), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right);
        diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.ADD);
        this.checkMergeDeleteGuard(comparison, diffs);
    }

    @Test
    public void testA10MergeRtL2UseCase3way1() throws IOException {
        Resource left = this.input.getA2Left();
        Resource right = this.input.getA2Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)right);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.ADD);
        new BatchMerger(this.getMergerRegistry()).copyAllRightToLeft(Arrays.asList(diffs.addGuard), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right);
        diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.ADD);
        this.checkMergeDeleteGuard(comparison, diffs);
    }

    @Test
    public void testA10MergeRtL2UseCase3way2() throws IOException {
        Resource left = this.input.getA2Right();
        Resource right = this.input.getA2Left();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)left);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.ADD);
        new BatchMerger(this.getMergerRegistry()).copyAllRightToLeft(Arrays.asList(diffs.addGuard), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right);
        diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.ADD);
        this.checkMergeAddGuard(comparison, diffs);
    }

    @Test
    public void testA10MergeRtL3UseCase() throws IOException {
        Resource left = this.input.getA2Left();
        Resource right = this.input.getA2Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.ADD);
        new BatchMerger(this.getMergerRegistry()).copyAllRightToLeft(Arrays.asList(diffs.addOwnedRule), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right);
        diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.ADD);
        this.checkMergeDeleteOwnedRule(comparison, diffs);
    }

    @Test
    public void testA10MergeRtL3UseCase3way1() throws IOException {
        Resource left = this.input.getA2Left();
        Resource right = this.input.getA2Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)right);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.ADD);
        new BatchMerger(this.getMergerRegistry()).copyAllRightToLeft(Arrays.asList(diffs.addOwnedRule), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right);
        diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.ADD);
        this.checkMergeDeleteOwnedRule(comparison, diffs);
    }

    @Test
    public void testA10MergeRtL3UseCase3way2() throws IOException {
        Resource left = this.input.getA2Right();
        Resource right = this.input.getA2Left();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)left);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.ADD);
        new BatchMerger(this.getMergerRegistry()).copyAllRightToLeft(Arrays.asList(diffs.addOwnedRule), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right);
        diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.ADD);
        this.checkMergeAddOwnedRule(comparison, diffs);
    }

    @Test
    public void testA11UseCase() throws IOException {
        Resource left = this.input.getA2Right();
        Resource right = this.input.getA2Left();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right);
        this.testAB1(AbstractUMLTest.TestKind.DELETE, comparison);
    }

    @Test
    public void testA11UseCase3way1() throws IOException {
        Resource left = this.input.getA2Right();
        Resource right = this.input.getA2Left();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)right);
        this.testAB1(AbstractUMLTest.TestKind.DELETE, comparison);
    }

    @Test
    public void testA11UseCase3way2() throws IOException {
        Resource left = this.input.getA2Left();
        Resource right = this.input.getA2Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)left);
        this.testAB1(AbstractUMLTest.TestKind.DELETE, comparison);
    }

    @Test
    public void testA11MergeLtR1UseCase() throws IOException {
        Resource left = this.input.getA2Right();
        Resource right = this.input.getA2Left();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.DELETE);
        new BatchMerger(this.getMergerRegistry()).copyAllLeftToRight(Arrays.asList(diffs.addPrecondition), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right);
        diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.DELETE);
        this.checkMergeDeletePrecondition(comparison, diffs);
    }

    @Test
    public void testA11MergeLtR1UseCase3way1() throws IOException {
        Resource left = this.input.getA2Right();
        Resource right = this.input.getA2Left();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)right);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.DELETE);
        new BatchMerger(this.getMergerRegistry()).copyAllLeftToRight(Arrays.asList(diffs.addPrecondition), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right);
        diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.DELETE);
        this.checkMergeDeletePrecondition(comparison, diffs);
    }

    @Test
    public void testA11MergeLtR1UseCase3way2() throws IOException {
        Resource left = this.input.getA2Left();
        Resource right = this.input.getA2Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)left);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.DELETE);
        new BatchMerger(this.getMergerRegistry()).copyAllLeftToRight(Arrays.asList(diffs.addPrecondition), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right);
        diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.DELETE);
        this.checkMergeAddPrecondition(comparison, diffs);
    }

    @Test
    public void testA11MergeLtR2UseCase() throws IOException {
        Resource left = this.input.getA2Right();
        Resource right = this.input.getA2Left();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.DELETE);
        new BatchMerger(this.getMergerRegistry()).copyAllLeftToRight(Arrays.asList(diffs.addGuard), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right);
        diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.DELETE);
        this.checkMergeDeleteGuard(comparison, diffs);
    }

    @Test
    public void testA11MergeLtR2UseCase3way1() throws IOException {
        Resource left = this.input.getA2Right();
        Resource right = this.input.getA2Left();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)right);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.DELETE);
        new BatchMerger(this.getMergerRegistry()).copyAllLeftToRight(Arrays.asList(diffs.addGuard), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right);
        diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.DELETE);
        this.checkMergeDeleteGuard(comparison, diffs);
    }

    @Test
    public void testA11MergeLtR2UseCase3way2() throws IOException {
        Resource left = this.input.getA2Left();
        Resource right = this.input.getA2Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)left);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.DELETE);
        new BatchMerger(this.getMergerRegistry()).copyAllLeftToRight(Arrays.asList(diffs.addGuard), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right);
        diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.DELETE);
        this.checkMergeAddGuard(comparison, diffs);
    }

    @Test
    public void testA11MergeLtR3UseCase() throws IOException {
        Resource left = this.input.getA2Right();
        Resource right = this.input.getA2Left();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.DELETE);
        new BatchMerger(this.getMergerRegistry()).copyAllLeftToRight(Arrays.asList(diffs.addOwnedRule), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right);
        diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.DELETE);
        this.checkMergeDeleteOwnedRule(comparison, diffs);
    }

    @Test
    public void testA11MergeLtR3UseCase3way1() throws IOException {
        Resource left = this.input.getA2Right();
        Resource right = this.input.getA2Left();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)right);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.DELETE);
        new BatchMerger(this.getMergerRegistry()).copyAllLeftToRight(Arrays.asList(diffs.addOwnedRule), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right);
        diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.DELETE);
        this.checkMergeDeleteOwnedRule(comparison, diffs);
    }

    @Test
    public void testA11MergeLtR3UseCase3way2() throws IOException {
        Resource left = this.input.getA2Left();
        Resource right = this.input.getA2Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)left);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.DELETE);
        new BatchMerger(this.getMergerRegistry()).copyAllLeftToRight(Arrays.asList(diffs.addOwnedRule), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right);
        diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.DELETE);
        this.checkMergeAddOwnedRule(comparison, diffs);
    }

    @Test
    public void testA11MergeRtL1UseCase() throws IOException {
        Resource left = this.input.getA2Right();
        Resource right = this.input.getA2Left();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.DELETE);
        new BatchMerger(this.getMergerRegistry()).copyAllRightToLeft(Arrays.asList(diffs.addPrecondition), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right);
        diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.DELETE);
        this.checkMergeAddPrecondition(comparison, diffs);
    }

    @Test
    public void testA11MergeRtL1UseCase3way1() throws IOException {
        Resource left = this.input.getA2Right();
        Resource right = this.input.getA2Left();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)right);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.DELETE);
        new BatchMerger(this.getMergerRegistry()).copyAllRightToLeft(Arrays.asList(diffs.addPrecondition), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right);
        diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.DELETE);
        this.checkMergeAddPrecondition(comparison, diffs);
    }

    @Test
    public void testA11MergeRtL1UseCase3way2() throws IOException {
        Resource left = this.input.getA2Left();
        Resource right = this.input.getA2Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)left);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.DELETE);
        new BatchMerger(this.getMergerRegistry()).copyAllRightToLeft(Arrays.asList(diffs.addPrecondition), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right);
        diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.DELETE);
        this.checkMergeDeletePrecondition(comparison, diffs);
    }

    @Test
    public void testA11MergeRtL2UseCase() throws IOException {
        Resource left = this.input.getA2Right();
        Resource right = this.input.getA2Left();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.DELETE);
        new BatchMerger(this.getMergerRegistry()).copyAllRightToLeft(Arrays.asList(diffs.addGuard), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right);
        diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.DELETE);
        this.checkMergeAddGuard(comparison, diffs);
    }

    @Test
    public void testA11MergeRtL2UseCase3way1() throws IOException {
        Resource left = this.input.getA2Right();
        Resource right = this.input.getA2Left();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)right);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.DELETE);
        new BatchMerger(this.getMergerRegistry()).copyAllRightToLeft(Arrays.asList(diffs.addGuard), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right);
        diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.DELETE);
        this.checkMergeAddGuard(comparison, diffs);
    }

    @Test
    public void testA11MergeRtL2UseCase3way2() throws IOException {
        Resource left = this.input.getA2Left();
        Resource right = this.input.getA2Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)left);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.DELETE);
        new BatchMerger(this.getMergerRegistry()).copyAllRightToLeft(Arrays.asList(diffs.addGuard), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right);
        diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.DELETE);
        this.checkMergeDeleteGuard(comparison, diffs);
    }

    @Test
    public void testA11MergeRtL3UseCase() throws IOException {
        Resource left = this.input.getA2Right();
        Resource right = this.input.getA2Left();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.DELETE);
        new BatchMerger(this.getMergerRegistry()).copyAllRightToLeft(Arrays.asList(diffs.addOwnedRule), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right);
        diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.DELETE);
        this.checkMergeAddOwnedRule(comparison, diffs);
    }

    @Test
    public void testA11MergeRtL3UseCase3way1() throws IOException {
        Resource left = this.input.getA2Right();
        Resource right = this.input.getA2Left();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)right);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.DELETE);
        new BatchMerger(this.getMergerRegistry()).copyAllRightToLeft(Arrays.asList(diffs.addOwnedRule), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right);
        diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.DELETE);
        this.checkMergeAddOwnedRule(comparison, diffs);
    }

    @Test
    public void testA11MergeRtL3UseCase3way2() throws IOException {
        Resource left = this.input.getA2Left();
        Resource right = this.input.getA2Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)left);
        DiffsOfInterest diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.DELETE);
        new BatchMerger(this.getMergerRegistry()).copyAllRightToLeft(Arrays.asList(diffs.addOwnedRule), (Monitor)new BasicMonitor());
        comparison = this.compare((Notifier)left, (Notifier)right);
        diffs = this.getDiffs(comparison, AbstractUMLTest.TestKind.DELETE);
        this.checkMergeDeleteOwnedRule(comparison, diffs);
    }

    private void testAB1(AbstractUMLTest.TestKind kind, Comparison comparison) {
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)6L, (long)differences.size());
        DiffsOfInterest diffs = this.getDiffs(comparison, kind);
        if (kind.equals((Object)AbstractUMLTest.TestKind.DELETE)) {
            Assert.assertEquals((long)0L, (long)diffs.addPrecondition.getImplies().size());
            Assert.assertEquals((long)1L, (long)diffs.addPrecondition.getImpliedBy().size());
            Assert.assertTrue((boolean)diffs.addPrecondition.getImpliedBy().contains((Object)diffs.addGuard));
            Assert.assertEquals((long)1L, (long)diffs.addGuard.getImplies().size());
            Assert.assertTrue((boolean)diffs.addGuard.getImplies().contains((Object)diffs.addPrecondition));
            Assert.assertEquals((long)1L, (long)diffs.addGuard.getImpliedBy().size());
            Assert.assertTrue((boolean)diffs.addGuard.getImpliedBy().contains((Object)diffs.addOwnedRule));
            Assert.assertEquals((long)1L, (long)diffs.addOwnedRule.getImplies().size());
            Assert.assertTrue((boolean)diffs.addOwnedRule.getImplies().contains((Object)diffs.addGuard));
            Assert.assertEquals((long)0L, (long)diffs.addOwnedRule.getImpliedBy().size());
        } else {
            Assert.assertEquals((long)1L, (long)diffs.addPrecondition.getImplies().size());
            Assert.assertTrue((boolean)diffs.addPrecondition.getImplies().contains((Object)diffs.addGuard));
            Assert.assertEquals((long)0L, (long)diffs.addPrecondition.getImpliedBy().size());
            Assert.assertEquals((long)1L, (long)diffs.addGuard.getImplies().size());
            Assert.assertTrue((boolean)diffs.addGuard.getImplies().contains((Object)diffs.addOwnedRule));
            Assert.assertEquals((long)1L, (long)diffs.addGuard.getImpliedBy().size());
            Assert.assertTrue((boolean)diffs.addGuard.getImpliedBy().contains((Object)diffs.addPrecondition));
            Assert.assertEquals((long)0L, (long)diffs.addOwnedRule.getImplies().size());
            Assert.assertEquals((long)1L, (long)diffs.addOwnedRule.getImpliedBy().size());
            Assert.assertTrue((boolean)diffs.addOwnedRule.getImpliedBy().contains((Object)diffs.addGuard));
        }
    }

    @Override
    protected AbstractUMLInputData getInput() {
        return this.input;
    }

    private class DiffsOfInterest {
        public Diff addTransition;
        public Diff addPrecondition;
        public Diff addOwnedRule;
        public Diff addGuard;

        private DiffsOfInterest() {
        }
    }
}

