/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.tests.conflict;

import java.io.IOException;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.tests.merge.ThreeWayAttributeMergeScenario;
import org.eclipse.emf.ecore.resource.Resource;
import org.junit.Assert;
import org.junit.Test;

public class MultiLineAttributeConflictDetectionTest {
    private static final String NL = "\n";

    @Test
    public void multiLineAttributeChangeOnOneSide() throws IOException {
        String origin = "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat do they call it?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?";
        String left = "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat _do_ they call it?\nThey call it a Royale with Cheese.\nThat's right.\nWhat do they call a Big Mac?\nA Big Mac's a Big Mac, but they call it Le Big Mac.";
        String right = "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat do they call it?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?";
        this.compareAndAssertNoConflictInBothDirections("They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat do they call it?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?", "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat _do_ they call it?\nThey call it a Royale with Cheese.\nThat's right.\nWhat do they call a Big Mac?\nA Big Mac's a Big Mac, but they call it Le Big Mac.", "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat do they call it?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?");
    }

    @Test
    public void conflictingMultiLineAttributeChange_InsertInsertConflict() throws IOException {
        String origin = "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat do they call it?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?\nA Big Mac's a Big Mac, but they call it Le Big Mac.";
        String left = "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat _do_ they call it?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?\nA Big Mac's a Big Mac, but they call it Le Big Mac.";
        String right = "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat do they call it??\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?\nA Big Mac's a Big Mac, but they call it Le Big Mac.";
        this.compareAndAssertConflictInBothDirections("They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat do they call it?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?\nA Big Mac's a Big Mac, but they call it Le Big Mac.", "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat _do_ they call it?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?\nA Big Mac's a Big Mac, but they call it Le Big Mac.", "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat do they call it??\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?\nA Big Mac's a Big Mac, but they call it Le Big Mac.");
    }

    @Test
    public void conflictingMultiLineAttributeChange_MultipleLinesInsertInsert() throws IOException {
        String origin = "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat do they call it?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?\nA Big Mac's a Big Mac, but they call it Le Big Mac.";
        String left = "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat do they call it?\nThey call it a \"Royale with Cheese\".\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?\nA Big Mac's a Big Mac, but they call it Le Big Mac.";
        String right = "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat _do_ they call a Big Mac?\nA Big Mac's a Big Mac, but they call it Le Big Mac.";
        this.compareAndAssertConflictInBothDirections("They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat do they call it?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?\nA Big Mac's a Big Mac, but they call it Le Big Mac.", "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat do they call it?\nThey call it a \"Royale with Cheese\".\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?\nA Big Mac's a Big Mac, but they call it Le Big Mac.", "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat _do_ they call a Big Mac?\nA Big Mac's a Big Mac, but they call it Le Big Mac.");
    }

    @Test
    public void conflictingMultiLineAttributeChange_DeleteInsertConflict() throws IOException {
        String origin = "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat do they call it?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?\nA Big Mac's a Big Mac, but they call it Le Big Mac.";
        String left = "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat _do_ they call it?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?\nA Big Mac's a Big Mac, but they call it Le Big Mac.";
        String right = "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?\nA Big Mac's a Big Mac, but they call it Le Big Mac.";
        this.compareAndAssertConflictInBothDirections("They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat do they call it?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?\nA Big Mac's a Big Mac, but they call it Le Big Mac.", "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat _do_ they call it?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?\nA Big Mac's a Big Mac, but they call it Le Big Mac.", "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?\nA Big Mac's a Big Mac, but they call it Le Big Mac.");
    }

    @Test
    public void mergableMultiLineAttributeChangeOnBothSides() throws IOException {
        String origin = "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat do they call it?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?\nA Big Mac's a Big Mac, but they call it Le Big Mac.";
        String left = "Nah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat _do_ they call it?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?\nA Big Mac's a Big Mac, but they call it Le Big Mac.";
        String right = "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat do they call it?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nWhat do they call a Big Mac?\nA Big Mac's a Big Mac, but they call it Le Big Maec.";
        this.compareAndAssertNoConflictInBothDirections("They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat do they call it?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?\nA Big Mac's a Big Mac, but they call it Le Big Mac.", "Nah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat _do_ they call it?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?\nA Big Mac's a Big Mac, but they call it Le Big Mac.", "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat do they call it?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nWhat do they call a Big Mac?\nA Big Mac's a Big Mac, but they call it Le Big Maec.");
    }

    @Test
    public void conflictingSingleLineAttributeChange() throws IOException {
        Comparison comparison = this.compare("A", "B", "C");
        this.assertOneConflict(comparison);
    }

    @Test
    public void conflictingSingleLineAttributeChangeAndDelete() throws IOException {
        Comparison comparison = this.compare("A", "", "C");
        this.assertOneConflict(comparison);
    }

    @Test
    public void singleLineAttributeChangeRightSide() throws IOException {
        Comparison comparison = this.compare("A", "A", "C");
        this.assertNoConflict(comparison);
    }

    @Test
    public void singleLineAttributeChangeLeftSide() throws IOException {
        Comparison comparison = this.compare("A", "B", "A");
        this.assertNoConflict(comparison);
    }

    @Test
    public void singleLineAttributeSet() throws IOException {
        Comparison comparison = this.compare(null, "B", null);
        this.assertNoConflict(comparison);
    }

    @Test
    public void singleLineAttributeUnset() throws IOException {
        Comparison comparison = this.compare("A", "A", null);
        this.assertNoConflict(comparison);
    }

    @Test
    public void singleLineAttributeRemove() throws IOException {
        Comparison comparison = this.compare("A", "A", "");
        this.assertNoConflict(comparison);
    }

    private void compareAndAssertNoConflictInBothDirections(String origin, String left, String right) throws IOException {
        Comparison comparisonLeftRight = this.compare(origin, left, right);
        this.assertNoConflict(comparisonLeftRight);
        Comparison comparisonRightLeft = this.compare(origin, right, left);
        this.assertNoConflict(comparisonRightLeft);
    }

    private void compareAndAssertConflictInBothDirections(String origin, String left, String right) throws IOException {
        Comparison comparisonLeftRight = this.compare(origin, left, right);
        this.assertOneConflict(comparisonLeftRight);
        Comparison comparisonRightLeft = this.compare(origin, right, left);
        this.assertOneConflict(comparisonRightLeft);
    }

    private Comparison compare(String origin, String left, String right) throws IOException {
        ThreeWayAttributeMergeScenario scenario = this.createMergeScenario(origin, left, right);
        Comparison comparison = this.compare(scenario);
        return comparison;
    }

    private ThreeWayAttributeMergeScenario createMergeScenario(String origin, String left, String right) throws IOException {
        return new ThreeWayAttributeMergeScenario(origin, left, right);
    }

    private Comparison compare(ThreeWayAttributeMergeScenario scenario) {
        Resource origin = scenario.getOriginResource();
        Resource left = scenario.getLeftResource();
        Resource right = scenario.getRightResource();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        return comparison;
    }

    private void assertOneConflict(Comparison comparison) {
        EList conflicts = comparison.getConflicts();
        Assert.assertEquals((long)1L, (long)conflicts.size());
    }

    private void assertNoConflict(Comparison comparison) {
        EList conflicts = comparison.getConflicts();
        Assert.assertEquals((long)0L, (long)conflicts.size());
    }
}

