/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.tests.framework.internal;

import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.ide.ui.tests.framework.AbstractCompareStatement;
import org.eclipse.emf.compare.ide.ui.tests.framework.EMFCompareTestConfiguration;
import org.eclipse.emf.compare.ide.ui.tests.framework.ResolutionStrategyID;
import org.eclipse.emf.compare.ide.ui.tests.framework.annotations.Compare;
import org.eclipse.emf.compare.ide.ui.tests.framework.internal.CompareTestSupport;
import org.junit.runners.model.FrameworkMethod;

public class CompareStatement
extends AbstractCompareStatement {
    public CompareStatement(Object testObject, FrameworkMethod test, ResolutionStrategyID resolutionStrategy, EMFCompareTestConfiguration configuration) {
        super(testObject, test, resolutionStrategy, configuration);
    }

    public void evaluate() throws Throwable {
        this.setEMFComparePreferences();
        Compare compare = (Compare)this.test.getAnnotation(Compare.class);
        String left = this.normalizePath(compare.left());
        String right = this.normalizePath(compare.right());
        String ancestor = this.normalizePath(compare.ancestor());
        Class<?>[] resourceSetHooks = compare.resourceSetHooks();
        CompareTestSupport testSupport = new CompareTestSupport(resourceSetHooks);
        try {
            testSupport.loadResources(this.test.getMethod().getDeclaringClass(), left, right, ancestor);
            Comparison comparison = testSupport.compare();
            Class<?>[] parameters = this.test.getMethod().getParameterTypes();
            if (parameters[parameters.length - 1].getName().equals(CompareTestSupport.class.getName())) {
                this.test.invokeExplosively(this.testObject, new Object[]{comparison, testSupport});
            } else {
                this.test.invokeExplosively(this.testObject, new Object[]{comparison});
            }
        }
        finally {
            this.restoreEMFComparePreferences();
            testSupport.tearDown();
        }
    }
}

