/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.tests.fullcomparison;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.io.IOException;
import java.util.Iterator;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.tests.fullcomparison.data.generics.GenericsMatchInputData;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.resource.Resource;
import org.junit.Assert;
import org.junit.Test;

public class GenericsTest {
    private GenericsMatchInputData inputData = new GenericsMatchInputData();

    @Test
    public void test1() throws IOException {
        Resource left = this.inputData.getLeft();
        Resource right = this.inputData.getRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)38L, (long)differences.size());
        Predicate addKind = EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD);
        UnmodifiableIterator addDiffs = Iterators.filter(differences.iterator(), (Predicate)addKind);
        Assert.assertEquals((long)22L, (long)Iterators.size((Iterator)addDiffs));
        Predicate deleteKind = EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE);
        UnmodifiableIterator deleteDiffs = Iterators.filter(differences.iterator(), (Predicate)deleteKind);
        Assert.assertEquals((long)1L, (long)Iterators.size((Iterator)deleteDiffs));
        Predicate changeKind = EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.CHANGE);
        UnmodifiableIterator changeDiffs = Iterators.filter(differences.iterator(), (Predicate)changeKind);
        Assert.assertEquals((long)15L, (long)Iterators.size((Iterator)changeDiffs));
    }
}

