/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.uml2.tests.stereotypes;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.merge.AbstractMerger;
import org.eclipse.emf.compare.merge.BatchMerger;
import org.eclipse.emf.compare.postprocessor.IPostProcessor;
import org.eclipse.emf.compare.tests.postprocess.data.TestPostProcessor;
import org.eclipse.emf.compare.uml2.internal.StereotypedElementChange;
import org.eclipse.emf.compare.uml2.internal.postprocessor.StereotypedElementChangePostProcessor;
import org.eclipse.emf.compare.uml2.tests.AbstractUMLProfileTest;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.util.UMLUtil;
import org.junit.Assert;

public abstract class AbstractStereotypedElementChangeTests
extends AbstractUMLProfileTest {
    public static void beforeClass() {
        AbstractStereotypedElementChangeTests.addProfilePathmap();
    }

    public static void afterClass() {
        AbstractStereotypedElementChangeTests.resetProfilePathmap();
    }

    @Override
    protected void registerPostProcessors(IPostProcessor.Descriptor.Registry<String> postProcessorRegistry) {
        super.registerPostProcessors(postProcessorRegistry);
        postProcessorRegistry.put((Object)StereotypedElementChangePostProcessor.class.getName(), (IPostProcessor.Descriptor)new TestPostProcessor.TestPostProcessorDescriptor(Pattern.compile("http://www.eclipse.org/uml2/\\d\\.0\\.0/UML"), null, (IPostProcessor)new StereotypedElementChangePostProcessor(), 25));
    }

    protected void testApplyStereotypeOnExistingElement(Resource left, Resource right) throws IOException {
        Comparison comparison = this.compare((Notifier)left, (Notifier)right);
        EList differences = comparison.getDifferences();
        Iterable<StereotypedElementChange> stereotypesChanges = this.getStereotypedElementChanges((Iterable<Diff>)differences, DifferenceKind.ADD);
        Assert.assertEquals((long)0L, (long)Iterables.size(stereotypesChanges));
    }

    protected void testRemoveStereotypeOnExistingElement(Resource left, Resource right) throws IOException {
        Comparison comparison = this.compare((Notifier)left, (Notifier)right);
        EList differences = comparison.getDifferences();
        Iterable<StereotypedElementChange> stereotypesChanges = this.getStereotypedElementChanges((Iterable<Diff>)differences, DifferenceKind.DELETE);
        Assert.assertEquals((long)0L, (long)Iterables.size(stereotypesChanges));
    }

    protected void testAddStereotypedElementMergeLToR(Resource left, Resource right) throws IOException {
        Comparison comparison = this.compare((Notifier)left, (Notifier)right);
        EList differences = comparison.getDifferences();
        StereotypedElementChange stereotypedElementChange = this.getStereotypedElementChange((EList<Diff>)differences, DifferenceKind.ADD, 2);
        this.assertAddedBaseElementDiff((Iterable<Diff>)differences, "model.Class0", stereotypedElementChange);
        this.mergeLeftToRight((Diff)stereotypedElementChange);
        for (Diff diff : differences) {
            Assert.assertSame((Object)DifferenceState.MERGED, (Object)diff.getState());
        }
        this.assertEqualsM1(right);
        this.assertEqualsM1(left);
    }

    protected void testDelStereotypedElementMergeLToR(Resource left, Resource right) throws IOException {
        Comparison comparison = this.compare((Notifier)left, (Notifier)right);
        EList differences = comparison.getDifferences();
        StereotypedElementChange stereotypedElementChange = this.getStereotypedElementChange((EList<Diff>)differences, DifferenceKind.DELETE, 2);
        this.assertDeletedBaseElementDiff((Iterable<Diff>)differences, "model.Class0", stereotypedElementChange);
        this.mergeLeftToRight((Diff)stereotypedElementChange);
        for (Diff diff : differences) {
            Assert.assertSame((Object)DifferenceState.MERGED, (Object)diff.getState());
        }
        this.assertEqualsM2(right);
        this.assertEqualsM2(left);
    }

    protected void testAddStereotypedElementMergeRToL(Resource left, Resource right) throws IOException {
        Comparison comparison = this.compare((Notifier)left, (Notifier)right);
        EList differences = comparison.getDifferences();
        StereotypedElementChange stereotypedElementChange = this.getStereotypedElementChange((EList<Diff>)differences, DifferenceKind.ADD, 2);
        this.assertAddedBaseElementDiff((Iterable<Diff>)differences, "model.Class0", stereotypedElementChange);
        this.mergeRightToLeft((Diff)stereotypedElementChange);
        for (Diff diff : differences) {
            Assert.assertTrue((boolean)AbstractMerger.isInTerminalState((Diff)diff));
        }
        this.assertEqualsM2(right);
        this.assertEqualsM2(left);
    }

    protected void testDelStereotypedElementMergeRToL(Resource left, Resource right) throws IOException {
        Comparison comparison = this.compare((Notifier)left, (Notifier)right);
        EList differences = comparison.getDifferences();
        StereotypedElementChange stereotypedElementChange = this.getStereotypedElementChange((EList<Diff>)differences, DifferenceKind.DELETE, 2);
        this.assertDeletedBaseElementDiff((Iterable<Diff>)differences, "model.Class0", stereotypedElementChange);
        this.mergeRightToLeft((Diff)stereotypedElementChange);
        for (Diff diff : differences) {
            Assert.assertTrue((boolean)AbstractMerger.isInTerminalState((Diff)diff));
        }
        this.assertEqualsM1(right);
        this.assertEqualsM1(left);
    }

    protected void testAddStereotypedElementLToR2(Resource left, Resource right) throws IOException {
        Comparison comparison = this.compare((Notifier)left, (Notifier)right);
        EList differences = comparison.getDifferences();
        StereotypedElementChange stereotypedElementChange = this.getStereotypedElementChange((EList<Diff>)differences, DifferenceKind.ADD, 2);
        this.assertAddedBaseElementDiff((Iterable<Diff>)differences, "model.MyNiceModel.Class1", stereotypedElementChange);
        this.mergeLeftToRight((Diff)stereotypedElementChange);
        for (Diff diff : differences) {
            Assert.assertSame((Object)DifferenceState.MERGED, (Object)diff.getState());
        }
        this.assertEqualsM3(right);
        this.assertEqualsM3(left);
    }

    protected void testDelStereotypedElementLToR2(Resource left, Resource right) throws IOException {
        Comparison comparison = this.compare((Notifier)left, (Notifier)right);
        EList differences = comparison.getDifferences();
        StereotypedElementChange stereotypedElementChange = this.getStereotypedElementChange((EList<Diff>)differences, DifferenceKind.DELETE, 2);
        this.assertDeletedBaseElementDiff((Iterable<Diff>)differences, "model.MyNiceModel.Class1", stereotypedElementChange);
        this.mergeLeftToRight((Diff)stereotypedElementChange);
        Set<Diff> expectedMergeDifferences = this.getRefinedByClosure((Diff)stereotypedElementChange);
        for (Diff diff : differences) {
            DifferenceState expectedDiffState = expectedMergeDifferences.contains(diff) || stereotypedElementChange.equals(diff) ? DifferenceState.MERGED : DifferenceState.UNRESOLVED;
            Assert.assertSame((Object)expectedDiffState, (Object)diff.getState());
        }
        EList contents = right.getContents();
        Assert.assertEquals((long)1L, (long)contents.size());
        Model model = (Model)contents.get(0);
        Assert.assertEquals((long)1L, (long)model.getPackagedElements().size());
        Model subModel = (Model)model.getPackagedElements().get(0);
        Assert.assertEquals((long)0L, (long)subModel.getPackagedElements().size());
        Assert.assertEquals((long)1L, (long)subModel.getAppliedProfiles().size());
        this.assertEqualsM6(left);
    }

    protected void testAddStereotypedElementRToL2(Resource left, Resource right) throws IOException {
        Comparison comparison = this.compare((Notifier)left, (Notifier)right);
        EList differences = comparison.getDifferences();
        StereotypedElementChange stereotypedElementChange = this.getStereotypedElementChange((EList<Diff>)differences, DifferenceKind.ADD, 2);
        this.assertAddedBaseElementDiff((Iterable<Diff>)differences, "model.MyNiceModel.Class1", stereotypedElementChange);
        this.mergeRightToLeft((Diff)stereotypedElementChange);
        Set<Diff> expectedMergeDifferences = this.getRefinedByClosure((Diff)stereotypedElementChange);
        for (Diff diff : differences) {
            DifferenceState expectedDiffState = expectedMergeDifferences.contains(diff) || stereotypedElementChange.equals(diff) ? DifferenceState.DISCARDED : DifferenceState.UNRESOLVED;
            Assert.assertSame((Object)expectedDiffState, (Object)diff.getState());
        }
        EList contents = left.getContents();
        Assert.assertEquals((long)1L, (long)contents.size());
        Model model = (Model)contents.get(0);
        Assert.assertEquals((long)1L, (long)model.getPackagedElements().size());
        Model subModel = (Model)model.getPackagedElements().get(0);
        Assert.assertEquals((long)0L, (long)subModel.getPackagedElements().size());
        Assert.assertEquals((long)1L, (long)subModel.getAppliedProfiles().size());
        this.assertEqualsM6(right);
    }

    protected void testDelStereotypedElementRToL2(Resource left, Resource right) throws IOException {
        Comparison comparison = this.compare((Notifier)left, (Notifier)right);
        EList differences = comparison.getDifferences();
        StereotypedElementChange stereotypedElementChange = this.getStereotypedElementChange((EList<Diff>)differences, DifferenceKind.DELETE, 2);
        this.assertDeletedBaseElementDiff((Iterable<Diff>)differences, "model.MyNiceModel.Class1", stereotypedElementChange);
        this.mergeRightToLeft((Diff)stereotypedElementChange);
        for (Diff diff : differences) {
            Assert.assertTrue((boolean)AbstractMerger.isInTerminalState((Diff)diff));
        }
        this.assertEqualsM3(left);
        this.assertEqualsM3(right);
    }

    protected void testAddMultipleStereotypesLToR(Resource left, Resource right) {
        Comparison comparison = this.compare((Notifier)left, (Notifier)right);
        EList differences = comparison.getDifferences();
        StereotypedElementChange stereotypedElementChange = this.getStereotypedElementChange((EList<Diff>)differences, DifferenceKind.ADD, 3);
        this.assertAddedBaseElementDiff((Iterable<Diff>)differences, "model.Class0", stereotypedElementChange);
        this.mergeLeftToRight((Diff)stereotypedElementChange);
        for (Diff diff : differences) {
            Assert.assertSame((Object)DifferenceState.MERGED, (Object)diff.getState());
        }
        this.assertEqualsM7(right);
        this.assertEqualsM7(left);
    }

    protected void testAddMultipleStereotypesRToL(Resource left, Resource right) {
        Comparison comparison = this.compare((Notifier)left, (Notifier)right);
        EList differences = comparison.getDifferences();
        StereotypedElementChange stereotypedElementChange = this.getStereotypedElementChange((EList<Diff>)differences, DifferenceKind.ADD, 3);
        this.assertAddedBaseElementDiff((Iterable<Diff>)differences, "model.Class0", stereotypedElementChange);
        this.mergeRightToLeft((Diff)stereotypedElementChange);
        for (Diff diff : differences) {
            Assert.assertTrue((boolean)AbstractMerger.isInTerminalState((Diff)diff));
        }
        this.assertEqualsM2(left);
        this.assertEqualsM2(right);
    }

    protected void testDelConflictRToL(Resource left, Resource right, Resource origin) {
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)origin);
        EList differences = comparison.getDifferences();
        StereotypedElementChange stereotypedElementChange = this.getStereotypedElementChange((EList<Diff>)differences, DifferenceKind.DELETE, 3);
        ReferenceChange baseDiff = this.assertDeletedBaseElementDiff((Iterable<Diff>)differences, "model.Class0", stereotypedElementChange);
        Assert.assertNull((Object)stereotypedElementChange.getConflict());
        Set<Conflict> conflicts = this.getConflictsOfRefiningDiffs((Diff)stereotypedElementChange);
        Conflict conflict = (Conflict)Iterables.getOnlyElement(conflicts);
        Assert.assertNotNull((Object)conflict);
        Assert.assertEquals((long)2L, (long)conflict.getDifferences().size());
        EList leftDifferences = conflict.getLeftDifferences();
        Assert.assertEquals((long)1L, (long)leftDifferences.size());
        Diff leftDiff = (Diff)leftDifferences.get(0);
        Assert.assertTrue((boolean)(leftDiff instanceof AttributeChange));
        Assert.assertEquals((long)1L, (long)conflict.getRightDifferences().size());
        Assert.assertTrue((boolean)conflict.getRightDifferences().contains((Object)baseDiff));
        this.mergeRightToLeft((Diff)stereotypedElementChange);
        for (Diff diff : differences) {
            Assert.assertTrue((boolean)AbstractMerger.isInTerminalState((Diff)diff));
        }
        this.assertEqualsM2(left);
        this.assertEqualsM2(right);
    }

    protected void testAbstractDelConflictLToR(Resource left, Resource right, Resource origin) {
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)origin);
        EList differences = comparison.getDifferences();
        StereotypedElementChange stereotypedElementChange = this.getStereotypedElementChange((EList<Diff>)differences, DifferenceKind.DELETE, 3);
        ReferenceChange baseDiff = this.assertDeletedBaseElementDiff((Iterable<Diff>)differences, "model.Class0", stereotypedElementChange);
        Assert.assertNull((Object)stereotypedElementChange.getConflict());
        Set<Conflict> conflicts = this.getConflictsOfRefiningDiffs((Diff)stereotypedElementChange);
        Conflict conflict = (Conflict)Iterables.getOnlyElement(conflicts);
        Assert.assertEquals((long)2L, (long)conflict.getDifferences().size());
        EList leftDifferences = conflict.getLeftDifferences();
        Assert.assertEquals((long)1L, (long)leftDifferences.size());
        Diff leftConflictDiff = (Diff)leftDifferences.get(0);
        Assert.assertTrue((boolean)(leftConflictDiff instanceof AttributeChange));
        Assert.assertEquals((long)1L, (long)conflict.getRightDifferences().size());
        Assert.assertTrue((boolean)conflict.getRightDifferences().contains((Object)baseDiff));
        this.mergeLeftToRight((Diff)stereotypedElementChange);
        for (Diff diff : differences) {
            if (leftConflictDiff.equals(diff)) {
                Assert.assertSame((Object)DifferenceState.UNRESOLVED, (Object)diff.getState());
                continue;
            }
            Assert.assertSame((Object)DifferenceState.DISCARDED, (Object)diff.getState());
        }
        this.assertEqualsM4(right);
        this.assertEqualsM5(left);
    }

    private Set<Conflict> getConflictsOfRefiningDiffs(Diff refinedDiff) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Diff refiningDiff : refinedDiff.getRefinedBy()) {
            if (refiningDiff.getConflict() == null) continue;
            builder.add((Object)refiningDiff.getConflict());
        }
        return builder.build();
    }

    private void assertEqualsM1(Resource input) {
        EList contents = input.getContents();
        Assert.assertEquals((long)2L, (long)contents.size());
        Model model = (Model)contents.get(0);
        Assert.assertEquals((long)1L, (long)model.getPackagedElements().size());
        Class clazz = (Class)model.getPackagedElements().get(0);
        Assert.assertEquals((long)1L, (long)clazz.getAppliedStereotypes().size());
        Assert.assertEquals((long)1L, (long)model.getAppliedProfiles().size());
        EObject stereotypeApplication = (EObject)contents.get(1);
        Assert.assertSame((Object)clazz, (Object)UMLUtil.getBaseElement((EObject)stereotypeApplication));
    }

    private void assertEqualsM2(Resource input) {
        EList contents = input.getContents();
        Assert.assertEquals((long)1L, (long)contents.size());
        Model model = (Model)contents.get(0);
        Assert.assertEquals((long)0L, (long)model.getPackagedElements().size());
        Assert.assertEquals((long)1L, (long)model.getAppliedProfiles().size());
    }

    private void assertEqualsM3(Resource input) {
        EList contents = input.getContents();
        Assert.assertEquals((long)2L, (long)contents.size());
        Model model = (Model)contents.get(0);
        Assert.assertEquals((long)1L, (long)model.getPackagedElements().size());
        Model subModel = (Model)model.getPackagedElements().get(0);
        Assert.assertEquals((long)1L, (long)subModel.getPackagedElements().size());
        Class clazz = (Class)subModel.getPackagedElements().get(0);
        Assert.assertEquals((long)1L, (long)clazz.getAppliedStereotypes().size());
        Assert.assertEquals((long)1L, (long)subModel.getAppliedProfiles().size());
        EObject stereotypeApplication = (EObject)contents.get(1);
        Assert.assertSame((Object)clazz, (Object)UMLUtil.getBaseElement((EObject)stereotypeApplication));
    }

    private void assertEqualsM4(Resource right) {
        EList contents = right.getContents();
        Assert.assertEquals((long)3L, (long)contents.size());
        Model model = (Model)contents.get(0);
        Assert.assertEquals((long)1L, (long)model.getPackagedElements().size());
        Class clazz = (Class)model.getPackagedElements().get(0);
        Assert.assertEquals((long)2L, (long)clazz.getAppliedStereotypes().size());
        Assert.assertEquals((Object)"Class0", (Object)clazz.getName());
        Assert.assertEquals((long)1L, (long)model.getAppliedProfiles().size());
        EObject stereotypeApplication = (EObject)contents.get(1);
        Assert.assertSame((Object)clazz, (Object)UMLUtil.getBaseElement((EObject)stereotypeApplication));
        EObject stereotypeApplication2 = (EObject)contents.get(2);
        Assert.assertSame((Object)clazz, (Object)UMLUtil.getBaseElement((EObject)stereotypeApplication2));
    }

    private void assertEqualsM5(Resource right) {
        EList contents = right.getContents();
        Assert.assertEquals((long)3L, (long)contents.size());
        Model model = (Model)contents.get(0);
        Assert.assertEquals((long)1L, (long)model.getPackagedElements().size());
        Class clazz = (Class)model.getPackagedElements().get(0);
        Assert.assertEquals((long)2L, (long)clazz.getAppliedStereotypes().size());
        Assert.assertEquals((Object)"Class0_newName", (Object)clazz.getName());
        Assert.assertEquals((long)1L, (long)model.getAppliedProfiles().size());
        EObject stereotypeApplication = (EObject)contents.get(1);
        Assert.assertSame((Object)clazz, (Object)UMLUtil.getBaseElement((EObject)stereotypeApplication));
        EObject stereotypeApplication2 = (EObject)contents.get(2);
        Assert.assertSame((Object)clazz, (Object)UMLUtil.getBaseElement((EObject)stereotypeApplication2));
    }

    private void assertEqualsM6(Resource input) {
        EList leftContent = input.getContents();
        Assert.assertEquals((long)1L, (long)leftContent.size());
        Model leftModel = (Model)leftContent.get(0);
        Assert.assertEquals((long)0L, (long)leftModel.getPackagedElements().size());
        Assert.assertEquals((long)0L, (long)leftModel.getAppliedProfiles().size());
    }

    private void assertEqualsM7(Resource inputs) {
        EList contents = inputs.getContents();
        Assert.assertEquals((long)3L, (long)contents.size());
        Model model = (Model)contents.get(0);
        Assert.assertEquals((long)1L, (long)model.getPackagedElements().size());
        Class clazz = (Class)model.getPackagedElements().get(0);
        Assert.assertEquals((long)2L, (long)clazz.getAppliedStereotypes().size());
        Assert.assertEquals((long)1L, (long)model.getAppliedProfiles().size());
        EObject stereotypeApplication = (EObject)contents.get(1);
        Assert.assertSame((Object)clazz, (Object)UMLUtil.getBaseElement((EObject)stereotypeApplication));
        EObject stereotypeApplication2 = (EObject)contents.get(2);
        Assert.assertSame((Object)clazz, (Object)UMLUtil.getBaseElement((EObject)stereotypeApplication2));
    }

    private StereotypedElementChange getStereotypedElementChange(EList<Diff> differences, DifferenceKind diffKind, int expectedRefine) {
        Iterable<StereotypedElementChange> stereotypesChanges = this.getStereotypedElementChanges((Iterable<Diff>)differences, diffKind);
        Assert.assertEquals((long)1L, (long)Iterables.size(stereotypesChanges));
        StereotypedElementChange stereotypedElementChange = stereotypesChanges.iterator().next();
        Assert.assertSame((Object)diffKind, (Object)stereotypedElementChange.getKind());
        Assert.assertEquals((long)expectedRefine, (long)stereotypedElementChange.getRefinedBy().size());
        return stereotypedElementChange;
    }

    private Set<Diff> getRefinedByClosure(Diff startingDiff) {
        HashSet<Diff> result = new HashSet<Diff>();
        for (Diff refinedByDiff : startingDiff.getRefinedBy()) {
            if (result.contains(refinedByDiff)) continue;
            this.getRefinedByClosure(refinedByDiff, result);
        }
        return result;
    }

    private void getRefinedByClosure(Diff d, Set<Diff> result) {
        result.add(d);
        for (Diff refinedByDiff : d.getRefinedBy()) {
            if (result.contains(refinedByDiff)) continue;
            this.getRefinedByClosure(refinedByDiff, result);
        }
    }

    protected void mergeLeftToRight(Diff difference) {
        BatchMerger merger = new BatchMerger(this.getMergerRegistry());
        merger.copyAllLeftToRight(Collections.singleton(difference), (Monitor)new BasicMonitor());
    }

    protected void mergeRightToLeft(Diff difference) {
        BatchMerger merger = new BatchMerger(this.getMergerRegistry());
        merger.copyAllRightToLeft(Collections.singleton(difference), (Monitor)new BasicMonitor());
    }

    private ReferenceChange assertAddedBaseElementDiff(Iterable<Diff> differences, String qualifiedName, StereotypedElementChange stereotypedElementChange) {
        ReferenceChange referenceChange = (ReferenceChange)Iterables.find(differences, (Predicate)EMFComparePredicates.added((String)qualifiedName));
        Assert.assertTrue((boolean)stereotypedElementChange.getRefinedBy().contains((Object)referenceChange));
        Assert.assertSame((Object)referenceChange.getValue(), (Object)stereotypedElementChange.getDiscriminant());
        return referenceChange;
    }

    private ReferenceChange assertDeletedBaseElementDiff(Iterable<Diff> differences, String qualifiedName, StereotypedElementChange stereotypedElementChange) {
        ReferenceChange referenceChange = (ReferenceChange)Iterables.find(differences, (Predicate)EMFComparePredicates.removed((String)qualifiedName));
        Assert.assertTrue((boolean)stereotypedElementChange.getRefinedBy().contains((Object)referenceChange));
        Assert.assertSame((Object)referenceChange.getValue(), (Object)stereotypedElementChange.getDiscriminant());
        return referenceChange;
    }

    private Iterable<StereotypedElementChange> getStereotypedElementChanges(Iterable<Diff> differences, DifferenceKind diffKind) {
        Predicate selectingPredicate = Predicates.and((Predicate)Predicates.instanceOf(StereotypedElementChange.class), (Predicate)EMFComparePredicates.ofKind((DifferenceKind)diffKind));
        return Iterables.transform((Iterable)Iterables.filter(differences, (Predicate)selectingPredicate), (Function)new Function<Diff, StereotypedElementChange>(){

            public StereotypedElementChange apply(Diff input) {
                return (StereotypedElementChange)input;
            }
        });
    }
}

