/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.egit.internal.merge;

import java.util.Arrays;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.emf.compare.egit.internal.merge.GitResourceVariantTreeProvider;
import org.eclipse.emf.compare.egit.internal.merge.GitSyncInfoToDiffConverter;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.core.variants.IResourceVariantComparator;
import org.eclipse.team.core.variants.IResourceVariantTree;
import org.eclipse.team.core.variants.ResourceVariantTreeSubscriber;
import org.eclipse.team.internal.core.mapping.SyncInfoToDiffConverter;

public class GitResourceVariantTreeSubscriber
extends ResourceVariantTreeSubscriber {
    private GitResourceVariantTreeProvider variantTreeProvider;
    private final SyncInfoToDiffConverter syncInfoConverter;
    private final IResourceVariantComparator comparator;

    public GitResourceVariantTreeSubscriber(GitResourceVariantTreeProvider variantTreeProvider) {
        this.variantTreeProvider = variantTreeProvider;
        this.syncInfoConverter = new GitSyncInfoToDiffConverter(variantTreeProvider);
        this.comparator = new GitVariantComparator(variantTreeProvider.getSourceTree());
    }

    public IResourceVariantTree getBaseTree() {
        return this.variantTreeProvider.getBaseTree();
    }

    public IResourceVariantTree getRemoteTree() {
        return this.variantTreeProvider.getRemoteTree();
    }

    public IResourceVariantTree getSourceTree() {
        return this.variantTreeProvider.getSourceTree();
    }

    public IDiff getDiff(IResource resource) throws CoreException {
        SyncInfo info = this.getSyncInfo(resource);
        if (info == null || info.getKind() == 0) {
            return null;
        }
        return this.syncInfoConverter.getDeltaFor(info);
    }

    public SyncInfo getSyncInfo(IResource resource) throws TeamException {
        try {
            return super.getSyncInfo(resource);
        }
        catch (ForwardedTeamException e) {
            throw (TeamException)e.getCause();
        }
    }

    public String getName() {
        return CoreText.GitResourceVariantTreeSubscriber_name;
    }

    public boolean isSupervised(IResource resource) throws TeamException {
        return this.variantTreeProvider.getKnownResources().contains(resource);
    }

    public IResource[] roots() {
        Set<IResource> roots = this.variantTreeProvider.getRoots();
        return roots.toArray(new IResource[roots.size()]);
    }

    public IResourceVariantComparator getResourceComparator() {
        return this.comparator;
    }

    private static class ForwardedTeamException
    extends RuntimeException {
        private static final long serialVersionUID = 4074010396155542178L;

        public ForwardedTeamException(TeamException e) {
            super((Throwable)e);
        }
    }

    private static class GitVariantComparator
    implements IResourceVariantComparator {
        private final IResourceVariantTree oursTree;

        public GitVariantComparator(IResourceVariantTree oursTree) {
            this.oursTree = oursTree;
        }

        public boolean compare(IResource local, IResourceVariant remote) {
            try {
                IResourceVariant oursVariant = this.oursTree.getResourceVariant(local);
                if (oursVariant == null) {
                    return remote == null;
                }
                return this.compare(oursVariant, remote);
            }
            catch (TeamException e) {
                throw new ForwardedTeamException(e);
            }
        }

        public boolean compare(IResourceVariant base, IResourceVariant remote) {
            return Arrays.equals(base.asBytes(), remote.asBytes());
        }

        public boolean isThreeWay() {
            return true;
        }
    }
}

