/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.logical;

import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.internal.resources.ResourceStatus;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIMessages;
import org.eclipse.emf.compare.ide.utils.ResourceUtil;
import org.eclipse.emf.compare.ide.utils.StorageTraversal;
import org.eclipse.emf.compare.utils.IDiagnosable;
import org.eclipse.emf.ecore.resource.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public final class SynchronizationModel
implements IDiagnosable {
    private final StorageTraversal leftTraversal;
    private final StorageTraversal rightTraversal;
    private final StorageTraversal originTraversal;
    private Diagnostic diagnostic;
    private ImmutableSet<IResource> resources;
    private final ImmutableSet<IResource> allInvolvedResources;
    private SynchronizationModelDiagnosticProvider diagnosticProvider;

    public SynchronizationModel(StorageTraversal leftTraversal, StorageTraversal rightTraversal, StorageTraversal originTraversal) {
        this(leftTraversal, rightTraversal, originTraversal, (Diagnostic)new BasicDiagnostic("org.eclipse.emf.compare.ide.ui", 0, null, new Object[]{leftTraversal, rightTraversal, originTraversal}));
    }

    public SynchronizationModel(StorageTraversal leftTraversal, StorageTraversal rightTraversal, StorageTraversal originTraversal, Diagnostic diagnostic) {
        this.diagnostic = (Diagnostic)Preconditions.checkNotNull((Object)diagnostic);
        this.leftTraversal = leftTraversal == null ? new StorageTraversal((Set)Sets.newHashSet()) : leftTraversal;
        this.rightTraversal = rightTraversal == null ? new StorageTraversal((Set)Sets.newHashSet()) : rightTraversal;
        this.originTraversal = originTraversal == null ? new StorageTraversal((Set)Sets.newHashSet()) : originTraversal;
        this.diagnosticProvider = new SynchronizationModelDiagnosticProvider(this);
        this.allInvolvedResources = this.computeResources();
    }

    public StorageTraversal getLeftTraversal() {
        return this.leftTraversal;
    }

    public StorageTraversal getRightTraversal() {
        return this.rightTraversal;
    }

    public StorageTraversal getOriginTraversal() {
        return this.originTraversal;
    }

    public Diagnostic getDiagnostic() {
        return this.diagnosticProvider.getDiagnostic();
    }

    public void setDiagnostic(Diagnostic diagnostic) {
        this.diagnostic = diagnostic;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SynchronizationModel) {
            SynchronizationModel other = (SynchronizationModel)obj;
            return Objects.equal((Object)this.leftTraversal, (Object)other.leftTraversal) && Objects.equal((Object)this.rightTraversal, (Object)other.rightTraversal) && Objects.equal((Object)this.originTraversal, (Object)other.originTraversal);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.leftTraversal, this.rightTraversal, this.originTraversal});
    }

    public Set<IResource> getResources() {
        if (this.resources == null) {
            this.resources = this.computeResources();
        }
        return this.resources;
    }

    public Set<IResource> getAllInvolvedResources() {
        return this.allInvolvedResources;
    }

    private ImmutableSet<IResource> computeResources() {
        Set<IResource> leftResources = SynchronizationModel.collectResources(this.getLeftTraversal());
        Set<IResource> rightResources = SynchronizationModel.collectResources(this.getRightTraversal());
        Set<IResource> originResources = SynchronizationModel.collectResources(this.getOriginTraversal());
        return ImmutableSet.builder().addAll(leftResources).addAll(rightResources).addAll(originResources).build();
    }

    private static Set<IResource> collectResources(StorageTraversal traversal) {
        LinkedHashSet<IResource> resources = new LinkedHashSet<IResource>();
        if (traversal == null) {
            return resources;
        }
        for (IStorage storage : traversal.getStorages()) {
            if (storage instanceof IFile) {
                resources.add((IResource)((IFile)storage));
                continue;
            }
            resources.add((IResource)ResourcesPlugin.getWorkspace().getRoot().getFile(ResourceUtil.getFixedPath((IStorage)storage)));
        }
        return resources;
    }

    private static class SynchronizationModelDiagnosticProvider {
        private BasicDiagnostic syncModelDiagnostic;
        private HashSet<IPath> resourcePathCache;
        private SynchronizationModel syncModel;

        SynchronizationModelDiagnosticProvider(SynchronizationModel syncModel) {
            this.syncModel = syncModel;
        }

        public Diagnostic getDiagnostic() {
            if (this.syncModelDiagnostic == null) {
                this.buildDiagnostic();
            }
            return this.syncModelDiagnostic;
        }

        private void buildDiagnostic() {
            this.syncModelDiagnostic = new BasicDiagnostic("org.eclipse.emf.compare.ide.ui", 0, EMFCompareIDEUIMessages.getString("SynchronizationModel.diagnosticMesg"), new Object[]{this.syncModel});
            this.syncModelDiagnostic.add((Diagnostic)this.getSynchronizationModelDiagnostic());
            this.syncModelDiagnostic.add((Diagnostic)this.getDiagnosticForSide(this.syncModel.getLeftTraversal().getDiagnostic(), "left"));
            this.syncModelDiagnostic.add((Diagnostic)this.getDiagnosticForSide(this.syncModel.getOriginTraversal().getDiagnostic(), "origin"));
            this.syncModelDiagnostic.add((Diagnostic)this.getDiagnosticForSide(this.syncModel.getRightTraversal().getDiagnostic(), "right"));
        }

        private BasicDiagnostic getSynchronizationModelDiagnostic() {
            BasicDiagnostic d = new BasicDiagnostic(this.syncModel.diagnostic.getSource(), this.syncModel.diagnostic.getCode(), null, EMFCompareIDEUIMessages.getString("SynchronizationModel.root"), null);
            for (Diagnostic child : this.syncModel.diagnostic.getChildren()) {
                List diagnosticData = child.getData();
                if (diagnosticData.isEmpty()) continue;
                Object object = diagnosticData.get(0);
                if (object instanceof ResourceStatus) {
                    ResourceStatus status = (ResourceStatus)object;
                    IPath resourceIPath = status.getPath();
                    if (!this.containsResourceWithPath(resourceIPath)) continue;
                    d.merge(child);
                    continue;
                }
                if (object instanceof Resource.Diagnostic) {
                    Path path;
                    Resource.Diagnostic resourceDiagnostic = (Resource.Diagnostic)object;
                    String location = resourceDiagnostic.getLocation();
                    URI locationUri = URI.createURI((String)location, (boolean)false);
                    String fullPath = null;
                    fullPath = locationUri.isPlatform() ? locationUri.toPlatformString(true) : locationUri.toString();
                    if (fullPath == null || !this.containsResourceWithPath((IPath)(path = new Path(fullPath)))) continue;
                    d.merge(child);
                    continue;
                }
                if (!this.syncModel.getResources().contains(object)) continue;
                d.merge(child);
            }
            return d;
        }

        private BasicDiagnostic getDiagnosticForSide(Diagnostic toAdd, String side) {
            BasicDiagnostic d = new BasicDiagnostic(toAdd.getSeverity(), toAdd.getSource(), 0, EMFCompareIDEUIMessages.getString("SynchronizationModel." + side), null);
            if (!toAdd.getChildren().isEmpty()) {
                d.merge(toAdd);
            }
            return d;
        }

        private boolean containsResourceWithPath(IPath resourcePath) {
            if (this.resourcePathCache == null) {
                this.buildResourcePathCache();
            }
            return this.resourcePathCache.contains(resourcePath);
        }

        private void buildResourcePathCache() {
            this.resourcePathCache = new HashSet();
            for (IResource resource : this.syncModel.getResources()) {
                if (resource.getFullPath() == null) continue;
                this.resourcePathCache.add(resource.getFullPath());
            }
        }
    }
}

