/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.provider;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.CompareInputAdapter;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.emf.edit.tree.TreeNode;

public class TreeNodeCompareInput
extends CompareInputAdapter
implements INotifyChangedListener,
IChangeNotifier {
    protected IChangeNotifier changeNotifier;
    protected IChangeNotifier delegateItemProvider;

    public TreeNodeCompareInput(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public void setTarget(Notifier target) {
        super.setTarget(target);
        if (target == null) {
            if (this.delegateItemProvider != null) {
                this.delegateItemProvider.removeListener((INotifyChangedListener)this);
                this.delegateItemProvider = null;
            }
        } else if (target instanceof TreeNode) {
            TreeNode treeNode = (TreeNode)target;
            this.delegateItemProvider = (IChangeNotifier)this.getRootAdapterFactory().adapt((Notifier)treeNode.getData(), IItemLabelProvider.class);
            this.delegateItemProvider.addListener((INotifyChangedListener)this);
        } else {
            throw new IllegalArgumentException(target + " should have been a TreeNode");
        }
    }

    public void notifyChanged(Notification notification) {
        this.fireNotifyChanged(ViewerNotification.wrapNotification((Notification)notification, (Object)((Object)this)));
    }

    public void fireNotifyChanged(Notification notification) {
        if (this.changeNotifier != null) {
            this.changeNotifier.fireNotifyChanged(notification);
        }
        if (this.getAdapterFactory() instanceof IChangeNotifier) {
            IChangeNotifier localChangeNotifier = (IChangeNotifier)this.getAdapterFactory();
            localChangeNotifier.fireNotifyChanged(notification);
        }
    }

    public void addListener(INotifyChangedListener listener) {
        if (this.changeNotifier == null) {
            this.changeNotifier = new ChangeNotifier();
        }
        this.changeNotifier.addListener(listener);
    }

    public void removeListener(INotifyChangedListener listener) {
        if (this.changeNotifier != null) {
            this.changeNotifier.removeListener(listener);
        }
    }

    public void dispose() {
        if (this.delegateItemProvider != null) {
            this.delegateItemProvider.removeListener((INotifyChangedListener)this);
        }
        super.dispose();
    }
}

