/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.match.resource;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.CompareFactory;
import org.eclipse.emf.compare.MatchResource;
import org.eclipse.emf.compare.match.resource.IResourceMatchingStrategy;
import org.eclipse.emf.ecore.resource.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocationMatchingStrategy
implements IResourceMatchingStrategy {
    @Override
    public List<MatchResource> matchResources(Iterable<? extends Resource> left, Iterable<? extends Resource> right, Iterable<? extends Resource> origin) {
        ArrayList mappings = Lists.newArrayList();
        ArrayList rightCopy = Lists.newArrayList(right);
        ArrayList originCopy = Lists.newArrayList(origin);
        for (Resource resource : left) {
            Resource matchingRight = this.findMatch(resource, rightCopy);
            Resource matchingOrigin = this.findMatch(resource, originCopy);
            if (matchingRight == null && matchingOrigin == null) continue;
            rightCopy.remove(matchingRight);
            originCopy.remove(matchingOrigin);
            mappings.add(LocationMatchingStrategy.createMatchResource(resource, matchingRight, matchingOrigin));
        }
        for (Resource resource : rightCopy) {
            Resource matchingOrigin = this.findMatch(resource, originCopy);
            originCopy.remove(matchingOrigin);
            if (matchingOrigin == null) continue;
            mappings.add(LocationMatchingStrategy.createMatchResource(null, resource, matchingOrigin));
        }
        return mappings;
    }

    protected Resource findMatch(Resource reference, Iterable<Resource> candidates) {
        URI referenceURI = reference.getURI();
        for (Resource candidate : candidates) {
            if (referenceURI != candidate.getURI() && (referenceURI == null || !referenceURI.equals(candidate.getURI()))) continue;
            return candidate;
        }
        return null;
    }

    protected static MatchResource createMatchResource(Resource left, Resource right, Resource origin) {
        MatchResource match = CompareFactory.eINSTANCE.createMatchResource();
        match.setLeft(left);
        match.setRight(right);
        match.setOrigin(origin);
        if (left != null && left.getURI() != null) {
            match.setLeftURI(left.getURI().toString());
        }
        if (right != null && right.getURI() != null) {
            match.setRightURI(right.getURI().toString());
        }
        if (origin != null && origin.getURI() != null) {
            match.setOriginURI(origin.getURI().toString());
        }
        return match;
    }
}

