/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.match.eobject;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.emf.compare.match.eobject.DefaultWeightProvider;
import org.eclipse.emf.compare.match.eobject.EcoreWeightProvider;
import org.eclipse.emf.compare.match.eobject.WeightProvider;
import org.eclipse.emf.compare.match.eobject.internal.WeightProviderDescriptorImpl;
import org.eclipse.emf.ecore.EPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeightProviderDescriptorRegistryImpl
implements WeightProvider.Descriptor.Registry {
    private final Map<String, WeightProvider.Descriptor> weightProviderDescriptors = Maps.newHashMap();
    private final Map<String, WeightProvider> cache = Maps.newHashMap();

    public static WeightProvider.Descriptor.Registry createStandaloneInstance() {
        WeightProviderDescriptorRegistryImpl registry = new WeightProviderDescriptorRegistryImpl();
        DefaultWeightProvider defaultWeightProvider = new DefaultWeightProvider();
        WeightProviderDescriptorImpl dwpDescriptor = new WeightProviderDescriptorImpl(defaultWeightProvider, 100, Pattern.compile(".*"));
        EcoreWeightProvider ecoreWeightProvider = new EcoreWeightProvider();
        WeightProviderDescriptorImpl ewpDescriptor = new WeightProviderDescriptorImpl(ecoreWeightProvider, 101, Pattern.compile("http://www.eclipse.org/emf/2002/Ecore"));
        registry.put(defaultWeightProvider.getClass().getName(), dwpDescriptor);
        registry.put(ecoreWeightProvider.getClass().getName(), ewpDescriptor);
        return registry;
    }

    @Override
    public WeightProvider.Descriptor put(String key, WeightProvider.Descriptor weightProvider) {
        this.cache.clear();
        return this.weightProviderDescriptors.put(key, weightProvider);
    }

    @Override
    public void clear() {
        this.weightProviderDescriptors.clear();
        this.cache.clear();
    }

    public ImmutableList<WeightProvider.Descriptor> getDescriptors() {
        return ImmutableList.copyOf(this.weightProviderDescriptors.values());
    }

    @Override
    public WeightProvider.Descriptor remove(String key) {
        this.cache.clear();
        return this.weightProviderDescriptors.remove(key);
    }

    @Override
    public WeightProvider getHighestRankingWeightProvider(EPackage ePackage) {
        WeightProvider.Descriptor highestRankingWeightProviderDescriptor;
        WeightProvider weightProvider = this.cache.get(ePackage.getNsURI());
        if (weightProvider == null && (highestRankingWeightProviderDescriptor = this.getHighestRankingWeightProviderDescriptor(ePackage.getNsURI())) != null) {
            weightProvider = highestRankingWeightProviderDescriptor.getWeightProvider();
            this.cache.put(ePackage.getNsURI(), weightProvider);
        }
        return weightProvider;
    }

    public ImmutableList<WeightProvider> getWeightProviders(EPackage ePackage) {
        ImmutableList.Builder weightProvidersBuilder = ImmutableList.builder();
        for (WeightProvider.Descriptor descriptor : this.getWeightProviderDescriptors(ePackage)) {
            weightProvidersBuilder.add((Object)descriptor.getWeightProvider());
        }
        return weightProvidersBuilder.build();
    }

    private ImmutableList<WeightProvider.Descriptor> getWeightProviderDescriptors(EPackage ePackage) {
        return this.getWeightProviderDescriptors(ePackage.getNsURI());
    }

    private ImmutableList<WeightProvider.Descriptor> getWeightProviderDescriptors(String nsURI) {
        ImmutableList.Builder weightProvidersBuilder = ImmutableList.builder();
        for (WeightProvider.Descriptor descriptor : this.getDescriptors()) {
            Pattern nsURIPattern = descriptor.getNsURI();
            if (nsURIPattern == null || !nsURIPattern.matcher(nsURI).matches()) continue;
            weightProvidersBuilder.add((Object)descriptor);
        }
        return weightProvidersBuilder.build();
    }

    private WeightProvider.Descriptor getHighestRankingWeightProviderDescriptor(String nsURI) {
        WeightProvider.Descriptor ret = null;
        UnmodifiableIterator descriptors = this.getWeightProviderDescriptors(nsURI).iterator();
        if (descriptors.hasNext()) {
            WeightProvider.Descriptor highestRanking = (WeightProvider.Descriptor)descriptors.next();
            while (descriptors.hasNext()) {
                WeightProvider.Descriptor desc = (WeightProvider.Descriptor)descriptors.next();
                if (desc.getRanking() <= highestRanking.getRanking()) continue;
                highestRanking = desc;
            }
            ret = highestRanking;
        }
        return ret;
    }
}

