/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.logical.view;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.IModelProviderDescriptor;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIPlugin;
import org.eclipse.emf.compare.ide.ui.internal.logical.EMFResourceMapping;
import org.eclipse.emf.compare.ide.ui.logical.SynchronizationModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LogicalModelViewHandlerUtil {
    private static final int GET_TRAVERSALS_TICKS = 15;
    private static final int GET_RESOURCES_MAPPING_TICKS = 85;
    private static IModelProviderDescriptor modelDescriptor = ModelProvider.getModelProviderDescriptor((String)"org.eclipse.emf.compare.model.provider");

    private LogicalModelViewHandlerUtil() {
    }

    public static Set<IResource> getLogicalModelResources(IFile file, IProgressMonitor monitor) {
        LinkedHashSet resources = Sets.newLinkedHashSet();
        if (file == null) {
            return resources;
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Collection<EMFResourceMapping> resourceMappings = LogicalModelViewHandlerUtil.getResourceMappings(file, (IProgressMonitor)subMonitor.newChild(85));
        subMonitor.worked(85);
        SubMonitor subMonitorLoop = subMonitor.newChild(15).setWorkRemaining(resourceMappings.size());
        for (ResourceMapping resourceMapping : resourceMappings) {
            if (!(resourceMapping instanceof EMFResourceMapping)) continue;
            try {
                ((EMFResourceMapping)resourceMapping).getTraversals(ResourceMappingContext.LOCAL_CONTEXT, (IProgressMonitor)subMonitorLoop.newChild(1));
                SynchronizationModel syncModel = ((EMFResourceMapping)resourceMapping).getLatestModel();
                resources.addAll(syncModel.getResources());
            }
            catch (CoreException e) {
                EMFCompareIDEUIPlugin.getDefault().log(e);
            }
        }
        return resources;
    }

    public static boolean isEMFCompareCompliantFile(IFile file) {
        try {
            IResource[] resources = modelDescriptor.getMatchingResources(new IResource[]{file});
            if (resources.length > 0) {
                return true;
            }
        }
        catch (CoreException e) {
            EMFCompareIDEUIPlugin.getDefault().log(e);
        }
        return false;
    }

    private static Collection<EMFResourceMapping> getResourceMappings(IFile file, IProgressMonitor monitor) {
        LinkedHashSet mappings = Sets.newLinkedHashSet();
        if (LogicalModelViewHandlerUtil.isEMFCompareCompliantFile(file)) {
            try {
                ResourceMapping[] modelMappings;
                ModelProvider model = modelDescriptor.getModelProvider();
                ResourceMapping[] resourceMappingArray = modelMappings = model.getMappings((IResource)file, ResourceMappingContext.LOCAL_CONTEXT, monitor);
                int n = modelMappings.length;
                int n2 = 0;
                while (n2 < n) {
                    ResourceMapping mapping = resourceMappingArray[n2];
                    if (mapping instanceof EMFResourceMapping) {
                        mappings.add((EMFResourceMapping)mapping);
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                EMFCompareIDEUIPlugin.getDefault().log(e);
            }
        }
        return mappings;
    }
}

