/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.logical;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.emf.common.util.AbstractTreeIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Graph<E> {
    private final Map<E, Node<E>> nodes = new LinkedHashMap<E, Node<E>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(E element) {
        Map<E, Node<E>> map = this.nodes;
        synchronized (map) {
            return this.nodes.containsKey(element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(E element) {
        Map<E, Node<E>> map = this.nodes;
        synchronized (map) {
            block4: {
                Node<E> node = this.nodes.get(element);
                if (node != null) break block4;
                node = new Node<E>(element);
                this.nodes.put(element, node);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(E element) {
        Map<E, Node<E>> map = this.nodes;
        synchronized (map) {
            Node<E> node = this.nodes.remove(element);
            if (node != null) {
                node.breakConnections();
            }
        }
    }

    public void removeAll(Collection<E> elements) {
        for (E e : elements) {
            this.remove(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChildren(E element, Set<E> newChildren) {
        Map<E, Node<E>> map = this.nodes;
        synchronized (map) {
            Node<E> node = this.nodes.get(element);
            if (node == null) {
                node = new Node<E>(element);
                this.nodes.put(element, node);
            }
            for (E newChild : newChildren) {
                Node<E> childNode = this.nodes.get(newChild);
                if (childNode == null) {
                    childNode = new Node<E>(newChild);
                    this.nodes.put(newChild, childNode);
                }
                node.connectChild(childNode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasChild(E parent, E potentialChild) {
        Map<E, Node<E>> map = this.nodes;
        synchronized (map) {
            Node<E> node = this.nodes.get(potentialChild);
            if (node != null) {
                return Iterables.any(node.getAllParents(), this.is(parent));
            }
            return false;
        }
    }

    private Predicate<? super Node<E>> is(final E element) {
        return new Predicate<Node<E>>(){

            public boolean apply(Node<E> input) {
                return input != null && input.getElement() == element;
            }
        };
    }

    public Iterable<E> getSubgraphOf(E element) {
        return this.getBoundedSubgraphOf(element, Collections.emptySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<E> getBoundedSubgraphOf(E element, Set<E> endPoints) {
        Map<E, Node<E>> map = this.nodes;
        synchronized (map) {
            Node<E> node = this.nodes.get(element);
            if (node != null) {
                Set<Object> boundaries = endPoints;
                if (boundaries == null) {
                    boundaries = Collections.emptySet();
                }
                return new SubgraphBuilder<E>(node, boundaries).build();
            }
            return Collections.emptyList();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Node<K> {
        private final K element;
        private final Set<Node<K>> children;
        private final Set<Node<K>> parents;

        public Node(K element) {
            this.element = element;
            this.parents = new LinkedHashSet<Node<K>>();
            this.children = new LinkedHashSet<Node<K>>();
        }

        public Set<Node<K>> getChildren() {
            return Collections.unmodifiableSet(this.children);
        }

        public Set<Node<K>> getParents() {
            return Collections.unmodifiableSet(this.parents);
        }

        public Iterable<Node<K>> getAllParents() {
            return new ParentsIterable(this);
        }

        public void connectChild(Node<K> child) {
            this.children.add(child);
            child.parents.add(this);
        }

        public void breakConnections() {
            for (Node<K> parent : this.parents) {
                parent.children.remove(this);
            }
            for (Node<K> child : this.children) {
                child.parents.remove(this);
            }
            this.parents.clear();
            this.children.clear();
        }

        public K getElement() {
            return this.element;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ParentsIterable<M>
    implements Iterable<Node<M>> {
        private final Node<M> start;

        public ParentsIterable(Node<M> start) {
            this.start = start;
        }

        @Override
        public Iterator<Node<M>> iterator() {
            return new ParentsIterator<M>(this.start);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ParentsIterator<N>
    extends AbstractTreeIterator<Node<N>> {
        private static final long serialVersionUID = -4476850344598138970L;

        public ParentsIterator(Node<N> start) {
            super(start, false);
        }

        protected Iterator<? extends Node<N>> getChildren(Object obj) {
            return ((Node)obj).getParents().iterator();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SubgraphBuilder<L> {
        private final Node<L> start;
        protected final Set<L> set;
        protected final Set<L> endPoints;

        public SubgraphBuilder(Node<L> start, Set<L> endPoints) {
            this.start = start;
            this.set = new LinkedHashSet<L>();
            this.set.add(start.getElement());
            this.endPoints = (Set)Preconditions.checkNotNull(endPoints);
        }

        public Set<L> build() {
            return ImmutableSet.copyOf((Iterator)new NodeIterator(this.start));
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class NodeIterator
        implements Iterator<L> {
            private final Iterator<Node<L>> nodesIterator;
            private Iterator<L> nextNodeIterator;
            private L next;

            public NodeIterator(Node<L> node) {
                this.next = node.getElement();
                this.nodesIterator = Iterators.concat(node.getParents().iterator(), node.getChildren().iterator());
                this.prepareNextIterator();
            }

            @Override
            public boolean hasNext() {
                return this.next != null || this.nextNodeIterator.hasNext() || this.nodesIterator.hasNext();
            }

            @Override
            public L next() {
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                Object result = this.next;
                this.prepareNext();
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private void prepareNext() {
                if (!this.nextNodeIterator.hasNext()) {
                    this.prepareNextIterator();
                }
                this.next = this.nextNodeIterator.hasNext() ? this.nextNodeIterator.next() : null;
            }

            private void prepareNextIterator() {
                if (this.nodesIterator.hasNext()) {
                    Node nextNode = this.nodesIterator.next();
                    while (SubgraphBuilder.this.set.contains(nextNode.getElement()) && !SubgraphBuilder.this.endPoints.contains(nextNode.getElement()) && this.nodesIterator.hasNext()) {
                        nextNode = this.nodesIterator.next();
                    }
                    this.nextNodeIterator = !SubgraphBuilder.this.endPoints.contains(nextNode.getElement()) && SubgraphBuilder.this.set.add(nextNode.getElement()) ? new NodeIterator(nextNode) : Iterators.emptyIterator();
                } else {
                    this.nextNodeIterator = Iterators.emptyIterator();
                }
            }
        }
    }
}

