/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer;

import java.util.Arrays;
import org.eclipse.compare.INavigatable;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.EMFCompareStructureMergeViewer;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.WrappableTreeViewer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Widget;

public class Navigatable
implements INavigatable {
    private final AdapterFactory adapterFactory;
    private final WrappableTreeViewer viewer;

    public Navigatable(AdapterFactory adapterFactory, WrappableTreeViewer viewer) {
        this.adapterFactory = adapterFactory;
        this.viewer = viewer;
    }

    public boolean selectChange(int flag) {
        Object nextOrPrev = null;
        Item[] selection = this.viewer.getSelection((Control)this.viewer.getTree());
        Item firstSelectedItem = selection.length > 0 ? selection[0] : null;
        switch (flag) {
            case 1: {
                nextOrPrev = this.getNextDiff(firstSelectedItem);
                break;
            }
            case 2: {
                nextOrPrev = this.getPreviousDiff(firstSelectedItem);
                break;
            }
            case 3: {
                nextOrPrev = this.getNextDiff(null);
                break;
            }
            case 4: {
                nextOrPrev = this.getPreviousDiff(null);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        if (nextOrPrev != null) {
            StructuredSelection newSelection = new StructuredSelection(nextOrPrev);
            this.viewer.setSelection((ISelection)newSelection);
            this.viewer.fireOpen(new OpenEvent((Viewer)this.viewer, (ISelection)newSelection));
        }
        return nextOrPrev == null;
    }

    public Object getInput() {
        return this.viewer.getInput();
    }

    public boolean openSelectedChange() {
        ISelection selection = this.viewer.getSelection();
        if (selection.isEmpty()) {
            return false;
        }
        this.viewer.fireOpen(new OpenEvent((Viewer)this.viewer, selection));
        return true;
    }

    public boolean hasChange(int changeFlag) {
        Item[] selection = this.viewer.getSelection((Control)this.viewer.getTree());
        Item firstSelectedItem = selection.length > 0 ? selection[0] : null;
        switch (changeFlag) {
            case 1: {
                return this.getNextDiff(firstSelectedItem) != null;
            }
            case 2: {
                return this.getPreviousDiff(firstSelectedItem) != null;
            }
        }
        throw new IllegalStateException();
    }

    private Object getNextDiff(Item item) {
        Object ret = null;
        Item[] children = this.getChildren(item);
        ret = this.getFirstDiffChild(children);
        if (ret == null) {
            ret = this.getNextSiblingDiff(item);
        }
        return ret;
    }

    private Object getPreviousDiff(Item item) {
        Object ret = null;
        ret = item == null ? this.getDeepestDiffChild(null) : this.getPreviousSiblingDeepestDiff(item);
        return ret;
    }

    private Object getNextSiblingDiff(Item item) {
        if (item == null) {
            return null;
        }
        Object ret = null;
        Item parentItem = this.viewer.getParentItem(item);
        Item[] siblings = this.getChildren(parentItem);
        int indexOfItem = Arrays.asList(siblings).indexOf(item);
        if (indexOfItem + 1 < siblings.length) {
            int i = indexOfItem + 1;
            while (i < siblings.length && ret == null) {
                Item followingSibling = siblings[i];
                ret = this.getDataOrNextDiff(followingSibling);
                ++i;
            }
        } else if (parentItem != null) {
            ret = this.getNextSiblingDiff(parentItem);
        }
        return ret;
    }

    private Object getPreviousSiblingDeepestDiff(Item item) {
        if (item == null) {
            return null;
        }
        Object ret = null;
        Item parentItem = this.viewer.getParentItem(item);
        Item[] siblings = this.getChildren(parentItem);
        int indexOfItem = Arrays.asList(siblings).indexOf(item);
        if (indexOfItem - 1 >= 0) {
            int i = indexOfItem - 1;
            while (i >= 0 && ret == null) {
                Item previousSibling = siblings[i];
                ret = this.getDeepestDiffChild(previousSibling);
                --i;
            }
        } else if (parentItem != null) {
            EObject eObject = EMFCompareStructureMergeViewer.getDataOfTreeNodeOfAdapter(parentItem.getData());
            ret = eObject instanceof Diff ? parentItem.getData() : this.getPreviousDiff(parentItem);
        }
        return ret;
    }

    private Object getDataOrNextDiff(Item item) {
        EObject eObject = EMFCompareStructureMergeViewer.getDataOfTreeNodeOfAdapter(item.getData());
        Object ret = eObject instanceof Diff ? item.getData() : this.getNextDiff(item);
        return ret;
    }

    private Object getFirstDiffChild(Item[] children) {
        Object ret = null;
        int i = 0;
        while (i < children.length && ret == null) {
            Item child = children[i];
            ret = this.getDataOrNextDiff(child);
            ++i;
        }
        return ret;
    }

    private Item[] getChildren(Item item) {
        Item[] children = item != null ? this.viewer.getChildren((Widget)item) : this.viewer.getChildren((Widget)this.viewer.getTree());
        return children;
    }

    private Object getDeepestDiffChild(Item item) {
        EObject eObject;
        Object ret = null;
        Item[] children = this.getChildren(item);
        int i = children.length - 1;
        while (i >= 0 && ret == null) {
            EObject eObject2;
            Item child = children[i];
            ret = this.getDeepestDiffChild(child);
            if (ret == null && (eObject2 = EMFCompareStructureMergeViewer.getDataOfTreeNodeOfAdapter(child.getData())) instanceof Diff) {
                ret = child.getData();
            }
            --i;
        }
        if (ret == null && (eObject = EMFCompareStructureMergeViewer.getDataOfTreeNodeOfAdapter(item.getData())) instanceof Diff) {
            ret = item.getData();
        }
        return ret;
    }
}

