/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.table;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.ResourceBundle;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.ide.ui.internal.configuration.EMFCompareConfiguration;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.EMFCompareContentMergeViewer;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.table.TableContentMergeViewerContentProvider;
import org.eclipse.emf.compare.rcp.EMFCompareRCPPlugin;
import org.eclipse.emf.compare.rcp.ui.internal.configuration.IEMFCompareConfiguration;
import org.eclipse.emf.compare.rcp.ui.internal.contentmergeviewer.accessor.ICompareAccessor;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.ICompareColor;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.IMergeViewer;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.impl.AbstractMergeViewer;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.impl.TableMergeViewer;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.item.IMergeViewerItem;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.IDifferenceGroupProvider;
import org.eclipse.emf.compare.rcp.ui.internal.util.MergeViewerUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemFontProvider;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class TableContentMergeViewer
extends EMFCompareContentMergeViewer {
    private static final String BUNDLE_NAME = TableContentMergeViewer.class.getName();
    private final ComposedAdapterFactory fAdapterFactory = new ComposedAdapterFactory((ComposedAdapterFactory.Descriptor.Registry)EMFCompareRCPPlugin.getDefault().getAdapterFactoryRegistry());
    private double[] fBasicCenterCurve;

    protected TableContentMergeViewer(Composite parent, EMFCompareConfiguration config) {
        super(0, ResourceBundle.getBundle(BUNDLE_NAME), config);
        this.fAdapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        this.fAdapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        this.buildControl(parent);
        this.setContentProvider((IContentProvider)new TableContentMergeViewerContentProvider(config));
    }

    protected void handleDispose(DisposeEvent event) {
        this.fAdapterFactory.dispose();
        super.handleDispose(event);
    }

    protected byte[] getContents(boolean left) {
        return null;
    }

    protected TableMergeViewer getLeftMergeViewer() {
        return (TableMergeViewer)super.getLeftMergeViewer();
    }

    protected TableMergeViewer getRightMergeViewer() {
        return (TableMergeViewer)super.getRightMergeViewer();
    }

    protected TableMergeViewer getAncestorMergeViewer() {
        return (TableMergeViewer)super.getAncestorMergeViewer();
    }

    protected AbstractMergeViewer createMergeViewer(Composite parent, final IMergeViewer.MergeViewerSide side) {
        TableMergeViewer ret = new TableMergeViewer(parent, side, (ICompareColor.Provider)this, (IEMFCompareConfiguration)this.getCompareConfiguration());
        ret.getStructuredViewer().getTable().getVerticalBar().setVisible(false);
        ret.setContentProvider((IContentProvider)new ArrayContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof ICompareAccessor) {
                    return super.getElements((Object)((ICompareAccessor)inputElement).getItems());
                }
                return super.getElements(inputElement);
            }
        });
        ret.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider.FontAndColorProvider((AdapterFactory)this.fAdapterFactory, (Viewer)ret.getStructuredViewer()){

            public Font getFont(Object object, int columnIndex) {
                Object value;
                if (object instanceof IMergeViewerItem && (value = ((IMergeViewerItem)object).getSideValue(side)) instanceof EObject && ((EObject)value).eIsProxy()) {
                    return this.getFontFromObject(IItemFontProvider.ITALIC_FONT);
                }
                return super.getFont(object, columnIndex);
            }

            public String getColumnText(Object object, int columnIndex) {
                if (object instanceof IMergeViewerItem) {
                    IMergeViewerItem mergeViewerItem = (IMergeViewerItem)object;
                    Object value = mergeViewerItem.getSideValue(side);
                    String text = value instanceof EObject && ((EObject)value).eIsProxy() ? "proxy : " + ((InternalEObject)value).eProxyURI().toString() : (mergeViewerItem.isInsertionPoint() ? Strings.repeat((String)" ", (int)42) : super.getColumnText(value, columnIndex));
                    return text;
                }
                return super.getColumnText(object, columnIndex);
            }

            public Image getColumnImage(Object object, int columnIndex) {
                if (object instanceof IMergeViewerItem) {
                    IMergeViewerItem mergeViewerItem = (IMergeViewerItem)object;
                    if (((IMergeViewerItem)object).isInsertionPoint()) {
                        return null;
                    }
                    Object sideValue = mergeViewerItem.getSideValue(side);
                    Image superImage = super.getColumnImage(sideValue, columnIndex);
                    if (superImage == null) {
                        return this.getDefaultImage(sideValue);
                    }
                    return superImage;
                }
                return super.getColumnImage(object, columnIndex);
            }
        });
        ret.getStructuredViewer().getTable().getVerticalBar().addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TableContentMergeViewer.this.redrawCenterControl();
            }
        });
        ret.getStructuredViewer().getTable().addMouseWheelListener(new MouseWheelListener(){

            public void mouseScrolled(MouseEvent e) {
                TableContentMergeViewer.this.redrawCenterControl();
            }
        });
        ret.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TableContentMergeViewer.this.redrawCenterControl();
            }
        });
        return ret;
    }

    protected void paintCenter(GC g) {
        TableMergeViewer leftMergeViewer = this.getLeftMergeViewer();
        TableMergeViewer rightMergeViewer = this.getRightMergeViewer();
        Table leftTable = leftMergeViewer.getStructuredViewer().getTable();
        Table rightTable = rightMergeViewer.getStructuredViewer().getTable();
        Rectangle leftClientArea = leftTable.getClientArea();
        Rectangle rightClientArea = rightTable.getClientArea();
        TableItem[] leftItems = leftTable.getItems();
        TableItem[] rightItems = rightTable.getItems();
        ImmutableSet selection = ImmutableSet.copyOf((Object[])leftTable.getSelection());
        TableItem[] tableItemArray = leftItems;
        int n = leftItems.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem rightItem;
            TableItem leftItem = tableItemArray[n2];
            boolean selected = Iterables.any((Iterable)selection, (Predicate)Predicates.equalTo((Object)leftItem));
            IMergeViewerItem leftData = (IMergeViewerItem)leftItem.getData();
            Diff leftDiff = ((IMergeViewerItem)leftItem.getData()).getDiff();
            if (leftDiff != null && MergeViewerUtil.isVisibleInMergeViewer((Diff)leftDiff, (IDifferenceGroupProvider)this.getDifferenceGroupProvider(), this.getDifferenceFilterPredicate()) && (rightItem = this.findRightTableItemFromLeftDiff(rightItems, leftDiff, leftData)) != null) {
                Color strokeColor = this.getCompareColor().getStrokeColor(leftDiff, this.isThreeWay(), false, selected);
                g.setForeground(strokeColor);
                this.drawCenterLine(g, leftClientArea, rightClientArea, leftItem, rightItem);
            }
            ++n2;
        }
    }

    protected void createToolItems(ToolBarManager toolBarManager) {
        IContributionItem[] items;
        super.createToolItems(toolBarManager);
        IContributionItem[] iContributionItemArray = items = toolBarManager.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem iContributionItem = iContributionItemArray[n2];
            if (iContributionItem instanceof ActionContributionItem) {
                IAction action = ((ActionContributionItem)iContributionItem).getAction();
                String id = action.getActionDefinitionId();
                if ("org.eclipse.compare.copyAllLeftToRight".equals(id)) {
                    toolBarManager.remove(iContributionItem);
                } else if ("org.eclipse.compare.copyAllRightToLeft".equals(id)) {
                    toolBarManager.remove(iContributionItem);
                }
            }
            ++n2;
        }
    }

    private void drawCenterLine(GC g, Rectangle leftClientArea, Rectangle rightClientArea, TableItem leftItem, TableItem rightItem) {
        Control control = this.getCenterControl();
        Point from = new Point(0, 0);
        Point to = new Point(0, 0);
        Rectangle leftBounds = leftItem.getBounds();
        Rectangle rightBounds = rightItem.getBounds();
        from.y = leftBounds.y + leftBounds.height / 2 - leftClientArea.y + 1 + this.getLeftMergeViewer().getVerticalOffset();
        to.x = control.getBounds().width;
        to.y = rightBounds.y + rightBounds.height / 2 - rightClientArea.y + 1 + this.getRightMergeViewer().getVerticalOffset();
        int[] points = this.getCenterCurvePoints(from, to);
        int i = 1;
        while (i < points.length) {
            g.drawLine(from.x + i - 1, points[i - 1], i, points[i]);
            ++i;
        }
    }

    private TableItem findRightTableItemFromLeftDiff(TableItem[] rightItems, Diff leftDiff, IMergeViewerItem leftData) {
        TableItem ret = null;
        int i = 0;
        while (i < rightItems.length && ret == null) {
            TableItem rightItem = rightItems[i];
            IMergeViewerItem rightData = (IMergeViewerItem)rightItem.getData();
            Diff rightDiff = ((IMergeViewerItem)rightItem.getData()).getDiff();
            if (leftDiff == rightDiff) {
                ret = rightItem;
            } else if (Objects.equal((Object)rightData.getAncestor(), (Object)leftData.getAncestor()) && Objects.equal((Object)rightData.getRight(), (Object)leftData.getRight()) && Objects.equal((Object)rightData.getLeft(), (Object)leftData.getLeft())) {
                ret = rightItem;
            }
            ++i;
        }
        return ret;
    }

    private int[] getCenterCurvePoints(Point from, Point to) {
        int startx = from.x;
        int starty = from.y;
        int endx = to.x;
        int endy = to.y;
        if (this.fBasicCenterCurve == null) {
            this.buildBaseCenterCurve(endx - startx);
        }
        double height = endy - starty;
        height /= 2.0;
        int width = endx - startx;
        int[] points = new int[width];
        int i = 0;
        while (i < width) {
            points[i] = (int)(-height * this.fBasicCenterCurve[i] + height + (double)starty);
            ++i;
        }
        return points;
    }

    private void buildBaseCenterCurve(int w) {
        double width = w;
        this.fBasicCenterCurve = new double[this.getCenterWidth()];
        int i = 0;
        while (i < this.getCenterWidth()) {
            double r = (double)i / width;
            this.fBasicCenterCurve[i] = Math.cos(Math.PI * r);
            ++i;
        }
    }
}

