/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.impl;

import org.eclipse.emf.compare.rcp.ui.internal.configuration.IEMFCompareConfiguration;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.IMergeViewer;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.impl.AbstractMergeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class StructuredMergeViewer
extends AbstractMergeViewer {
    private final Control fControl;
    private final ISelectionChangedListener fForwardingSelectionListener;

    public StructuredMergeViewer(Composite parent, IMergeViewer.MergeViewerSide side, IEMFCompareConfiguration compareConfiguration) {
        super(side, compareConfiguration);
        this.fControl = this.createControl(parent);
        this.hookControl(this.fControl);
        this.fForwardingSelectionListener = new ForwardingViewerSelectionListener();
        this.getStructuredViewer().addSelectionChangedListener(this.fForwardingSelectionListener);
    }

    public Control getControl() {
        return this.fControl;
    }

    protected void handleDispose(DisposeEvent event) {
        this.getStructuredViewer().removeSelectionChangedListener(this.fForwardingSelectionListener);
        super.handleDispose(event);
    }

    protected abstract Control createControl(Composite var1);

    protected abstract StructuredViewer getStructuredViewer();

    public ISelection getSelection() {
        return this.getStructuredViewer().getSelection();
    }

    public void setSelection(ISelection selection, boolean reveal) {
        this.getStructuredViewer().setSelection(selection, reveal);
    }

    public void setContentProvider(IContentProvider contentProvider) {
        super.setContentProvider(contentProvider);
        this.getStructuredViewer().setContentProvider(contentProvider);
    }

    public void setLabelProvider(IBaseLabelProvider labelProvider) {
        super.setLabelProvider(labelProvider);
        this.getStructuredViewer().setLabelProvider(labelProvider);
    }

    private class ForwardingViewerSelectionListener
    implements ISelectionChangedListener {
        private ForwardingViewerSelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            StructuredMergeViewer.this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)StructuredMergeViewer.this, event.getSelection()));
        }
    }
}

