/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareNavigator;
import org.eclipse.compare.ICompareNavigator;
import org.eclipse.compare.contentmergeviewer.ContentMergeViewer;
import org.eclipse.compare.internal.CompareHandlerService;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.domain.ICompareEditingDomain;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.util.DynamicObject;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.util.EMFCompareColor;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.util.RedoAction;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.util.UndoAction;
import org.eclipse.emf.compare.rcp.EMFCompareRCPPlugin;
import org.eclipse.emf.compare.rcp.ui.internal.contentmergeviewer.accessor.ICompareAccessor;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.ICompareColor;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.IMergeViewer;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.item.IMergeViewerItem;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.filters.IDifferenceFilter;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.filters.impl.SubDiffElementsFilter;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.menus.IMenuService;

public abstract class EMFCompareContentMergeViewer
extends ContentMergeViewer
implements ISelectionChangedListener,
ICompareColor.Provider,
IAdaptable,
IPropertyChangeListener,
CommandStackListener {
    private static final String HANDLER_SERVICE = "fHandlerService";
    protected static final int HORIZONTAL = 1;
    protected static final int VERTICAL = 2;
    protected static final double HSPLIT = 0.5;
    protected static final double VSPLIT = 0.3;
    protected static final int CENTER_WIDTH = 34;
    private IMergeViewer fAncestor;
    private IMergeViewer fLeft;
    private IMergeViewer fRight;
    private ActionContributionItem fCopyDiffLeftToRightItem;
    private ActionContributionItem fCopyDiffRightToLeftItem;
    private final AtomicBoolean fSyncingSelections = new AtomicBoolean(false);
    private EMFCompareColor fColors;
    private final DynamicObject fDynamicObject = new DynamicObject((Object)this);
    private UndoAction undoAction;
    private RedoAction redoAction;

    protected EMFCompareContentMergeViewer(int style, ResourceBundle bundle, CompareConfiguration cc) {
        super(style, bundle, cc);
        this.editingDomainChange(null, this.getEditingDomain());
        cc.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if ("org.eclipse.emf.compare.rcp.ui.EDITING_DOMAIN".equals(event.getProperty())) {
            this.editingDomainChange((ICompareEditingDomain)event.getOldValue(), (ICompareEditingDomain)event.getNewValue());
        }
    }

    protected void editingDomainChange(ICompareEditingDomain oldValue, ICompareEditingDomain newValue) {
        if (oldValue != null) {
            oldValue.getCommandStack().removeCommandStackListener((CommandStackListener)this);
        }
        if (newValue != oldValue) {
            if (newValue != null) {
                newValue.getCommandStack().addCommandStackListener((CommandStackListener)this);
                this.setLeftDirty(newValue.getCommandStack().isLeftSaveNeeded());
                this.setRightDirty(newValue.getCommandStack().isRightSaveNeeded());
            }
            if (this.undoAction != null) {
                this.undoAction.setEditingDomain(newValue);
            }
            if (this.redoAction != null) {
                this.redoAction.setEditingDomain(newValue);
            }
        }
    }

    public ICompareColor getCompareColor() {
        return this.fColors;
    }

    protected final ICompareEditingDomain getEditingDomain() {
        return (ICompareEditingDomain)this.getCompareConfiguration().getProperty("org.eclipse.emf.compare.rcp.ui.EDITING_DOMAIN");
    }

    protected final Comparison getComparison() {
        return (Comparison)this.getCompareConfiguration().getProperty("org.eclipse.emf.compare.rcp.ui.COMPARE.RESULT");
    }

    public boolean isThreeWay() {
        return super.isThreeWay();
    }

    protected void updateContent(Object ancestor, Object left, Object right) {
        this.fAncestor.setInput(ancestor);
        this.fLeft.setInput(left);
        this.fRight.setInput(right);
        this.updateSelection(left);
    }

    protected void updateSelection(Object left) {
        IMergeViewerItem leftInitialItem = null;
        if (left instanceof ICompareAccessor) {
            leftInitialItem = ((ICompareAccessor)left).getInitialItem();
        }
        ISelection leftSelection = this.createSelectionOrEmpty(leftInitialItem);
        this.fLeft.setSelection(leftSelection, true);
        this.getCenterControl().redraw();
    }

    private ISelection createSelectionOrEmpty(Object o) {
        StructuredSelection selection = o != null ? new StructuredSelection(o) : StructuredSelection.EMPTY;
        return selection;
    }

    protected boolean doSave(Object newInput, Object oldInput) {
        return false;
    }

    protected void createControls(Composite composite) {
        this.fAncestor = this.createMergeViewer(composite, IMergeViewer.MergeViewerSide.ANCESTOR);
        this.fAncestor.addSelectionChangedListener((ISelectionChangedListener)this);
        this.fLeft = this.createMergeViewer(composite, IMergeViewer.MergeViewerSide.LEFT);
        this.fLeft.addSelectionChangedListener((ISelectionChangedListener)this);
        this.fRight = this.createMergeViewer(composite, IMergeViewer.MergeViewerSide.RIGHT);
        this.fRight.addSelectionChangedListener((ISelectionChangedListener)this);
        this.fColors = new EMFCompareColor(this, null, this.getCompareConfiguration());
    }

    protected void createToolItems(ToolBarManager toolBarManager) {
        CompareConfiguration cc;
        IWorkbench workbench = PlatformUI.getWorkbench();
        IMenuService menuService = (IMenuService)workbench.getService(IMenuService.class);
        if (menuService != null) {
            menuService.populateContributionManager((ContributionManager)toolBarManager, "toolbar:org.eclipse.emf.compare.contentmergeviewer.toolbar");
        }
        if ((cc = this.getCompareConfiguration()).isRightEditable()) {
            Action copyLeftToRight = new Action(){

                public void run() {
                    EMFCompareContentMergeViewer.this.copyDiff(true);
                    EMFCompareContentMergeViewer.this.navigate(true);
                }
            };
            Utilities.initAction((IAction)copyLeftToRight, (ResourceBundle)this.getResourceBundle(), (String)"action.CopyDiffLeftToRight.");
            copyLeftToRight.setEnabled(false);
            this.fCopyDiffLeftToRightItem = new ActionContributionItem((IAction)copyLeftToRight);
            this.fCopyDiffLeftToRightItem.setVisible(true);
            toolBarManager.appendToGroup("merge", (IContributionItem)this.fCopyDiffLeftToRightItem);
            this.getHandlerService().registerAction((IAction)copyLeftToRight, "org.eclipse.compare.copyLeftToRight");
        }
        if (cc.isLeftEditable()) {
            Action copyRightToLeft = new Action(){

                public void run() {
                    EMFCompareContentMergeViewer.this.copyDiff(false);
                    EMFCompareContentMergeViewer.this.navigate(true);
                }
            };
            Utilities.initAction((IAction)copyRightToLeft, (ResourceBundle)this.getResourceBundle(), (String)"action.CopyDiffRightToLeft.");
            copyRightToLeft.setEnabled(false);
            this.fCopyDiffRightToLeftItem = new ActionContributionItem((IAction)copyRightToLeft);
            this.fCopyDiffRightToLeftItem.setVisible(true);
            toolBarManager.appendToGroup("merge", (IContributionItem)this.fCopyDiffRightToLeftItem);
            this.getHandlerService().registerAction((IAction)copyRightToLeft, "org.eclipse.compare.copyRightToLeft");
        }
        Action nextDiff = new Action(){

            public void run() {
                EMFCompareContentMergeViewer.this.navigate(true);
            }
        };
        Utilities.initAction((IAction)nextDiff, (ResourceBundle)this.getResourceBundle(), (String)"action.NextDiff.");
        ActionContributionItem contributionNextDiff = new ActionContributionItem((IAction)nextDiff);
        contributionNextDiff.setVisible(true);
        toolBarManager.appendToGroup("navigation", (IContributionItem)contributionNextDiff);
        Action previousDiff = new Action(){

            public void run() {
                EMFCompareContentMergeViewer.this.navigate(false);
            }
        };
        Utilities.initAction((IAction)previousDiff, (ResourceBundle)this.getResourceBundle(), (String)"action.PrevDiff.");
        ActionContributionItem contributionPreviousDiff = new ActionContributionItem((IAction)previousDiff);
        contributionPreviousDiff.setVisible(true);
        toolBarManager.appendToGroup("navigation", (IContributionItem)contributionPreviousDiff);
        this.undoAction = new UndoAction(this.getEditingDomain());
        this.redoAction = new RedoAction(this.getEditingDomain());
        this.getHandlerService().setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)this.undoAction);
        this.getHandlerService().setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)this.redoAction);
    }

    public void commandStackChanged(EventObject event) {
        if (this.undoAction != null) {
            this.undoAction.update();
        }
        if (this.redoAction != null) {
            this.redoAction.update();
        }
        if (this.getEditingDomain() != null) {
            this.setLeftDirty(this.getEditingDomain().getCommandStack().isLeftSaveNeeded());
            this.setRightDirty(this.getEditingDomain().getCommandStack().isRightSaveNeeded());
        }
        this.refresh();
    }

    protected void copy(final boolean leftToRight) {
        ImmutableList differences = this.getComparison().isThreeWay() ? ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)this.getComparison().getDifferences(), (Predicate)new Predicate<Diff>(){

            public boolean apply(Diff diff) {
                boolean fromRightToLeft;
                boolean unresolved = diff.getState() == DifferenceState.UNRESOLVED;
                boolean nonConflictual = diff.getConflict() == null;
                boolean fromLeftToRight = leftToRight && diff.getSource() == DifferenceSource.LEFT;
                boolean bl = fromRightToLeft = !leftToRight && diff.getSource() == DifferenceSource.RIGHT;
                return unresolved && nonConflictual && (fromLeftToRight || fromRightToLeft);
            }
        })) : ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)this.getComparison().getDifferences(), (Predicate)EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.UNRESOLVED})));
        if (differences.size() > 0) {
            Command copyCommand = this.getEditingDomain().createCopyCommand((List)differences, leftToRight, EMFCompareRCPPlugin.getDefault().getMergerRegistry());
            this.getEditingDomain().getCommandStack().execute(copyCommand);
            this.refresh();
        }
    }

    protected void navigate(boolean next) {
        ICompareNavigator navigator;
        Composite control = this.getControl();
        if (control != null && !control.isDisposed() && (navigator = this.getCompareConfiguration().getContainer().getNavigator()) instanceof CompareNavigator && ((CompareNavigator)navigator).hasChange(next)) {
            navigator.selectChange(next);
        }
    }

    protected abstract void copyDiff(boolean var1);

    protected void handleResizeAncestor(int x, int y, int width, int height) {
        if (width > 0) {
            this.getAncestorMergeViewer().getControl().setVisible(true);
            this.getAncestorMergeViewer().getControl().setBounds(x, y, width, height);
        } else {
            this.getAncestorMergeViewer().getControl().setVisible(false);
        }
    }

    protected void handleResizeLeftRight(int x, int y, int width1, int centerWidth, int width2, int height) {
        this.fLeft.getControl().setBounds(x, y, width1, height);
        this.fRight.getControl().setBounds(x + width1 + centerWidth, y, width2, height);
    }

    protected abstract IMergeViewer createMergeViewer(Composite var1, IMergeViewer.MergeViewerSide var2);

    protected final int getCenterWidth() {
        return 34;
    }

    protected final CompareHandlerService getHandlerService() {
        return (CompareHandlerService)this.fDynamicObject.get(HANDLER_SERVICE);
    }

    public Composite getControl() {
        return (Composite)super.getControl();
    }

    protected Control createCenterControl(Composite parent) {
        final Control ret = super.createCenterControl(parent);
        final PaintListener paintListener = new PaintListener(){

            public void paintControl(PaintEvent e) {
                EMFCompareContentMergeViewer.this.paintCenter(e.gc);
            }
        };
        ret.addPaintListener(paintListener);
        ret.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ret.removePaintListener(paintListener);
            }
        });
        return ret;
    }

    protected abstract void paintCenter(GC var1);

    public Object getAdapter(Class adapter) {
        if (adapter == CompareHandlerService.class) {
            return this.getHandlerService();
        }
        if (adapter == CompareHandlerService[].class) {
            return new CompareHandlerService[]{this.getHandlerService()};
        }
        return null;
    }

    protected IMergeViewer getAncestorMergeViewer() {
        return this.fAncestor;
    }

    protected IMergeViewer getLeftMergeViewer() {
        return this.fLeft;
    }

    protected IMergeViewer getRightMergeViewer() {
        return this.fRight;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.synchronizeSelection(event);
        this.updateToolItems();
    }

    private void synchronizeSelection(SelectionChangedEvent event) {
        if (this.fSyncingSelections.compareAndSet(false, true)) {
            try {
                ISelection selection = event.getSelection();
                this.fLeft.setSelection(selection, true);
                this.fRight.setSelection(selection, true);
                this.fAncestor.setSelection(selection, true);
            }
            finally {
                this.fSyncingSelections.set(false);
            }
        }
    }

    protected void updateToolItems() {
        super.updateToolItems();
        this.manageCopyActionsActivation();
    }

    protected void manageCopyActionsActivation() {
        Diff diff = this.getDiffFrom(this.getRightMergeViewer());
        if (diff == null) {
            diff = this.getDiffFrom(this.getLeftMergeViewer());
        }
        boolean enableCopy = false;
        if (diff != null) {
            boolean bl = enableCopy = diff.getState() == DifferenceState.UNRESOLVED;
        }
        if (this.fCopyDiffLeftToRightItem != null) {
            this.fCopyDiffLeftToRightItem.getAction().setEnabled(enableCopy);
        }
        if (this.fCopyDiffRightToLeftItem != null) {
            this.fCopyDiffRightToLeftItem.getAction().setEnabled(enableCopy);
        }
    }

    protected Diff getDiffFrom(IMergeViewer viewer) {
        Diff diff = null;
        ISelection selection = viewer.getSelection();
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            Iterator selectedElements = ((IStructuredSelection)selection).iterator();
            while (diff == null && selectedElements.hasNext()) {
                Object element = selectedElements.next();
                if (!(element instanceof IMergeViewerItem)) continue;
                diff = ((IMergeViewerItem)element).getDiff();
            }
        }
        return diff;
    }

    protected void handleDispose(DisposeEvent event) {
        this.getCompareConfiguration().removePropertyChangeListener((IPropertyChangeListener)this);
        this.editingDomainChange(this.getEditingDomain(), null);
        super.handleDispose(event);
    }

    protected boolean isSubDiffFilterActive() {
        Object property = this.getCompareConfiguration().getProperty("org.eclipse.emf.compare.rcp.ui.SELECTED_FILTERS");
        if (property == null) {
            return false;
        }
        Collection selectedFilters = (Collection)property;
        for (IDifferenceFilter iDifferenceFilter : selectedFilters) {
            if (!(iDifferenceFilter instanceof SubDiffElementsFilter)) continue;
            return true;
        }
        return false;
    }
}

