/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amalgam.discovery.modeling.handlers;

import java.io.IOException;
import java.util.Collections;
import org.eclipse.amalgam.discovery.DiscoveryDefinition;
import org.eclipse.amalgam.discovery.ui.viewer.DiscoveryContentProvider;
import org.eclipse.amalgam.discovery.ui.wizards.DiscoveryWizard;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

public class ModelingDiscoveryHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        final IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        DiscoveryContentProvider provider = new DiscoveryContentProvider(){

            protected DiscoveryDefinition load() {
                XMIResourceImpl res = new XMIResourceImpl(URI.createURI((String)"http://www.eclipse.org/modeling/amalgam/downloads/discovery/helios/modeling.xmi"));
                try {
                    res.load(Collections.EMPTY_MAP);
                }
                catch (IOException e) {
                    String message = "We can't connect to the discovery source, make sure you're connected to internet and try again.";
                    MessageDialog.openError((Shell)window.getShell(), (String)"Can't connect to discovery source", (String)message);
                    throw new RuntimeException(e);
                }
                return (DiscoveryDefinition)res.getContents().get(0);
            }

            public String getDescription() {
                return "Pick a modeling component to install it.";
            }

            public String getTitle() {
                return "Eclipse Modeling Components Discovery";
            }
        };
        DiscoveryWizard wizard = new DiscoveryWizard(provider);
        WizardDialog dialog = new WizardDialog(window.getShell(), (IWizard)wizard);
        dialog.setMinimumPageSize(600, 400);
        dialog.open();
        return null;
    }
}

